/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TGenCollection
#include "tvtools.h"
#include "strings.h"



TGenCollection::TGenCollection( ccIndex aLimit, ccIndex aDelta )
                 :TStringCollection( aLimit, aDelta )
{
}


char *TGenCollection::getText( ccIndex index )
{
  return (char *) at(index);
}


int TGenCollection::compare( void *str1, void *str2 )
{
  return strcomp( (char *)str1, (char *)str2 );
}

int TGenCollection::getCount()
{
  return count;
}

int TGenCollection::getTextLength()
{
  int len = 0;
  for ( ccIndex i = 0; i < getCount(); i++ )
      len = max( len, strlen(getText(i)) );

  return len;
}



ccIndex TGenCollection::indexOf( char *item )
{
  for ( ccIndex i = 0; i < getCount(); i++ )
      if ( ! strcmp(item, getData(i)) ) return i;

  return ccNotFound;
}


ccIndex TGenCollection::indexOfText( char *item )
{
  for ( ccIndex i = 0; i < getCount(); i++ )
      if ( ! strcmp(item, getText(i)) ) return i;

  return ccNotFound;
}


void *TGenCollection::firstThat( ccTestFunc Test, void *arg )
{
    for ( ccIndex i = 0; i < getCount(); i++ )
        {
          char *data = getData(i);
          if ( Test(data, arg) ) return data;
        }
    return 0;
}


void *TGenCollection::firstTextThat( ccTestFunc Test, void *arg )
{
    for ( ccIndex i = 0; i < getCount(); i++ )
        {
          char *data = getText(i);
          if ( Test(data, arg) ) return data;
        }
    return 0;
}