/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include <bios.h>
#include <stdio.h>
#include <process.h>

#define Uses_MsgBox
#define Uses_TApplication

#include "tvtools.h"
#include "tools.h"


char *checkMsg = " \n\03Checking Floppy format...";

/***
 *
 *  Function   :    formatFloppy
 *
 *  Topics     :    Format a  floppy if needed.
 *
 *  Decisions  :    - Calls the DOS command FORMAT x: [/T:nn /N:nn] /V:""
 *                  - A check is performed after the format.
 *                  - If DOS version >= 4.0 use the /AUTOTEST switch
 *                    (undocumented) to skip prompt.
 *                  - If DOS version >= 5.0 use the /U switch
 *                    to speed up format.
 *
 *  Parameters :    in    int  floppy ( 0 = A:, 1 = B: )
 *
 *  Return     :    cmOK or cmCancel
 *
 ***/

ushort formatFloppy( int floppy )

{ if ( floppy < 0 || floppy > 1 ) return cmCancel;

  char buffer[512];
  int status;

  StatusBox( checkMsg );
  do status = biosdisk( 4, floppy, 0, 0, 1, 1, buffer );
  while ( status == 0x06 );
  RemoveStatusBox();

  if ( ! status ) return cmOK;  // already formatted

  char *density = "";

  if ( getdensity(floppy) == 1440 )
     {
       status = messageBox( "\03Is the Floppy a High Density one ?\n \n"
                            "\03(1.44 Mb)",
                            mfYesNoCancel
                          );
       if ( status == cmCancel ) return cmCancel;
       if ( status == cmNo ) density = "/N:9 /T:80";
     }

  sprintf( buffer, "format %c: %s /v:\"\"", floppy + 'A', density );
  if ( _osmajor >= 4 ) strcat( buffer, " /autotest" );  // Undocumented: no confirmation
// Bug of MS-DOS 5.0
//  if ( _osmajor >= 5 ) strcat( buffer, " /u" );         // To speed up format

  do { // Format floppy

       if ( (status == 0x03) &&
            messageBox( "\03Floppy is write-protected.\n \n"
                        "\03Correct and retry?",
                        mfOKCancel
                      ) != cmOK
          ) return cmCancel;

       if ( (status == 0x80) &&
            messageBox( "\03Floppy is not correctly inserted.\n \n"
                        "\03Correct and retry?",
                        mfOKCancel
                      ) != cmOK
          ) return cmCancel;

       StatusBox( checkMsg );
       appSystem( buffer );
       RemoveStatusBox();

       StatusBox( checkMsg );
       do status = biosdisk( 4, floppy, 0, 0, 1, 1, buffer );
       while ( status == 0x06 );
       RemoveStatusBox();

       if ( ! status ) return cmOK;

       if ( messageBox( "\03Floppy is not formatted.\n \n"
                        "\03Retry ?",
                        mfOKCancel
                      ) != cmOK
          ) return cmCancel;

     } while ( 1 );
}
