/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TComboBox
#include "tvtools.h"


#define cpComboWindow "\x13\x13\x15\x04\x05\x1A\x14"


TComboWindow::TComboWindow( const TRect& bounds, TGenCollection *aList ) :
	      TWindow( bounds, 0, wnNoNumber) ,
	      TWindowInit( &TComboWindow::initFrame )
{
  setState( sfShadow, False );
  flags = 0;

  TRect r = getExtent();
  r.a.x = r.b.x - 1;

  TScrollBar  *sb = new TScrollBar(r);
  insert( sb );

  r = getExtent();
  r.b.x--;

  viewer = new TComboViewer( r, aList, sb );
  insert( viewer );
}


TPalette& TComboWindow::getPalette() const
{
   static TPalette palette( cpComboWindow, sizeof(cpComboWindow)-1 );
   return palette;
}


void TComboWindow::getSelection( char *dest )
{
  viewer->getData( dest, viewer->focused, 255 );
}


void TComboWindow::handleEvent( TEvent& event )
{
  if ( (event.what == evMouseDown) && !containsMouse(event) )
     {
       endModal( cmCancel );
       clearEvent( event );
     }

  TWindow::handleEvent( event );
}
