/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TKeys
#define Uses_TComboBox
#include "tvtools.h"
#include "strings.h"
#include "tools.h"
#include <ctype.h>


#define cpComboViewer "\x06\x06\x07\x06\x06"

struct TComboViewerRec { TGenCollection *items;
                         ushort selection;
                       };


static Boolean matchChars( void *item, void *target )
{
  return strncomp((char *)item, (char *)target, strlen((char *)target)) == 0 ;
}


TComboViewer::TComboViewer( const TRect& bounds,
                            TGenCollection *aList,
                            TScrollBar *ts
                          ) :
	      TListViewer( bounds, 1, 0, ts )
{
  list = 0;
  newList( aList );
//  focused = list->indexOf( (char *)list->firstThat(matchChars, ((TComboBox*)(owner->owner))->link->data) );
}


TPalette& TComboViewer::getPalette() const

{
  static TPalette palette( cpComboViewer, sizeof(cpComboViewer)-1 );
  return palette;
}


void TComboViewer::getData( void * rec )

{
  TComboViewerRec *p = (TComboViewerRec *)rec;
  p->items = list;
  p->selection = focused;
}


void TComboViewer::getData( char *dest, short item, short maxLen )

{
  strncpy( dest, list->getData(item), maxLen );
  dest[maxLen] = '\0';
}


void TComboViewer::getText( char *dest, short item, short maxLen )

{
  strncpy( dest, list->getText(item), maxLen );
  dest[maxLen] = '\0';
}


void TComboViewer::handleEvent( TEvent& event )

{
  if ( (event.what == evMouseDown && event.mouse.doubleClick) ||
       (event.what == evKeyDown && event.keyDown.keyCode == kbEnter)
     )
     { endModal( cmOK );
       clearEvent( event );
       return;
     }

  if ( (event.what ==  evKeyDown && event.keyDown.keyCode == kbEsc) ||
       (event.what ==  evCommand && event.message.command ==  cmCancel)
     )
     { endModal( cmCancel );
       clearEvent( event );
       return;
     }

  static char testChar[255] = "";

  if ( event.what == evKeyDown )
     {
       if ( isprint(event.keyDown.charScan.charCode) )
          {
            // Add character to buffer string
            char *tempData = strend( testChar );
            *tempData++ = event.keyDown.charScan.charCode;
            *tempData = EOS;

            tempData = (char *)list->firstTextThat(matchChars, testChar);
            if ( tempData )
               focusItem( list->indexOfText(tempData) );
            else { testChar[strlen(testChar) - 1] = EOS;
                   buzzer();
                 }

            clearEvent( event );
            return;
          }
       else *testChar = EOS;
     }

  TListViewer::handleEvent( event );
}


void TComboViewer::newList( TGenCollection *aList )

{
   if ( list ) destroy( list );

   list = aList;

   setRange( aList->getCount() );

   if( range > 0 ) focusItem( 0 );

   drawView();
}


void TComboViewer::setData( void *rec )

{
  TComboViewerRec *p = (TComboViewerRec *)rec;
  newList( p->items );
  focusItem( p->selection );
  drawView();
}


void TComboViewer::shutDown()

{
  list = 0;
  TListViewer::shutDown();
}
