/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>


/***
 *
 *  Function   :    truename
 *
 *  Topics     :    Transforms a filename into a full reduced filename.
 *                  Resolves all SUBST's, JOIN's, network names,...
 *
 *  Parameters  :  in/out   char *filename    input/reduced filename
 *
 *  Warning    :    - Valid only for DOS >= 2.0
 *                  - Trailing '\' is not removed
 *
 *  Return code:    0      OK
 *                  2  Invalid syntax
 *                  3  Invalid drive or path
 ***/

int truename( char *filename )

{ int status;
  union REGS regs;
  struct SREGS sregs;
  char *ptr;

  for ( ptr = filename; *ptr; ptr ++ ) if ( *ptr == '/' ) *ptr = '\\';

        /*
        DOS Interrupt 60H
        Input:  DS:SI = pointer to filename
                ES:DI = pointer to hold 128 byte canonicalized filename
        Output: carry flag set if error and AX = error code
                if no error, ES:DI is filled in
        */

  sregs.ds  = FP_SEG( filename );
  regs.x.si = FP_OFF( filename );
  sregs.es  = FP_SEG( filename );
  regs.x.di = FP_OFF( filename );
  regs.h.ah = 0x60;
  status = intdosx( &regs, &regs, &sregs );

  if ( regs.x.cflag ) return status;

  return 0;
}
