/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <stdlib.h>
#include <direct.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>


/***
 *
 *  Function   :    fnreduce
 *
 *  Topics     :    Transforms a filename into a full reduced filename.
 *
 *  Parameters  :  in/out   char *filename    input/reduced filename
 *                  
 *  Return     :    pointer to result
 *
 ***/

char *fnreduce( char *filename )

{ char *ptr1, *ptr2;
  char drive[_MAX_DRIVE], dir[_MAX_DIR], file[_MAX_FNAME], ext[_MAX_EXT];

  for ( ptr1 = filename; *ptr1; ptr1 ++ ) if ( *ptr1 == '/' ) *ptr1 = '\\';

  _splitpath( filename, drive, dir, file, ext );

  if ( ! *drive ) sprintf( drive, "%c:", _getdrive() + 'A'- 1 );

  if ( *dir != '\\' ) { char buffer[_MAX_DIR];

                        strcpy( buffer, dir );
                        *dir = '\\';
                        getcurdir( toupper(*drive) - 'A' + 1, dir + 1 );
                        if ( *(dir + 1) )
                           {
                             strcat( dir, "\\" );
                             strcat( dir, buffer );
                           }
                      }

  for ( ptr1 = dir; *ptr1; ptr1++ )
      if ( *ptr1 == '.' )
         switch( *++ptr1 )
               {
                 case '.' : for ( ptr2 = ptr1 + 1, ptr1 -= 3; *ptr1 != '\\'; ptr1 -- );
                            strcpy( ptr1--, ptr2 );
                            break;

                 case '\0':
                 case '\\': strcpy( ptr1 - 2, ptr1 );
                            ptr1 -= 3;
                            break;

                 default  : break;
               }

  if ( (ptr1 == dir) || (*--ptr1 != '\\') ) strcat( ptr1, "\\" );

  _makepath( filename, drive, dir, file, ext );
  return strupr( filename );
}
