/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :  strrmstr
 *
 *  Description :  Removing all occurences of a target string.
 *
 *  Parameters  :  in/out   char  *string
 *                 in       char  *target     target string to remove
 *
 *  Decisions   :  Same implementation as strmvstr without copying
 *		   a replacement string.
 *		   Could also be implemented as
 *                        strmvstr( ptr, ptr, target, "" )
 *		   but should be less efficient.
 *
 *  Return code :  pointer to result.
 *
 *  OS/Compiler :  All
 ***/

char *strrmstr( char *string, const char *target )

{ char *ptr, *out;
  unsigned count = 0;

  for ( out = ptr = string; *out = *ptr; out++, ptr ++ )
      if ( *ptr == *target ) { target ++; count ++;
                               if ( ! *target )
			          { out -= count;
				    target -= count;
				  }
			      }
			 else { target -= count;
			        ptr -= count;
				out -= count;
				count = 0;
			      }

  return string;
}
