/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :   strelt
 *
 *  Description :   Return the n-th element (token) in a string.
 *		    The tokens are separated by several input character.
 *
 *  Decisions   :   If tokens are separated by ' ', '\t' or '\n',
 *		    the input characters will be " ".
 *		    If n-th token does not exist, an empty string is returned.
 *
 *  Parameters  :   out    char  *out_str      out string
 *		    in     char  *in_str       in string
 *		    out    char  *token        string containing token
 *		    in     int   element       element number
 *
 *  Return      :   pointer to the n-th token.
 *
 *  OS/Compiler :   All
 */

char *strelt( char *out_str, const char *in_str, char *token, int element )

{ char *ptr;

  strcpy( out_str, in_str );
  ptr = strtok( out_str, token );

  while ( (element > 1) && (ptr = strtok(NULL, token)) ) element --;

  if ( ptr ) strcpy( out_str, ptr );
	else *out_str = '\0';

  return out_str;

}                                              
