/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/*
 * Function   : strdelblk
 *
 * Description   : Remove all spaces, tab and eol before and after a string.
 *
 * Decisions  :
 *
 * Precond    :
 *
 * Postcond   :
 *
 */

char *strdelblk( char *string )

{ char *ptr = string, *str_begin = string, *str_end = NULL;

  /* skip blanks */
  ptr += strspn( string, " \t\n" );

  while ( 1 ) { switch( *string++ = *ptr++ )
                      {
                        case '\0': break;

                        case ' ' :
                        case '\t':
                        case '\n': str_end = NULL; continue;
                        default  : if ( ! str_end ) str_end = string;
                                   continue;
                      }
                break;
              }

  if ( str_end ) *str_end = '\0';

  return str_begin;
}
