/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"


/***
 *  Function    :  strcomp
 *
 *  Description :  Compare two strings case-insensitive
 *		   All special characters are translated (...)
 *
 *  Parameters  :  in   char  *str1
 *                 in   char  *str2
 *                 
 *  Return      :  -1 if str1 <  str2
 *		    1 if str1 >  str2
 *		    0 if str1 == str2
 *
 *  OS/Compiler :  All
 ***/

int strcomp( const char *str1, const char *str2 )

{
  for (; *str1 && *str2; str1++, str2++ )
      if ( chcase(*str1, 1) != chcase(*str2, 1) ) break;

  if ( chcase(*str1, 1) <  chcase(*str2, 1) ) return -1;
  if ( chcase(*str1, 1) >  chcase(*str2, 1) ) return  1;
  return 0;
}
