/***
 *  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)
 *
 *  File        :  check.h
 *
 *  Description :  General macros for testing pre- and post-conditions.
 *
 *  OS/Compiler :  All
 *
 *  Decisions   :  Will use the tracing if defined
 *
 *  Usage       :  - To check a precondition call the function 
 *                   'precond(  string_to_print, expression );'
 *
 *                 - Define 'PRE' to actually perform precondition check.
 *
 *                 - To check a postcondition call the function
 *                   'postcond(  string_to_print, expression );'
 *
 *                 - Define 'POST' to actually perform postcondition check.
 *
 *                 - To check a condition call the function
 *                   'check(  string_to_print, expression );'
 *
 *                 - Define 'CHECK' to actually perform check.
 *
 ***/


#ifndef __Check_H
#define __Check_H

#ifdef TRACE

#include "trace.h"
#define ch_trace		trace

#else

#define ch_trace( args )	printf args

#endif

		/*  MACROS DEFINITIONS  */


#ifdef PRE

#define precond( test , expr ) \
	if ( ! (expr) )							\
	   { printf( "\n" ) ;						\
	     ch_trace( ("*** " #test " : Precondition failed\n") ) ;	\
	     ch_trace( (" ** in file : " __FILE__ "\n") ) ;		\
	     ch_trace( (" ** at line : %d\n" , __LINE__) ) ;		\
	     ch_trace( (" ** '" #expr "' is false\n\n") ) ;		\
	   }

#else

#define precond( test , expr )

#endif

#ifdef POST

#define postcond( test , expr ) \
	if ( ! (expr) )							\
	   { printf( "\n" ) ;						\
	     ch_trace( ("*** " #test " : Postcondition failed\n") ) ;	\
	     ch_trace( (" ** in file : " __FILE__ "\n") ) ;		\
	     ch_trace( (" ** at line : %d\n" , __LINE__) ) ;		\
	     ch_trace( (" ** '" #expr "' is false\n\n") ) ;		\
	   }

#else

#define postcond( test , expr )

#endif

#ifdef CHECK

#define check( test , expr ) \
	if ( ! (expr) )							\
	   { printf( "\n" ) ;						\
	     ch_trace( ("*** " #test " : Check failed\n") ) ;		\
	     ch_trace( (" ** in file : " __FILE__ "\n") ) ;		\
	     ch_trace( (" ** at line : %d\n" , __LINE__) ) ;		\
	     ch_trace( (" ** '" #expr "' is false\n\n") ) ;		\
	   }

#else

#define check( test , expr )

#endif



#endif
