@echo off
IF NOT %1. == . GOTO HAVEPARM
  echo.
  echo Usage:  %0  filename
  echo.
  goto END
:HAVEPARM
rem   IF %MBDIR%.==.  SET MBDIR=\MASSBAL2
  cls
  type %MBDIR%\version.mb2
  echo.
  echo Batch Job Submission -- Phase 1 and 2
  echo.
  IF EXIST %MBDIR%\mb2log  DEL %MBDIR%\mb2log
  SET MBPPDB=%MBDIR%\mbppdb
  SET MBINFO=%MBDIR%\customer.mb2
  IF NOT EXIST %2\%1.dat GOTO NODATA
  echo.
  echo Input file: %2\%1.DAT
  SET MBDATA=%2\%1.dat
  SET MBTRAN=%2\%1.trn
  SET MBOUT=%2\%1.ph1
  echo. >> %MBDIR%\mb2log
  echo File: %2\%1 >> %MBDIR%\mb2log
  echo. >> %MBDIR%\mb2log
  echo.
  echo.
  echo Loading MASSBAL 2  Phase 1 ...
  echo.
  %MBDIR%\mb2ph1
  IF ERRORLEVEL 21 GOTO PH1CRASH
  IF ERRORLEVEL 13 GOTO PH1OK
  IF ERRORLEVEL 12 GOTO PH1FAIL
  IF ERRORLEVEL 11 GOTO PH1ONLY
  IF ERRORLEVEL 10 GOTO PH1OK
  IF ERRORLEVEL 7  GOTO PH1FAIL
  IF ERRORLEVEL 5  GOTO PH1OK
  IF ERRORLEVEL 4  GOTO COPYERR1
  IF ERRORLEVEL 3  GOTO PH1ONLY
  IF ERRORLEVEL 1  GOTO PH1OK
  :PH1CRASH
    ECHO Phase 1 FAILED  >> %MBDIR%\mb2log
    ECHO *** System Error *** >> %MBDIR%\mb2log
    ECHO Phase 2 cannot be run >> %MBDIR%\mb2log
    ECHO.
    pause
    GOTO QUIT
  :NODATA
    ECHO Phase 1 FAILED  >> %MBDIR%\mb2log
    ECHO Phase 2 cannot be run >> %MBDIR%\mb2log
    ECHO Could not find %2\%1.dat >> %MBDIR%\mb2log
    GOTO QUIT
  :PH1FAIL
    ECHO Phase 1 FAILED  >> %MBDIR%\mb2log
    ECHO Phase 2 cannot be run  >> %MBDIR%\mb2log
    ECHO Check Error messages in %2\%1.ph1 >> %MBDIR%\mb2log
    GOTO QUIT
  :PH1ONLY
    ECHO Phase 1 Completed >> %MBDIR%\mb2log
    ECHO Phase 2 not defined >> %MBDIR%\mb2log
    GOTO QUIT
  :COPYERR1
    ECHO Phase 1 FAILED  >> %MBDIR%\mb2log
    ECHO ******* Copy Protection Error ******* >> %MBDIR%\mb2log
    GOTO QUIT
  :PH1OK
    ECHO Phase 1 Completed >> %MBDIR%\mb2log
rem
rem  Continue with Phase 2
rem
  IF NOT EXIST %2\%1.trn  GOTO NOTRAN
  SET MBOUT=%2\%1.ph2
  echo.
  echo.
  echo Loading MASSBAL 2  Phase 2 ...
  echo.
  %MBDIR%\mb2ph2
  IF ERRORLEVEL 21 GOTO PH2CRASH
  IF ERRORLEVEL 20 GOTO PH2OK
  IF ERRORLEVEL 19 GOTO PH2ERR
  IF ERRORLEVEL 18 GOTO NOCONV
  IF ERRORLEVEL 5  GOTO PH2ERR
  IF ERRORLEVEL 4  GOTO COPYERR2
  IF ERRORLEVEL 3  GOTO NOCONV
  IF ERRORLEVEL 1  GOTO PH2OK
  :PH2CRASH
    ECHO Phase 2 FAILED  >> %MBDIR%\mb2log
    ECHO *** System Error *** >> %MBDIR%\mb2log
    GOTO QUIT
  :NOMEM
    ECHO Not enough memory to run PHASE 2  >> %MBDIR%\mb2log
    GOTO QUIT
  :COPYERR2
    ECHO Phase 2 FAILED  >> %MBDIR%\mb2log
    ECHO ******* Copy Protection Error ******* >> %MBDIR%\mb2log
    GOTO QUIT
  :NOTRAN
    ECHO Phase 2 FAILED  >> %MBDIR%\mb2log
    ECHO Could not find %2\%1.TRN >> %MBDIR%\mb2log
    GOTO QUIT
  :NOCONV
    ECHO Phase 2 FAILED  >> %MBDIR%\mb2log
    ECHO Model did not converge >> %MBDIR%\mb2log
    GOTO QUIT
  :PH2ERR
    ECHO Phase 2 Completed with errors >> %MBDIR%\mb2log
    ECHO Check Error messages in %2\%1.ph2 >> %MBDIR%\mb2log
    GOTO QUIT
  :PH2OK
    if exist %2\%1.trn del %2\%1.trn
    SET MBDATA=
    SET MBTRAN=
    SET MBOUT=
    SET MBPPDB=
    SET MBINFO=
    ECHO Phase 2 Completed Normally >> %MBDIR%\mb2log
    cls
    echo.
    echo ------------------------------------------------------------
    echo MASSBAL 2 Completed
    ECHO.
    if exist %mbdir%\mb2log TYPE %mbdir%\mb2log
    echo ------------------------------------------------------------
    echo.
    echo.
    echo To EXIT without returning to CADSIM, press and hold the
    echo "Ctrl" key while pressing the "C" key on your keyboard now.
    echo.
    echo To RETURN to CADSIM now,
    pause
    cls
    cadsim %1
:QUIT
if exist %2\%1.trn del %2\%1.trn
cls
echo.
echo ------------------------------------------------------------
echo MASSBAL 2 Ended
echo.
if exist %mbdir%\mb2log TYPE %mbdir%\mb2log
echo ------------------------------------------------------------
echo.
SET MBDATA=
SET MBTRAN=
SET MBOUT=
SET MBPPDB=
SET MBINFO=
:END
