

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef void* HACROAUTO;

typedef void* HACROAPP;
typedef void* HACROAVDOC;
typedef void* HACROPDDOC;
typedef void* HACROAVPAGEVIEW;
typedef void* HACROPDPAGE;
typedef void* HACROPDANNOT;	
typedef void* HACROPOINT;
typedef void* HACRORECT;
typedef void* HACROTIME;
typedef void* HACROPDTEXTSELECT;
typedef void* HACROHILITELIST;

//////////////////////////////////////////////////////////////////////////
// Libary Initialization Functions

// Note:
	// For Ole 2.0 programs, it is recommended that the line
	// SetMessageQueue(96) be places in you WinMain or InitInstance
	// code.  This line will clear the current message queue, so do it early

// this function must be called before the library can safely be used.
HACROAUTO AcroAutoInitialize();

// this function should be called to clean up resources when the caller is
// done with the library
void AcroAutoUninitialize(HACROAUTO hAcroAuto);

//////////////////////////////////////////////////////////////////////////
// AcroApp Functions
                    
HACROAPP AcroAppNew();
void AcroAppDelete(HACROAPP hAcroApp);
BOOL AcroAppExit(HACROAPP hAcroApp);
BOOL AcroAppHide(HACROAPP hAcroApp);
BOOL AcroAppShow(HACROAPP hAcroApp);
BOOL AcroAppCloseAllDocs(HACROAPP hAcroApp);
BOOL AcroAppMenuItemExecute(HACROAPP hAcroApp, LPCSTR szMenuItemName);
LPCSTR AcroAppGetActiveTool(HACROAPP hAcroApp);
BOOL AcroAppSetActiveTool(HACROAPP hAcroApp, LPCSTR szButtonName, BOOL bPersistent);
BOOL AcroAppToolButtonRemove(HACROAPP hAcroApp, LPCSTR szButtonName);
BOOL AcroAppToolButtonIsEnabled(HACROAPP hAcroApp, LPCSTR szButtonName);
BOOL AcroAppMenuItemRemove(HACROAPP hAcroApp, LPCSTR szMenuItemName);
BOOL AcroAppMenuItemIsEnabled(HACROAPP hAcroApp, LPCSTR szMenuItemName);
BOOL AcroAppMenuItemIsMarked(HACROAPP hAcroApp, LPCSTR szMenuItemName);
long AcroAppGetNumAVDocs(HACROAPP hAcroApp);
HACROAVDOC AcroAppGetAVDoc(HACROAPP hAcroApp, long nIndex);
HACROAVDOC AcroAppGetActiveDoc(HACROAPP hAcroApp);
LPCSTR AcroAppGetLanguage(HACROAPP hAcroApp);
BOOL AcroAppLock(HACROAPP hAcroApp,LPCSTR szLockedBy);
BOOL AcroAppUnlock(HACROAPP hAcroApp);
BOOL AcroAppSetPreference(HACROAPP hAcroApp, short nType, long nValue);
long AcroAppGetPreference(HACROAPP hAcroApp, short nType);
BOOL AcroAppMaximize(HACROAPP hAcroApp);
BOOL AcroAppSetFrame(HACROAPP hAcroApp, HACRORECT hAcroRect);
HACRORECT AcroAppGetFrame(HACROAPP hAcroApp);

//////////////////////////////////////////////////////////////////////////
// AcroPDDoc Functions

HACROPDDOC AcroPDDocNew();
void AcroPDDocDelete(HACROPDDOC hAcroPDDoc);
BOOL AcroPDDocOpen(HACROPDDOC hAcroPDDoc, const char* szFullPath);
BOOL AcroPDDocClose(HACROPDDOC hAcroPDDoc);
BOOL AcroPDDocInsertPages(HACROPDDOC hAcroPDDoc, long nInsertPageAfter, HACROPDDOC hPDDocSource, 
			long nStartPage, long nNumPages, BOOL bBookmarks);
BOOL AcroPDDocReplacePages(HACROPDDOC hAcroPDDoc, long nStartPage, HACROPDDOC hPDDocSource, 
			long nStartSourcePage, long nNumPages, BOOL bMergeTextAnnotations);
BOOL AcroPDDocDeletePages(HACROPDDOC hAcroPDDoc, long nStartPage, 
			long nEndPage);
long AcroPDDocGetNumPages(HACROPDDOC hAcroPDDoc);
BOOL AcroPDDocCreate(HACROPDDOC hAcroPDDoc);
LPCSTR AcroPDDocGetInfo(HACROPDDOC hAcroPDDoc, const char* szInfoKey);
BOOL AcroPDDocSetInfo(HACROPDDOC hAcroPDDoc, const char* szInfoKey, 
			const char* szBuffer);
BOOL AcroPDDocDeleteThumbs(HACROPDDOC hAcroPDDoc, long nStartPage, 
			long nEndPage);
BOOL AcroPDDocMovePage(HACROPDDOC hAcroPDDoc, long nMoveAfterThisPage, 
			long nPageToMove);
LPCSTR AcroPDDocGetFileName(HACROPDDOC hAcroPDDoc);
long AcroPDDocGetPageMode(HACROPDDOC hAcroPDDoc);
BOOL AcroPDDocSetPageMode(HACROPDDOC hAcroPDDoc, long nPageMode);
BOOL AcroPDDocCreateThumbs(HACROPDDOC hAcroPDDoc, long nFirstPage, 
			long nLastPage);
HACROPDTEXTSELECT AcroPDDocCreateTextSelect(HACROPDDOC hAcroPDDoc, 
			long nPage, HACRORECT hAcroRect);
HACROPDPAGE AcroPDDocAcquirePage(HACROPDDOC hAcroPDDoc, long nPage);
LPCSTR AcroPDDocGetInstanceID(HACROPDDOC hAcroPDDoc);
LPCSTR AcroPDDocGetPermanentID(HACROPDDOC hAcroPDDoc);
long AcroPDDocGetFlags(HACROPDDOC hAcroPDDoc);
BOOL AcroPDDocSetFlags(HACROPDDOC hAcroPDDoc, long nFlags);
HACROAVDOC AcroPDDocOpenAVDoc(HACROPDDOC hAcroPDDoc, const char* szTitle);
BOOL AcroPDDocSave(HACROPDDOC hAcroPDDoc, short nType, const char* szFullPath);

///////////////////////////////////////////////////////////////////////
// AcroAVDoc 

HACROAVDOC AcroAVDocNew();
void AcroAVDocDelete(HACROAVDOC hAcroAVDoc);
BOOL AcroAVDocOpen(HACROAVDOC hAcroAVDoc, const char* szFullPath, const char* szTempTitle);
HACROPDDOC AcroAVDocGetPDDoc(HACROAVDOC hAcroAVDoc);
HACROAVDOC AcroAVDocGetAVPageView(HACROAVDOC hAcroAVDoc);
BOOL AcroAVDocSetViewMode(HACROAVDOC hAcroAVDoc, long nType);
BOOL AcroAVDocFindText(HACROAVDOC hAcroAVDoc, const char* szText, BOOL bCaseSensitive, BOOL bWholeWordsOnly, BOOL bReset);
BOOL AcroAVDocClose(HACROAVDOC hAcroAVDoc, BOOL bNoSave);
long AcroAVDocGetViewMode(HACROAVDOC hAcroAVDoc);
BOOL AcroAVDocPrintPages(HACROAVDOC hAcroAVDoc, long nFirstPage, long nLastPage, long nPSLevel, BOOL bBinaryOk, BOOL bShrinkToFit);
BOOL AcroAVDocClearSelection(HACROAVDOC hAcroAVDoc);
BOOL AcroAVDocBringToFront(HACROAVDOC hAcroAVDoc);
LPCSTR AcroAVDocGetTitle(HACROAVDOC hAcroAVDoc);
BOOL AcroAVDocMaximize(HACROAVDOC hAcroAVDoc, BOOL bMaxSize);
BOOL AcroAVDocSetTitle(HACROAVDOC hAcroAVDoc, const char* szTitle);
BOOL AcroAVDocOpenInWindow(HACROAVDOC hAcroAVDoc, const char* szFullPath, short hWnd);
BOOL AcroAVDocSetTextSelection(HACROAVDOC hAcroAVDoc, HACROPDTEXTSELECT hAcroPDTextSelect);
BOOL AcroAVDocShowTextSelect(HACROAVDOC hAcroAVDoc);
BOOL AcroAVDocSetFrame(HACROAVDOC hAcroAVDoc, HACRORECT hAcroRect);
HACRORECT AcroAVDocGetFrame(HACROAVDOC hAcroAVDoc);
BOOL AcroAVDocIsValid(HACROAVDOC hAcroAVDoc);

////////////////////////////////////////////////////////////////////////////
// AcroAVPageView
//
//	There is no way to create this object directly so we don't need a New.
//	We do, however need the delete.
// 

void AcroAVPageViewDelete(HACROAVPAGEVIEW hAcroAVPageView);
BOOL AcroAVPageViewGoTo(HACROAVPAGEVIEW hAcroAVPageView, long nPage);
BOOL AcroAVPageViewZoomTo(HACROAVPAGEVIEW hAcroAVPageView, short nType, short nScale);
BOOL AcroAVPageViewScrollTo(HACROAVPAGEVIEW hAcroAVPageView, short nX, short nY);
BOOL AcroAVPageViewReadPageUp(HACROAVPAGEVIEW hAcroAVPageView);
BOOL AcroAVPageViewReadPageDown(HACROAVPAGEVIEW hAcroAVPageView);
BOOL AcroAVPageViewDoGoBack(HACROAVPAGEVIEW hAcroAVPageView);
BOOL AcroAVPageViewDoGoForward(HACROAVPAGEVIEW hAcroAVPageView);
HACROAVDOC AcroAVPageViewGetAVDoc(HACROAVPAGEVIEW hAcroAVPageView);
HACROPDPAGE AcroAVPageViewGetPage(HACROAVPAGEVIEW hAcroAVPageView);
HACROPDDOC AcroAVPageViewGetDoc(HACROAVPAGEVIEW hAcroAVPageView);
long AcroAVPageViewGetZoom(HACROAVPAGEVIEW hAcroAVPageView);
short AcroAVPageViewGetZoomType(HACROAVPAGEVIEW hAcroAVPageView);
long AcroAVPageViewGetPageNum(HACROAVPAGEVIEW hAcroAVPageView);
HACROPOINT AcroAVPageViewPointToDevice(HACROAVPAGEVIEW hAcroAVPageView, HACROPOINT hAcroPoint);
HACROPOINT AcroAVPageViewDevicePointToPage(HACROAVPAGEVIEW hAcroAVPageView, HACROPOINT hAcroPoint);

////////////////////////////////////////////////////////////////////////////
// AcroPDPage
//
//	There is no way to create this object directly so we don't need a New.
//	We do, however need the delete.
// 

void AcroPDPageDelete(HACROPDPAGE hAcroPDPage);
HACROPOINT AcroPDPageGetSize(HACROPDPAGE hAcroPDPage);
HACROPDANNOT AcroPDPageGetAnnot(HACROPDPAGE hAcroPDPage, long nIndex);
HACROPDANNOT AcroPDPageAddNewAnnot(HACROPDPAGE hAcroPDPage, long nIndexAddAfter, 
				const char* szSubType, HACRORECT hAcroRect);
BOOL AcroPDPageAddAnnot(HACROPDPAGE hAcroPDPage, long nIndexAddAfter, HACROPDANNOT hAcroPDAnnot);
BOOL AcroPDPageRemoveAnnot(HACROPDPAGE hAcroPDPage, long nIndex);
long AcroPDPageGetAnnotIndex(HACROPDPAGE hAcroPDPage, HACROPDANNOT hAcroPDAnnot);
long AcroPDPageGetNumAnnots(HACROPDPAGE hAcroPDPage);
HACROPDTEXTSELECT AcroPDPageCreatePageHilite(HACROPDPAGE hAcroPDPage, HACROHILITELIST hAcroHiliteList);
HACROPDTEXTSELECT AcroPDPageCreateWordHilite(HACROPDPAGE hAcroPDPage, HACROHILITELIST hAcroHiliteList);
HACROPDDOC AcroPDPageGetDoc(HACROPDPAGE hAcroPDPage);
long AcroPDPageGetNumber(HACROPDPAGE hAcroPDPage);
BOOL AcroPDPageDraw(HACROPDPAGE hAcroPDPage, short nHWND, short nHDC, short nXOrigin, short nYOrigin, short nZoom);
BOOL AcroPDPageSetRotate(HACROPDPAGE hAcroPDPage, short nRotate);
short AcroPDPageGetRotate(HACROPDPAGE hAcroPDPage);

////////////////////////////////////////////////////////////////////////////
// AcroPDAnnot
//
//	There is no way to create this object directly so we don't need a New.
//	We do, however need the delete.

void AcroPDAnnotDelete(HACROPDANNOT hAcroPDAnnot);
BOOL AcroPDAnnotIsValid(HACROPDANNOT hPDAnnot);
LPCSTR AcroPDAnnotGetSubtype(HACROPDANNOT hPDAnnot);
BOOL AcroPDAnnotIsEqual(HACROPDANNOT hAcroPDAnnot, HACROPDANNOT hAcroPDAnnot1);
long AcroPDAnnotGetColor(HACROPDANNOT hPDAnnot);
BOOL AcroPDAnnotSetColor(HACROPDANNOT hPDAnnot, long nRGBColor);
LPCSTR AcroPDAnnotGetTitle(HACROPDANNOT hPDAnnot);
BOOL AcroPDAnnotSetTitle(HACROPDANNOT hPDAnnot, const char* szTitle);
LPCSTR AcroPDAnnotGetContents(HACROPDANNOT hPDAnnot);
BOOL AcroPDAnnotSetContents(HACROPDANNOT hPDAnnot, const char* szContents);
BOOL AcroPDAnnotIsOpen(HACROPDANNOT hPDAnnot);
BOOL AcroPDAnnotSetOpen(HACROPDANNOT hPDAnnot, BOOL bIsOpen);
HACRORECT AcroPDAnnotGetRect(HACROPDANNOT hPDAnnot);
BOOL AcroPDAnnotSetRect(HACROPDANNOT hPDAnnot, HACRORECT hAcroRect);
HACROTIME AcroPDAnnotGetDate(HACROPDANNOT hPDAnnot);
BOOL AcroPDAnnotSetDate(HACROPDANNOT hPDAnnot, HACROTIME hAcroTime);
BOOL AcroPDAnnotPerform(HACROPDANNOT hPDAnnot, HACROAVDOC hAcroAVDoc);

///////////////////////////////////////////////////////////////////////
// AcroPoint

HACROPOINT AcroPointNew();
void AcroPointDelete(HACROPOINT hAcroPoint);
short AcroPointGetX(HACROPOINT hAcroPoint);
void AcroPointSetX(HACROPOINT hAcroPoint, short nX);
short AcroPointGetY(HACROPOINT hAcroPoint);
void AcroPointSetY(HACROPOINT hAcroPoint, short nY);

/////////////////////////////////////////////////////////////////////////////
// AcroRect

HACRORECT AcroRectNew();
void AcroRectDelete(HACRORECT hAcroRect);
short AcroRectGetLeft(HACRORECT hAcroRect);
void AcroRectSetLeft(HACRORECT hAcroRect, short nLeft);
short AcroRectGetTop(HACRORECT hAcroRect);
void AcroRectSetTop(HACRORECT hAcroRect, short nTop);
short AcroRectGetRight(HACRORECT hAcroRect);
void AcroRectSetRight(HACRORECT hAcroRect, short nRight);
short AcroRectGetBottom(HACRORECT hAcroRect);
void AcroRectSetBottom(HACRORECT hAcroRect, short nBottom);

/////////////////////////////////////////////////////////////////////////////
// AcroTime 

HACROTIME AcroTimeNew();
void AcroTimeDelete(HACROTIME hAcroTime);

short AcroTimeGetYear(HACROTIME hAcroTime);
void AcroTimeSetYear(HACROTIME hAcroTime, short nYear);
short AcroTimeGetMonth(HACROTIME hAcroTime);
void AcroTimeSetMonth(HACROTIME hAcroTime, short nMonth);
short AcroTimeGetDate(HACROTIME hAcroTime);
void AcroTimeSetDate(HACROTIME hAcroTime, short nDatej);
short AcroTimeGetHour(HACROTIME hAcroTime);
void AcroTimeSetHour(HACROTIME hAcroTime, short nHour);
short AcroTimeGetMinute(HACROTIME hAcroTime);
void AcroTimeSetMinute(HACROTIME hAcroTime, short nMinute);
short AcroTimeGetSecond(HACROTIME hAcroTime);
void AcroTimeSetSecond(HACROTIME hAcroTime, short nSecond);
short AcroTimeGetMillisecond(HACROTIME hAcroTime);
void AcroTimeSetMillisecond(HACROTIME hAcroTime, short nMillisecond);
short AcroTimeGetDay(HACROTIME hAcroTime);
void AcroTimeSetDay(HACROTIME hAcroTime, short nDay);

/////////////////////////////////////////////////////////////////////////////
// AcroPDTextSelect
//
//	There is no way to create this object directly so we don't need a New.
//	We do, however need the delete.
// 
void AcroPDTextSelectDelete(HACROPDTEXTSELECT hAcroPDTextSelect);
BOOL AcroPDTextSelectDestroy(HACROPDTEXTSELECT hPDTextSelect);
long AcroPDTextSelectGetNumText(HACROPDTEXTSELECT hPDTextSelect);
HACRORECT AcroPDTextSelectGetBoundingRect(HACROPDTEXTSELECT hPDTextSelect);
long AcroPDTextSelectGetPage(HACROPDTEXTSELECT hPDTextSelect);
LPCSTR AcroPDTextSelectGetText(HACROPDTEXTSELECT hPDTextSelect, long nTextIndex);

/////////////////////////////////////////////////////////////////////////////
// AcroHiLiteList 

HACROHILITELIST AcroHiLiteListNew();
void AcroHiLiteListDelete(HACROHILITELIST hAcroHiLiteList);
BOOL AcroHiLiteListAdd(HACROHILITELIST hAcroHiLiteList, short nOffset, short nLength);

#ifdef __cplusplus
}
#endif // __cplusplus
