
Sub FOpenProc ()
    Dim RetVal
    On Error Resume Next
    Dim OpenFileName As String
    frmMDI.CMDialog1.Filename = ""
    frmMDI.CMDialog1.DefaultExt = "pdf"
    frmMDI.CMDialog1.Filter = "PDF Files (*.pdf)|*.pdf"
    frmMDI.CMDialog1.Action = 1
    If Err <> 32755 Then 'user pressed cancel
	OpenFileName = frmMDI.CMDialog1.Filename
	OpenFile (OpenFileName)
	UpdateFileMenu (OpenFileName)
    End If
End Sub

Function GetFileName ()
    'Displays a Save As dialog and returns a file name
    'or an empty string if the user cancels
    On Error Resume Next
    frmMDI.CMDialog1.Filename = ""
    frmMDI.CMDialog1.DefaultExt = "pdf"
    frmMDI.CMDialog1.Filter = "PDF Files (*.pdf)|*.pdf"
    frmMDI.CMDialog1.Action = 2

    If Err <> 32755 Then      'User cancelled dialog
	GetFileName = frmMDI.CMDialog1.Filename
    Else
	GetFileName = ""
    End If
End Function

Function OnRecentFilesList (Filename) As Integer
  Dim i

  For i = 1 To 4
    If frmMDI.mnuRecentFile(i).Caption = Filename Then
      OnRecentFilesList = True
      Exit Function
    End If
  Next i
    OnRecentFilesList = False
End Function

Sub OpenFile (Filename)
    Dim fIndex As Integer

    ' change mousepointer to an hourglass
    screen.MousePointer = 11
    
    ' change form's caption and display new text
    fIndex = FindFreeIndex()
    document(fIndex).Tag = fIndex
    document(fIndex).Caption = UCase$(Filename)
    
    ' open the selected file
    Set AcroExchAVDoc(fIndex) = CreateObject("AcroExch.AVDoc")
    ok = AcroExchAVDoc(fIndex).OpenInWindow(Filename, document(fIndex).hWnd)
    If Not ok Then
	MsgBox "Can't open file: " + Filename
	Unload document(fIndex)
	screen.MousePointer = 0
	Exit Sub
    End If


    FState(fIndex).Dirty = False
    document(fIndex).Show
    
    ' reset mouse pointer
    screen.MousePointer = 0
End Sub

Sub SaveFileAs (Filename)
On Error Resume Next
    ' display hourglass
    screen.MousePointer = 11

    Dim nForm As Integer
    nForm = frmMDI.ActiveForm.Tag

    Dim AcroPDDoc As object
    Set AcroPDDoc = AcroExchAVDoc(nForm).GetPDDoc()
    ok = AcroPDDoc.Save(1, Filename)

    If Not ok Then
	MsgBox "Can't Save As file: " + Filename
	screen.MousePointer = 0
	Exit Sub
    End If

    ' reset the mousepointer
    screen.MousePointer = 0

    ' set the caption
    frmMDI.ActiveForm.Caption = UCase$(Filename)

    ' reset the dirty flag
    FState(nForm).Dirty = False
    
End Sub

Sub UpdateFileMenu (Filename)
	Dim RetVal
	' Check if OpenFileName is already on MRU list.
	RetVal = OnRecentFilesList(Filename)
	If Not RetVal Then
	  ' Write OpenFileName to MDINOTEPAD.INI
	  WriteRecentFiles (Filename)
	End If
	' Update menus for most recent file list.
	GetRecentFiles
End Sub

