// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "cviewer.h"

#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_QUERYENDSESSION()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_OPEN,
	ID_FILE_SAVE,
		ID_SEPARATOR,
	ID_FILE_PRINT,
	ID_APP_ABOUT,
	    ID_SEPARATOR,
    ID_VIEW_FIRSTPAGE,
    ID_VIEW_PREVPAGE,
    ID_VIEW_NEXTPAGE,
    ID_VIEW_LASTPAGE,
		ID_SEPARATOR,
	ID_TOOLS_HAND,
};       


static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	LastView = NULL;

	MainAcroApp = new CAcroApp; 
	COleException e;
	if (!MainAcroApp->CreateDispatch("AcroExch.App",&e)) 
		AfxMessageBox("Failed to create object :<");

}

CMainFrame::~CMainFrame()
{
	MainAcroApp->Exit();
	MainAcroApp->Unlock();
	delete MainAcroApp;
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,                  
		  sizeof(buttons)/sizeof(UINT)))
	{
		TRACE("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE("Failed to create status bar\n");
		return -1;      // fail to create
	}

	if (!MainAcroApp->Lock("CVIEWER2")) {
		AfxMessageBox("CViewer2 cannot run at this time.  The viewer is in use.");
		return -1;
 	}


	return 0;
}
 
 
/////////////////////////////////////////////////////////////////////////////
// CMainFrame public functions



/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
} 

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers



BOOL CMainFrame::OnQueryEndSession()
{
	if (!CMDIFrameWnd::OnQueryEndSession())
		return FALSE;
	
	// TODO: Add your specialized query end session code here
	if (!MDIGetActive(NULL))
		return TRUE;
	else {
		AfxMessageBox("Close all open documents, then exit Windows");
		return FALSE; 
	}
}