// cviewdoc.h : interface of the CCviewerDoc class
//
/////////////////////////////////////////////////////////////////////////////

#ifndef	_CVIEWDOC_H
#define _CVIEWDOC_H

class CAcroApp;
class CAcroAVDoc;
class CAcroPDPage;

class CCviewerDoc : public CDocument
{
protected: // create from serialization only
	CCviewerDoc();
	DECLARE_DYNCREATE(CCviewerDoc)

// Attributes
public:
protected:
	unsigned long 	NumPages;		// stores # of pages in this document
	CAcroAVDoc* 	m_pAcroAVDoc;

// Operations
public:
	void GotoPage(unsigned long NewPage);
    unsigned long GetCurrentPageNum();
	int GetCurrentZoomType();
	void SetCurrentZoomType(int NewType, int NewScale);
	void SetScale(int NewScale);
	void CloseAVDoc();
    
// Implementation
public:
	virtual ~CCviewerDoc();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	virtual BOOL OnOpenDocument(const char* pszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName);   	

// Generated message map functions
protected:
	//{{AFX_MSG(CCviewerDoc)
	afx_msg void OnUpdateViewFirstpage(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewLastpage(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewNextpage(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewPrevpage(CCmdUI* pCmdUI);
	afx_msg void OnViewFirstpage();
	afx_msg void OnViewLastpage();
	afx_msg void OnViewNextpage();
	afx_msg void OnViewPrevpage();
	afx_msg void OnViewActualsize();
	afx_msg void OnViewFitpage();
	afx_msg void OnViewFitwidth();
	afx_msg void OnUpdateViewFitpage(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewFitwidth(CCmdUI* pCmdUI);
	afx_msg void OnUpdateTools(CCmdUI* pCmdUI);                 
	afx_msg void OnToolsHand();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CCviewerDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()
};

 

#endif
/////////////////////////////////////////////////////////////////////////////
