// cviewvw.cpp : implementation of the CCviewerView class
//

#include "stdafx.h"
#include "cviewer.h"

#include "cviewdoc.h"
#include "cviewvw.h"
#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCviewerView

IMPLEMENT_DYNCREATE(CCviewerView, CScrollView)

BEGIN_MESSAGE_MAP(CCviewerView, CScrollView)
	//{{AFX_MSG_MAP(CCviewerView)
	ON_WM_SETFOCUS()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCviewerView construction/destruction

CCviewerView::CCviewerView()
{
	// Unhide extra toolbar items (Page # box, Zoom Button, Page # label) 
	((CMainFrame *)AfxGetApp()->m_pMainWnd)->ShowToolbarAddOns(TRUE);

	// Increment # of views counter stored by the main frame
	((CMainFrame *)AfxGetApp()->m_pMainWnd)->IncNumViews();
}
          
CCviewerView::~CCviewerView()
{

	// Decrement # of views counter stored by the main frame
	((CMainFrame *)AfxGetApp()->m_pMainWnd)->DecNumViews();

    // If there are no more views, hide extra toolbar items
	if (((CMainFrame *)AfxGetApp()->m_pMainWnd)->GetNumViews() == 0) {
		((CMainFrame *)AfxGetApp()->m_pMainWnd)->ShowToolbarAddOns(FALSE);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CCviewerView drawing

void CCviewerView::OnDraw(CDC* pDC)
{
	CCviewerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// Call document draw command with origin at the window's scroll pos
	pDoc->Draw(pDC, m_hWnd, GetScrollPosition());
}

/////////////////////////////////////////////////////////////////////////////
// CCviewerView printing

BOOL CCviewerView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CCviewerView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CCviewerView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CCviewerView diagnostics

#ifdef _DEBUG
void CCviewerView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CCviewerView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CCviewerDoc* CCviewerView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCviewerDoc)));
	return (CCviewerDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCviewerView message handlers


// called whenever view is focused on
void CCviewerView::OnSetFocus(CWnd* pOldWnd)
{
	CView::OnSetFocus(pOldWnd);

	// Setup last view variable in main frame to point to this view
	((CMainFrame *)AfxGetApp()->m_pMainWnd)->SetLastView(this);

	// Call Document to setup toolbar status boxes for this view
	GetDocument()->SetToolbarStatusBoxes();
}

  
// called when view first attatched to document
void CCviewerView::OnInitialUpdate()
{
	// setup document size for scroll bars    
	RECT ViewRect;
	GetClientRect((LPRECT) &ViewRect);
	SetScrollSizes(MM_TEXT, GetDocument()->GetScaledDocSize((ViewRect.right-ViewRect.left),(ViewRect.bottom-ViewRect.top)));
}
      

// called when window is resized       
void CCviewerView::OnSize(UINT nType, int cx, int cy)
{
	SetScrollSizes(MM_TEXT, GetDocument()->GetScaledDocSize(cx,cy));	
    GetDocument()->SetToolbarStatusBoxes();
	CScrollView::OnSize(nType, cx, cy);	
}
       

// called when view has been modified
void CCviewerView::OnUpdate(CView *, LPARAM UpdateBars, CObject *)
{
	// if necessary to update scroll bars:
	if ((BOOL) UpdateBars) {
		RECT ViewRect;
		GetClientRect((LPRECT) &ViewRect);
		SetScrollSizes(MM_TEXT, GetDocument()->GetScaledDocSize((ViewRect.right-ViewRect.left),(ViewRect.bottom-ViewRect.top)));		
	}
	CScrollView::OnUpdate(NULL,(LPARAM) 0, NULL);
}