/******************************************************************************
						Ole Automation DLL

This file is furnished to you by Adobe Systems Incorporated under the terms 
of the Adobe Agreement for Unreleased Products (Beta Site).
Copyright (C) 1994 by Adobe Systems Incorporated.  All rights reserved.

PURPOSE
	The DLL lets you use Acrobat Automation functions from a DLL.

*******************************************************************************/

#include "stdafx.h"
#include "acroauto.h"


/////////////////////////////////////////////////////////////////////////////
// Library init

class CAutomationDLL : public CWinApp
{
	BOOL m_bOleNeedTerm;
public:
	virtual BOOL InitInstance(); // Initialization
	virtual int ExitInstance();  // Termination (WEP-like code)

	CAutomationDLL(const char* pszAppName);
};

CAutomationDLL::CAutomationDLL(const char* pszAppName)
		: CWinApp(pszAppName)
{
	m_bOleNeedTerm = FALSE;
}

BOOL CAutomationDLL::InitInstance()
{		  
	// any DLL initialization goes here
	TRACE("CAutomationDLL initializing\n");
	SetDialogBkColor();     // grey dialogs in the DLL as well
	return TRUE;
}

int CAutomationDLL::ExitInstance()
{
	// any DLL termination goes here (WEP-like code)
	return CWinApp::ExitInstance();
}


// The following structure is used to keep track of connections that
// clients have to our dll.  
class CAcroAuto : public CObject {
public:
	BOOL m_bOleNeedTerm;
	CAcroAuto() { m_bOleNeedTerm = FALSE; }
};


//
// we can't initialize the ole libraries during the Init instance code
// since the alling applications message queue is not set up at the time
// this is called.  We must provide a separate initialization and clean up
// code
//
HACROAUTO _export AcroAutoInitialize()
{
	// check OLE build version (OLE 2.01a is 23.622)
	DWORD dwVersion = OleBuildVersion();
	if (HIWORD(dwVersion) != 23 || LOWORD(dwVersion) < 622)
	{
		TRACE0("Error: OLE 2.0 DLLs are NOT compatible.\n");
		return NULL;
	}

	CAcroAuto* pAcroAuto = new CAcroAuto();

	// Initialize OLE 2.0 libraries
	if (!AfxOleInit())
	{
		pAcroAuto->m_bOleNeedTerm = FALSE;
		TRACE0("OLE 2.0 DLLs assumed to be already initilized.\n");
		return pAcroAuto;
	}
	
	pAcroAuto->m_bOleNeedTerm = TRUE;
	return pAcroAuto;
}

void _export AcroAutoUninitialize(HACROAUTO hAcroAuto)
{
	CAcroAuto* pAcroAuto = (CAcroAuto*)hAcroAuto;
	
	if (pAcroAuto->m_bOleNeedTerm) {
		AfxOleTerm();
	}
}

CAutomationDLL  NEAR appAutomationDLL("AutoDll.dll");

/////////////////////////////////////////////////////////////////////////////
