#ifndef _LOADPCX_H
	#define _LOADPCX_H

/*	Header info extracted from USUAL.H: */

typedef int bool;

/*	Boolean values */

#define TRUE	1
#define FALSE	0

/*	Assembly variable terms */

#define byte unsigned char
#define word unsigned short
#define dword unsigned long

/*-------- end 'USUAL.H'-------- */


/*	VGA's palette structure	*/

struct VgaPalette
{
	byte red,green,blue;
};

/*	Simple structure to hold the decoded PCX image and data */

struct PcxPix
{
	word width,height;
	byte *image;
};

/*	load_pcx return values */

enum {
	pcx_ok = 0,
	pcx_invalid, /* not a valid 256-color PCX file */
	pcx_nomem,   /* ran out of memory */
	pcx_ferror,  /* file error occured */
	pcx_openerr  /* file error on open */
};

/*	256-color PCX load Function:
**
**	Decodes a PCX file, placing the info (and image) into 'pix'
**	It places the PCX file's 256-color palette into 'pal'
**
**	NOTE: pix->image will be dynamically allocated (via farmalloc), and
**	must be deleted (via farfree) by the caller
*/

extern int load_pcx(const char * name,
					struct PcxPix * pix,
					struct VgaPalette * pal);

#endif	/* _LOADPCX_H */
