 /********************************************************************
 * PC installer (aldsetup) control file for PageMaker 5.0a  1.44mb Disks
 * NETWORK INSTALLER control file.
 * Copyright (C) 1992 - 1993 Aldus Corporation.  All rights reserved.
 * Control file administrator: Dave Perkins
 ********************************************************************/

PRODUCT "PageMaker 5.0a"

VERSIONREQ "2.3"

ALDUSDIRECTORY "Aldus" "AdminLogDirectory" "C:\NetLog"


/********   DBUILD SECTION  ***********/




DISK "(1)"
   {
   (C)ALDUS.'93         62,
   ALDSETUP.EXE     274176  CHECKDATE,
   FDA_144.CTL       11406,
   VIKT_50a.WRI      33792,
   ALDIM3.DL~       245216  "ALDUS"  CHECKDATE  VITAL,
   ALAFTER.PS~        1246  "ALDUS\SVENSKA",
   ACQUIRE.AD~       57344  "ALDUS\SVENSKA\ADDITION"  CHECKDATE,
   LIBRARY.PA~      126976  "ALDUS\SVENSKA\ADDITION"  CHECKDATE,
   PANTONEC.BC~      51980  "ALDUS\SVENSKA\COLOUR"  CHECKDATE,
   PANTONEU.BC~      51980  "ALDUS\SVENSKA\COLOUR"  CHECKDATE,
   PCSGE.BC~        162950  "ALDUS\SVENSKA\COLOUR"  CHECKDATE,
   WP5IMP.FL~        45568  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   TWAINIMP.FL~      40368  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   RTFIMP.FL~        35486  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   CGMIMP.FL~        52496  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   EXCELIMP.FL~      62480  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   GIFIMP.FL~        13824  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   TEIMP.FL~         67504  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   PPD.EX~           88880  "ALDUS\SVENSKA\TILLBEH"  CHECKDATE,
   DEAPP.EX~        381248  "ALDUS\SVENSKA\TILLBEH"  CHECKDATE,
   PATCH.EX~         45928  "PM5"  CHECKDATE,
   TEAPP.EX~        272128  "PM5"  CHECKDATE,
   TABELLHA.WR~       3712  "PM5"  CHECKDATE,
   PATCH.RT~         34612  "PM5"  CHECKDATE,
   NETINST.EX~        8928  "NET"  CHECKDATE,
   UPDATNET.CTL      11558  "NET"  CHECKDATE,
   IEIMAGE.SR~       81719  "NET"  CHECKDATE,
   IEMAX.SR~         11897  "NET"  CHECKDATE,
   IEMIN.SR~         69669  "NET"  CHECKDATE,
   NETWORK.WRI       24064  "NET"  CHECKDATE
   }

/*********** DBUILD END ******************/

/*****   DIALOG & VARIABLE INITIALIZATION  *****/

INITIAL NetAldusDir "F:\NetAldus"
	{
	"Ange p vilken enhet och i vilken katalog du"
	"har installerat ntverkets Aldus-katalog tidigare."
	"Denna katalog skapas nr du installerar PageMaker"
	"5.0s ursprungliga ntverksinstallationsfiler."
	}

DIALOG BuffersWarning "&Fortstt" "&Avsluta"
{
	CAPTION "Lg instllning i BUFFERS"
	TEXT
	{
	"Aldus Installerare har upptckt att BUFFERS instllningen i"
	"CONFIG.SYS r under 20.  Du kan installera med nuvarande"
	"instllning men installationen gr snabbare om du kar vrdet"
	"och sedan startar om datorn."
	}
}

DIALOG PPDwarning "&OK"
{
	CAPTION "Vlj skrivardokument"
	TEXT
	{
	"Anm: Desto fler skrivardokument du vljer (tio eller fler),"
	"ju lngre tid tar det att ppna dialogrutan fr utskrift."
	"Vlj bara de skrivardokument du behver."
	"De skrivardokument du vljer fungerar tillsammans med Windows"
	"drivrutiner som finns p PageMaker-disketterna. Nr installationen"
	"r klar ombeds du att installera en drivrutin."
	}
}
INITIAL DiskImageDir "F:\PM5Bild"
	{
	"Ange p vilken enhet och i vilken katalog du"
	"redan har installerat bilderna av PageMakers"
	"disketter s att 5.0a-filerna kan uppdateras."
	""
	"Om detta r rtt katalog, klicka p OK."
	}
DIALOG LogFileLocation "OK" "Avbryt" 
{
	CAPTION "Installationsfakta"
	TEXT
	{
	"Skriv namnet p den enhet och katalog"
	"dr du vill att Installeraren ska spara"
	"installationsfakta."
	}
}

DIALOG LicWarn "&OK"
{
	CAPTION "Ntverkslicensavtal"
	TEXT
	{
	"Licensavtalet i denna produkt ger rtt till en anvndare"
	"av denna kopia av PageMaker. Om du inte har"
	"uppgraderat det licensavtalet till fler n en samtidig"
	"anvndare kommer det att vara brott mot licensavtalet"
	"om du distribuerar fler kopior av detta program, eller"
	"om du installerar det i ett ntverk fr flera anvndare."
	""
	"Denna programvara har en funktion fr att upptcka"
	"om antalet lagliga anvndare verskrids. Vid olaglig"
	"anvndning kan programmet inte startas."
	""
	"Mer information om ntverkslicenser kan du f genom"
	"att kontaka Aldus Sverige AB p tel. (08) 752 33 00." 
	}
}
DIALOG RightsWarn "&OK"
{
	CAPTION "Behrighet"
	TEXT
	{
	"Denna installation krver att du har behrighet"
	"som ntverksadministratr. Om inte filhanteraren"
	"har frberetts speciellt av ntverksadministratren"
	"fr ntverket kommer delade installationer inte att"
	"kunna utfras."
	""
	"Se textdokumentet NETWORK.WRI fr detaljer."
	""
	}
}

DIALOG SucRead "&OK"
{
	CAPTION "Installationen klar"
	TEXT
	{
	"Alla delar som du valt har installerats."
	" "
	"VIKTIG ANMRKNING:  Programmet PATCH.EXE har "
	"installerats i PageMaker-katalogen och mste kras fr "
	"att fullborda uppdateringen.  Filen mste kras frn "
	"DOS-lget av systemadministratren.  Avsluta Windows "
	"nu och kr programmet PATCH.EXE fr att uppdatera"
	"PageMaker 5.0 till 5.0a."
	}
}

DIALOG BumpEnable "&OK"
{
	CAPTION "Frbereder PM5 & Filhanteraren"
	TEXT
	{
	"Om WINBUMPS.EXE och ENABLSRV.EXE var Windows Apps" /* ACW ??? - leave at this point */
	"skulle de kras nu."
	"Se NETWORK.WRI fr mer information."
	}
}

/*********** INITIALIZATION END *************/


/*****   PACKAGE DEFINITION SECTION *********/


PACKAGE PROLOGUE "" SELECTED INVISIBLE
{
/***** Global Variable Declarations & System Min. Config Checks *****/
GETALDDIR AldDir LogFileLocation
GETBOOTDRIVE BootDrive
SET serialize "FALSE"

CONCAT BootDrive "CONFIG.SYS" ConfigFullName

FILEEXIST ConfigFullName ConfigYesorNo

IF ConfigYesorNo EQS "SUCCESS"
	{
	GETSYSVARVALUE ConfigFullName "BUFFERS" BufferAmount
	IF BufferAmount LT 20 
		{
		DISPLAY BuffersWarning BufferResponse
		IF  BufferResponse EQS "&Avsluta" 
			{
			EXIT
			}
		} 
	}

DISPLAY LicWarn
DISPLAY RightsWarn

}   /** End PROLOGUE **/

PACKAGE MaxNetAll "Uppdatering fr filhanteraren" SELECTED
	{
	CONFIRMDIR NetAldusDir MUSTEXIST
			 
			CONCAT NetAldusDir "SVENSKA" LangDir
			CONCAT LangDir "COLOUR" AColorDir
			CONCAT LangDir "PM5USER" UserDir
			FILES UserDir
				{
				"IEMAX.SR~\NETPM5.SRC"
				NETINST.EX~
				}
			 

	SET serialize "FALSE"
	
	CONCAT LangDir "FILTER" AFiltDir
	CONCAT AFiltDir "AFILTER" AddFiltDir
	CONCAT LangDir "ADDITION" AADDitionDir
	CONCAT UserDir "DRIVERS" UserDriversDir


	CONCAT AADDitionDir "MALLDOK" TemplateDir
	CONCAT TemplateDir "DATUM" CalDir
	CONCAT CalDir "DAGAR" DayDir
	CONCAT LangDir "PPD4" APPD4Dir
	CONCAT LangDir "TILLBEH" AUtilDir
	CONCAT AUtilDir "PSCRIPT" PSTDir

	CONCAT NetAldusDir "PM5" PM5Dir
	CONCAT PM5Dir "LEARNPM5" LearnDir
	CONCAT PM5Dir "PMSTUDIE" TutRootDir
	CONCAT PM5Dir "MANUSKRI" ScriptDir
	CONCAT TutRootDir "GRUNDER" TutExpDir
	CONCAT TutRootDir "LEKTION1" TutLess1Dir
	CONCAT TutRootDir "LEKTION2" TutLess2Dir

	/**** File Subdirectory Assignments *****/

		


	FILES NetAldusDir
		{
		ALDIM3.DL~
		}

	FILES LangDir
		{
		ALAFTER.PS~
		}


	FILES AUtilDir
		{
		PPD.EX~
		DEAPP.EX~        
		}

	FILES PM5Dir
		{
		NETWORK.WRI
		TEAPP.EX~        
		TABELLHA.WR~         
		PATCH.RT~
		PATCH.EX~
		}

	FILES AColorDir
		{
		PANTONEC.BC~      
		PANTONEU.BC~      
		PCSGE.BC~        
		}

	FILES AADDitionDir
		{
		ACQUIRE.AD~       
		LIBRARY.PA~      
		}

	FILES AfiltDir
		{
		WP5IMP.FL~        
/*		WP6IMP.FL~        */
		TWAINIMP.FL~      
		RTFIMP.FL~        
		CGMIMP.FL~        
		EXCELIMP.FL~      
		GIFIMP.FL~        
		TEIMP.FL~         
		}


	/**** Oninstall Commands ******/


	}  /***** END Server MAX Install *****/

PACKAGE BlankLine "----------------------------------------------------" UNSELECTED
{
SET Fred "Barney"
}

PACKAGE MinNet "Uppdatering fr filhanterare & hrddisk" UNSELECTED
{
	CONFIRMDIR NetAldusDir MUSTEXIST
			 
			CONCAT NetAldusDir "SVENSKA" LangDir
			CONCAT LangDir "COLOUR" AColorDir
			CONCAT LangDir "PM5USER" UserDir
			FILES UserDir
				{
				"IEMIN.SR~\NETPM5.SRC"
				NETINST.EX~
				}
			 
		 
	
	CONCAT LangDir "TILLBEH" AUtilDir
	CONCAT NetAldusDir "PM5" PM5Dir
	CONCAT UserDir "DRIVERS" UserDriversDir
	CONCAT UserDir "FILTER" UserFilterDir
	CONCAT UserFilterDir "AFILTER" UserAddFilterDir
	CONCAT UserDir	"ADDITION" UserAddDir
	CONCAT UserAddDir "MALLDOK" UserTemDir
	CONCAT UserTemDir "DATUM" UserCalDir
	CONCAT UserCalDir "DAGAR" UserDayDir
	CONCAT UserDir "PPD4" UserPPD4Dir
	CONCAT PM5Dir "LEARNPM5" LearnDir
	CONCAT PM5Dir "PMSTUDIE" TutRootDir
	CONCAT PM5Dir "MANUSKRI" ScriptDir
	CONCAT TutRootDir "GRUNDER" TutExpDir
	CONCAT TutRootDir "LEKTION1" TutLess1Dir
	CONCAT TutRootDir "LEKTION2" TutLess2Dir

	/**** File Subdirectory Assignments *****/

	FILES NetAldusDir
		{
		ALDIM3.DL~
		}

	FILES UserAddDir NODECOMPRESS
		{
		ACQUIRE.AD~       
		LIBRARY.PA~      
		}

	FILES UserFilterDir NODECOMPRESS
		{
		WP5IMP.FL~        
/*		WP6IMP.FL~        */
		TWAINIMP.FL~      
		RTFIMP.FL~        
		CGMIMP.FL~        
		EXCELIMP.FL~      
		GIFIMP.FL~        
		TEIMP.FL~         
		}

	FILES LangDir
		{
		ALAFTER.PS~
		}

	FILES AColorDir
		{
		PANTONEC.BC~      
		PANTONEU.BC~      
		PCSGE.BC~        
		}

	FILES AUtilDir
		{
		PPD.EX~
		DEAPP.EX~
		}

	FILES PM5Dir
		{
		NETWORK.WRI
		TEAPP.EX~        
		TABELLHA.WR~         
		PATCH.RT~
		PATCH.EX~
		}


/**** Oninstall Commands ******/


	}  /***** END Server MIN Install *****/

PACKAGE BlankLine "----------------------------------------------------" UNSELECTED
{
SET Fred "Barney"
}

PACKAGE ImageNet "Disketter p filhanteraren" UNSELECTED
{
	CONFIRMDIR DiskImageDir MUSTEXIST

	CONCAT DiskImageDir "Disk1" Disk1Dir
	CONCAT DiskImageDir "Disk2" Disk2Dir
	CONCAT DiskImageDir "Disk3" Disk3Dir
	CONCAT DiskImageDir "Disk4" Disk4Dir
	CONCAT DiskImageDir "Disk5" Disk5Dir
	CONCAT DiskImageDir "Disk6" Disk6Dir
	CONCAT DiskImageDir "Disk7" Disk7Dir

			FILES DiskImageDir
			   {
			   "IEIMAGE.SR~\PM5_NET.CTL"
			   }
			FILES Disk6Dir NODECOMPRESS
			   {
			   ALAFTER.PS~  
			   ACQUIRE.AD~ 
			   LIBRARY.PA~ 
			   }	
	SET serialize "FALSE"




	/**** File Subdirectory Assignments *****/


FILES Disk1Dir NODECOMPRESS
   {
   VIKT_50A.WRI
   NETWORK.WRI 
   }

FILES Disk2Dir 
   {
   PATCH.RT~
   PATCH.EX~
   ALDIM3.DL~
   }

FILES Disk3Dir NODECOMPRESS  
   {
   PCSGE.BC~   
   PANTONEC.BC~
   PANTONEU.BC~
   }

FILES Disk4Dir NODECOMPRESS
   {
   TEAPP.EX~        
   TABELLHA.WR~         
   WP5IMP.FL~        
/*   WP6IMP.FL~        */
   TWAINIMP.FL~      
   RTFIMP.FL~        
   CGMIMP.FL~        
   EXCELIMP.FL~      
   GIFIMP.FL~        
   TEIMP.FL~         
   PPD.EX~      
   DEAPP.EX~   
   }


	
}  /***** END Server MIN Install *****/


PACKAGE LastOninstalls "" SELECTED INVISIBLE
{
	/***  Stuff to be done after all other ONINSTALL's are completed ***/
	
	ONINSTALL
		{
		DISPLAY SucRead
		}
}
/*****
	Use EPILOGUE only for options which should be run when the
	user clicks the EXIT button from ALDSETUP

PACKAGE EPILOGUE "" UNSELECTED INVISIBLE
	 {
SET Fred "Barney" 
	}
*****/

/********* PACKAGE END ************/
