/********************************************************************
 * PC installer (aldsetup) control file for PageMaker 5.0  1.44mb Disks
 * Copyright (C) 1992 - 1993 Aldus Corporation.  All rights reserved.
 * Control file administrator: Dave Perkins
 ********************************************************************/

PRODUCT "PageMaker 5.0a"

VERSIONREQ "2.3"

ALDUSDIRECTORY "Aldus" "AldusDirectory" "C:\ALDUS"


/********   DBUILD SECTION  ***********/




DISK "(1)"
   {
   (C)ALDUS.'93         62,
   ALDSETUP.EXE     274176  CHECKDATE,
   FDA_144.CTL       11406,
   VIKT_50a.WRI      33792,
   ALDIM3.DL~       245216  "ALDUS"  CHECKDATE  VITAL,
   ALAFTER.PS~        1246  "ALDUS\SVENSKA",
   ACQUIRE.AD~       57344  "ALDUS\SVENSKA\ADDITION"  CHECKDATE,
   LIBRARY.PA~      126976  "ALDUS\SVENSKA\ADDITION"  CHECKDATE,
   PANTONEC.BC~      51980  "ALDUS\SVENSKA\COLOUR"  CHECKDATE,
   PANTONEU.BC~      51980  "ALDUS\SVENSKA\COLOUR"  CHECKDATE,
   PCSGE.BC~        162950  "ALDUS\SVENSKA\COLOUR"  CHECKDATE,
   WP5IMP.FL~        45568  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   TWAINIMP.FL~      40368  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   RTFIMP.FL~        35486  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   CGMIMP.FL~        52496  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   EXCELIMP.FL~      62480  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   GIFIMP.FL~        13824  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   TEIMP.FL~         67504  "ALDUS\SVENSKA\FILTER"  CHECKDATE,
   PPD.EX~           88880  "ALDUS\SVENSKA\TILLBEH"  CHECKDATE,
   DEAPP.EX~        381248  "ALDUS\SVENSKA\TILLBEH"  CHECKDATE,
   PATCH.EX~         45928  "PM5"  CHECKDATE,
   TEAPP.EX~        272128  "PM5"  CHECKDATE,
   TABELLHA.WR~       3712  "PM5"  CHECKDATE,
   PATCH.RT~         34612  "PM5"  CHECKDATE,
   NETINST.EX~        8928  "NET"  CHECKDATE,
   UPDATNET.CTL      11558  "NET"  CHECKDATE,
   IEIMAGE.SR~       81719  "NET"  CHECKDATE,
   IEMAX.SR~         11897  "NET"  CHECKDATE,
   IEMIN.SR~         69669  "NET"  CHECKDATE,
   NETWORK.WRI       24064  "NET"  CHECKDATE
   }

/*********** DBUILD END ******************/


/*****   DIALOG & VARIABLE INITIALIZATION  *****/

INITIAL PM5Dir "C:\PM5"
	{
	"Skriv namnet p den enhet och katalog dr"
	"du redan har installerat Aldus PageMaker 5.0."
	" "
	"Om detta r rtt katalog klickar du p OK."
	}


DIALOG PMNotInstalled "&Avsluta"
  {
	CAPTION "PageMaker 5.0 har inte installerats"
	TEXT
	{
	"Fr att uppdatera Aldus PagerMaker 5.0 till 5.0a"
	"mste du redan ha installerat PageMaker 5.0."
	"Instllningarna i  WIN.INI anger att detta program"
	"inte finns installerat."
	" "
	"Avsluta denna installation, installera Aldus PageMaker 5.0"
	"och fortstt sedan med uppdateringen."
	}
  }

DIALOG AldusLocation "OK" "Avbryt" 
{
	CAPTION "Skapa Aldus-katalog"
	TEXT
	{
	"Skriv namnet p den enhet och katalog dr"
	"du vill installera Aldus-filerna. Denna katalog"
	"kommer att anvndas av alla Aldus-produkter"
	"fr gemensamma filer som lexikon och filter."
	}
}

DIALOG BuffersWarning "&Fortstt" "&Avsluta"
{
	CAPTION "Lg instllning i BUFFERS"
	TEXT
	{
	"Aldus Installerare har upptckt att BUFFERS instllningen i"
	"CONFIG.SYS r under 20.  Du kan installera med nuvarande"
	"instllning men installationen gr snabbare om du kar vrdet"
	"och sedan startar om datorn."
	}
}

DIALOG AcquireQuest "&Ja" "&Nej"
{
	CAPTION "Ls in bild..."
	TEXT
	{
	"Vill du installera Additionen ""Ls in bild..."" "
	"och tillhrande monteringsfilter fr att lsa in TWAIN-bilder"
	"p din hrddisk?"
	}
}


DIALOG SucRead "&OK"
{
	CAPTION "Installationen klar"
	TEXT
	{
	"Alla delar du har valt har installerats."
	" "
	"VIKTIG ANMRKNING:  Filen PATCH.EXE har installerats"
	"i PageMaker-katalogen och mste kras fr att uppdateringen"
	"ska fullbordas.  Denna fil mste kras ifrn DOS-promten."
	"Dubbelklicka p textdokumentet Viktigt 5.0a fr mer information."
	}
}

DIALOG NetAldusInstalled "&Avsluta"
{
	CAPTION "Ntverksversion finns"
	TEXT
	{
	"Installeraren har hittat en instllning fr "
	"NetAldusDirectory i WIN.INI-filen vilket antyder att en"
	"ntverksversion av en Aldus-produkt finns installerad."
	"Denna installation kommer bara att installera en version. "
	"p den lokala hrddisken. Mer informationen om att uppdatera"
	"ntverk finns i textdokumentet om ntverksinstallation."
	""	
	}
}

DIALOG SucNoRead "&OK"
{
	CAPTION "Installationen klar"
	TEXT
	{
	"Alla delar du har valt har installerats."
	" "
	"Du kan nu avsluta detta program eller vlja att lsa den"
	"information som finns i Kontrollera- eller Visa-menyn"
	"i Aldus Installerare."
	}
}

/*********** INITIALIZATION END *************/


/*****   PACKAGE DEFINITION SECTION *********/


PACKAGE PROLOGUE "" SELECTED INVISIBLE
{
/***** Global Variable Declarations & System Min. Config Checks *****/

/*  We are checking here to find out if PM5 is installed and
    what language is installed.  IF PM isn't installed, we should
    quit the install, if it is, copy the filters into the appropriate
    dir. 
*/
GETWININIENTRY "ALDUS" "PM5AppDir" PM5Dir
GETWININIENTRY "ALDUS" "AldusDirectory" AldDir
GETWININIENTRY "ALDUS" "PM5LangDir" PM5LangDir
GETWININIENTRY "Aldus" "NetAldusDirectory" NetDirVar

IF NetDirVar NES "NOT_SET"
	{
	IF NetDirVar NES "NONE"
		{
		DISPLAY NetAldusInstalled
		EXIT
		}
	}


IF PM5Dir EQS "NOT_SET"
   {
   DISPLAY PMNotInstalled 
   EXIT
   }

IF PM5Dir NES "NOT_SET"
	{
        CONCAT PM5Dir "PM5.exe" FullPMName
	FILEEXIST FullPMName IsPmThere
	IF IsPmThere NES "SUCCESS"
		{
		DISPLAY PMNotInstalled 
		EXIT
		}
	}

IF AldDir EQS "NOT_SET"
   {
   DISPLAY PMNotInstalled 
   EXIT
   }

IF PM5LangDir EQS "NOT_SET"
   {
   DISPLAY PMNotInstalled 
   EXIT
   }

GETBOOTDRIVE BootDrive
GETWINDIR WinDir
GETWINSYSDIR WinSysDir
SET EverythingInstalled "FALSE"

CONCAT BootDrive "CONFIG.SYS" ConfigFullName

FILEEXIST ConfigFullName ConfigYesorNo

IF ConfigYesorNo EQS "SUCCESS"
	{
	GETSYSVARVALUE ConfigFullName "BUFFERS" BufferAmount
	IF BufferAmount LT 20 
		{
		DISPLAY BuffersWarning BufferResponse
		IF  BufferResponse EQS "&Avsluta" 
			{
			EXIT
			}
		} 
	}

}   /** End PROLOGUE **/

PACKAGE InstallEverything "Installera allt" SELECTED
	{
	/**** Package Initializations *****/

	CONCAT AldDir PM5LangDir LangDir
	CONCAT LangDir "FILTER" FiltDir
	CONCAT LangDir "SETUP" SetupDir
	CONCAT LangDir "FILTER" FiltDir
	CONCAT LangDir "ADDITION" AADDitionDir
	CONCAT LangDir "TILLBEH" AUtilDir
	CONCAT LangDir "COLOUR" AColorDir
 
	

	/**** File Subdirectory Assignments *****/

	FILES AldDir     
		{
		ALDIM3.DL~
		}

	FILES FiltDir
		{
		WP5IMP.FL~        
/*		WP6IMP.FL~        */
		TWAINIMP.FL~      
		RTFIMP.FL~        
		CGMIMP.FL~        
		EXCELIMP.FL~      
		GIFIMP.FL~        
		TEIMP.FL~         
		}

	FILES AColorDir
		{
		PANTONEC.BC~      
		PANTONEU.BC~      
		PCSGE.BC~        
		}

	FILES AADDitionDir
		{
		ACQUIRE.AD~       
		LIBRARY.PA~      
		}

	FILES LangDir
		{
		ALAFTER.PS~         
		}

	FILES AUtilDir
		{
		PPD.EX~           
		DEAPP.EX~        
		}

	FILES PM5Dir
		{
		VIKT_50A.WRI
		PATCH.EX~         
		TEAPP.EX~        
		TABELLHA.WR~         
		PATCH.RT~         
		}

	/**** end File Subdirectory Assignments ****/



	/**** INI Initializations ****/

	SET EverythingInstalled "TRUE"

	/**** INI Settings ****/

	/*** Oninstall initializations ***/

	CONCAT PM5Dir "VIKT_50A.WRI" ReadMeName		    
	CONCAT WinDir "WRITE.EXE" WriteName /* ACW check this for local system */

	/**** Oninstall Commands ******/

	ONINSTALL
		{
		DELETEPROGRAMITEM "Aldus" "Viktigt 5.0a"
  

		ADDPROGRAMITEM "Aldus" ReadMeName "Viktigt 5.0a" WriteName 0	

		}	/** End Oninstall **/

	}	/***** END PageMaker Easy Install *****/


PACKAGE BlankLine "----------------------------------------------------" UNSELECTED
{
SET Fred "Barney"
}

PACKAGE PageMaker "PageMaker 5.0a uppdatering" UNSELECTED
	{
	/**** Package Initializations *****/

	CONCAT AldDir PM5LangDir LangDir
	CONCAT LangDir "FILTER" FiltDir
	CONCAT LangDir "SETUP" SetupDir
	CONCAT LangDir "FILTER" FiltDir
	CONCAT LangDir "ADDITION" AADDitionDir
	CONCAT LangDir "TILLBEH" AUtilDir
	CONCAT LangDir "COLOUR" AColorDir

	/**** File Subdirectory Assignments *****/

	FILES AldDir     
		{
		ALDIM3.DL~
		}

	FILES AColorDir
		{
		PANTONEC.BC~      
		PANTONEU.BC~      
		PCSGE.BC~        
		}

	FILES AUtilDir
		{
		PPD.EX~           
		DEAPP.EX~        
		}

	FILES LangDir
		{
		ALAFTER.PS~         
		}

	FILES PM5Dir
		{
		VIKT_50A.WRI
		PATCH.EX~         
		TEAPP.EX~        
		TABELLHA.WR~         
		PATCH.RT~         
		}


	/**** end File Subdirectory Assignments ****/





	/*** Oninstall initializations ***/

	CONCAT PM5Dir "VIKT_50A.WRI" ReadMeName		    
	CONCAT WinDir "WRITE.EXE" WriteName /* ACW - check local system */

	/**** Oninstall Commands ******/

	ONINSTALL
		{
		IF EverythingInstalled EQS "FALSE"
			{
			DELETEPROGRAMITEM "Aldus" "Viktigt 5.0a"
  

			ADDPROGRAMITEM "Aldus" ReadMeName "Viktigt 5.0a" WriteName 0	
			SET EverythingInstalled "TRUE"
			}
		}	/** End Oninstall **/

	}	/***** END PageMaker *****/


PACKAGE AddsFilts "Additions/Filter-uppdatering" UNSELECTED
	{
	/**** Package Initializations *****/

	CONCAT AldDir PM5LangDir LangDir
	CONCAT LangDir "FILTER" FiltDir
	CONCAT LangDir "SETUP" SetupDir
	CONCAT LangDir "FILTER" FiltDir
	CONCAT LangDir "ADDITION" AADDitionDir
	CONCAT LangDir "TILLBEH" AUtilDir
	CONCAT LangDir "COLOUR" AColorDir

	/**** File Subdirectory Assignments *****/

	DISPLAY AcquireQuest AcquireResponse
	IF AcquireResponse EQS "&Ja"
		{
		FILES FiltDir
			{
			TWAINIMP.FL~      
			}

		FILES AADDitionDir
			{
			ACQUIRE.AD~       
			LIBRARY.PA~      
			}
		}
		
	SELECT1 "Vlj filter" FiltDir
		{
		TEXT
			{
			"Markera de filter du vill installera:"
			}
		ITEMS
			{
			CGMIMP.FL~ "CGM bildmontering",	  
			EXCELIMP.FL~ "Excel kalkylblad montering",	   
			GIFIMP.FL~ "GIF bildmontering",	   
			RTFIMP.FL~ "Rich Text Format (RTF) montering",
			TEIMP.FL~ "Tabellhanteraren montering",
/*			WP6IMP.FL~ "WordPerfect 6.X montering",*/
			WP5IMP.FL~ "WordPerfect 5.X montering"
			}
		HELP
			{
			"PageMaker anvnder filter fr att verfra"
			"och montera filer till och frn andra program."
			" "
			"Markera flera filter genom att hlla ned Ctrl"
			"och klicka p filtrets namn. Du kan installera"
			"fler filter nr som helst."
			}

		}  /*** End Select Filters ****/


	}   /*** END AddsFilts Package ***/


PACKAGE LastOninstalls "" SELECTED INVISIBLE
	{

	ONINSTALL
		{
		IF EverythingInstalled EQS "TRUE"
			{
			DISPLAY SucRead 
			}
		IF EverythingInstalled EQS "FALSE"
			{
			DISPLAY SucNoRead 
			}
			
		}  /**** End Oninstall ****/

	}  /***** End LastOninstalls ****/




/****
	Use EPILOGUE only for options which should be run when the
	user clicks the EXIT button from ALDSETUP

PACKAGE EPILOGUE "" UNSELECTED INVISIBLE
    {
        DISPLAY RebootReminder

    }
****/

