Program filefix;

Uses Dos, Crt;

Type

  FileStat=
   (notval,                       { if file is NOT validated }
    isrequest,                    { if file is REQUEST }
    resumelater);                 { if file is RESUME-LATER }

  ULFrec=                         { *.DIR : File records }
  record
    filename:string[12];          { Filename }
    description:string[60];       { File description }
    filepoints:integer;           { File points }
    nacc:integer;                 { Number DLs }
    ft:byte;                      { File type (useless?) }
    blocks:integer;               { # 128 byte blks }
    owner:integer;                { ULer of file }
    stowner:string[36];           { ULer's name }
    date:string[8];               { Date ULed }
    daten:integer;                { Numeric date ULed }
    vpointer:longint;             { Pointer to verbose descr, -1 if none }
    filestat:set of filestat;     { File status }
    priv:boolean;                 { private for someone? }
    privfor:string[8];            { a short string of who its for }
  end;

Var
  DirInfo:SearchRec;
  DirRec:File of ULFrec;
  Dir:ULFrec;
  Pos:Integer;

Procedure Fix(Filename:String);
Begin
  Assign(DirRec, FileName);
  reset(DirRec);
  For Pos:=1 to FileSize(DIrRec) do
  Begin
    Seek(DirRec, Pos);
    Read(DirRec, Dir);
    Dir.Priv:=FALSE;
    Dir.PrivFor:='';
    Seek(DirRec, Pos);
    Write(DirRec,Dir);
  End;
  Close(DirRec);
End;

Begin
  Writeln('Imp File-Fix v1 by Nivenh');
  Writeln;
  Writeln('Changing *ALL* files to non-private');
  FindFirst('*.DIR', AnyFile, DirInfo); { Same as DIR *.DIR }
  while DosError = 0 do
  begin
    Fix(DirInfo.Name);
    FindNext(DirInfo);
  end;
  Writeln('Done.');
End.