Echo Off

REM  Program Name: LRW0090.BAT
REM
REM  Description : Upgrade Focus Inquiry to use the Hydra Script
REM                and line settings.
REM
REM  PVCS  BY   Description
REM  1.0   PBH  Initial Implementation.
REM

:Begin
  IF Not Exist LISSS20.DTA goto StartUpgrade
  CLS
  ECHO Libra International 2.00 systems cannot be upgraded using
  ECHO this software.  Please call Airborne's Customer Automation
  ECHO Support (1-800-IAM-HELP) for Upgrade assistance.
  GOTO END

:StartUpgrade

  REM Backup the 7171 files, if they haven't been backed up yet.
  IF Not Exist AE7171.Ctl    Copy AESCRIPT.CTL  AE7171.CTL > Nul
  IF Not Exist AEPH7171.STM  Copy AEPHONE.STM   AEPH7171.STM > Nul
  IF Not Exist LSSCM20.EXE  GOTO Continue
  Copy LSSCM20.EXE LSSCM10.EXE > Nul
  ERASE LSSCM20.EXE > nul

:Continue
  REM Make the Hydra files active.
  COPY AE3000.CTL    AESCRIPT.CTL > Nul
  COPY AEPH3000.STM  AEPHONE.STM  > Nul

  REM Create the Set3000.Ctl file.
  Echo Set3000.Ctl > Set3000.ctl

  ECHO Online / Focus Inquiry upgrade is complete.

:End
