		/*-----------------------------+
		|	    qecon.h	       |
		+------------------------------+
		|     QECON include file       |
		+-----------------------------*/

/*--------------------------------------------------------------+
|  Copyright: 1990-1994 Q+E Software, Inc.			|
|								|
|	This software contains confidential and proprietary	|
|	information of Q+E Software, Inc.			|
+--------------------------------------------------------------*/
#if defined (__cplusplus)
extern "C" {
#endif

/* NOTE: You must includes windows.h before including qecon.h */
#ifdef __BORLANDC__
#define qeconAPI		far pascal
#define qeSTATUS	short
#endif

/***************** IMPORTANT NOTES FOR IBM OS/2 2.0 USERS *******************/
/* QECON is a 16-bit DLL.  32-bit applications must take special care when  */
/* calling a 16-bit DLL.  First, all QECON routines must be declared FAR16. */
/* Second, any buffers passed to QECON must not cross a 64K boundary.  This */
/* can be assured by allocating tiled memory.				    */
/****************************************************************************/

#ifdef __IBMC__
#define qeconAPI		_Far16 _Pascal
#define qeSTATUS	short
#endif

/* These are the declarations when using the Microsoft C9 32bit compiler */

#ifdef WIN32
#define qeconAPI		__declspec(dllexport)
#define qeSTATUS	short
#endif

/* These are the declarations when using the Microsoft C8 compiler */

#ifdef __MSC8__
#define qeconAPI		__loadds __export __far __pascal
#define qeSTATUS	short
#endif

/* These are the declarations when using the Microsoft C7 compiler */

#ifdef __MSC7__
#define qeconAPI		__loadds __export __far __pascal
#define qeSTATUS	short
#endif

/* These are the declarations when using the Microsoft C6 compiler */

#ifndef qeconAPI
#define qeconAPI		_loadds _export _far _pascal
#define qeSTATUS	short
#endif

/* Error Codes */

#define ER_NOMEMORY	1	/* No memory for DDE packet */
#define ER_INVALIDCHAN	2	/* Invalid channel number */
#define ER_SERVERDEAD	3	/* Server application is not available */
#define ER_TIMEOUT	4	/* No response to DDE operation */
#define ER_SERVERNACK	5	/* Server nack'ed the DDE operation */
#define ER_OUTOFCHANS	6	/* Out of channel handles in QECON */
#define ER_NORESPONSE	7	/* Server application does not answer */

/* Call: qeerr (chan) */
/* Purpose: Return the last error for the channel */
qeSTATUS qeconAPI qeerr (int);

/* Call: qeinit (app, topic) */
/* Purpose: Initiate a channel */
qeSTATUS qeconAPI qeinit (char FAR *, char FAR *);

/* Call: qereq (chan, item) */
/* Purpose: Request data from a server */
qeSTATUS qeconAPI qereq (int, char FAR *);

/* Call: qepoke (chan, item, data) */
/* Purpose: Poke data to a server */
qeSTATUS qeconAPI qepoke (int, char FAR *, char FAR *);

/* Call: qeexec (chan, command) */
/* Purpose: Ask a server to execute a command string */
qeSTATUS qeconAPI qeexec (int, char FAR *);

/* Call: qewait (chan) */
/* Purpose: Continue waiting after a timeout */
qeSTATUS qeconAPI qewait (int);

/* Call: qeterm (chan) */
/* Purpose: Terminate a channel */
qeSTATUS qeconAPI qeterm (int);

#if defined (__cplusplus)
}
#endif
