VERSION 2.00
Begin Form Form1 
   Caption         =   "INTERSOLV DataDirect Explorer"
   ClientHeight    =   3315
   ClientLeft      =   1905
   ClientTop       =   3735
   ClientWidth     =   7215
   Height          =   4065
   Left            =   1815
   LinkTopic       =   "Form1"
   ScaleHeight     =   3315
   ScaleWidth      =   7215
   Top             =   3075
   Width           =   7395
   Begin Menu mCheck 
      Caption         =   "&Check Stock"
   End
End

' This subroutine determines if stock has slipped below
' 1500 items from supplier S100325.  It will also give the
' user the option to print a chart of the stock quantities for
' the supplier.
'
Sub mCheck_Click ()
    Dim Explorer As Object
    Dim Query As Object
    Dim Chart As Object
    Dim ExplorerError As Object
    
    On Error Resume Next

' Create the Explorer 2.0 Application object
    Screen.MousePointer = 11  ' Set cursor to hour glass
    Set Explorer = CreateObject("DDExplorer.Application")
    Screen.MousePointer = 1   ' Set cursor back to arrow

' Open the stock table and determine the total price of items
' from supplier S100325
    Set Query = Explorer.Open("c:\explorer\samples\stock", 1, "dBASEFile")
    
' Check if an error occurred on the Open command.
' If Error 4 occurred, it means the file was not found, so
' pop up the open dialog so the user can find emp and open
' it for us (the user most likely did not install Explorer into
' c:\ddexp2\samples).
    If (Explorer.Error.Number = 4) Then
	MsgBox "Couldn't find the STOCK table. Open the table."
	Set Query = Explorer.Open

' If any other error occurred, pop up a message box with the
' error number and error text.
    ElseIf (Explorer.Error.Number > 0) Then
	MsgBox "Error #" & Explorer.Error.Number & "has occurred: " & Explorer.Error.Message
	Exit Sub
    End If


' Select the SUPPLIER column to do an AddCondition on that
' column for supplier S100325
    Query.SelectColumn "SUPPLIER"
    Query.AddCondition 1, 1, "S100325", S100325, False

' Create totals for the STOCK_QTY column
    Query.SelectColumn "STOCK_QTY"
    Query.Totals 1, 0, 0, 0, 0, 1
 
' Find out how many rows of data we have. This includes the
' totals (summaries).
    rows = Query.Cells.RowCount
    
' Determine if the totals are less than 1500
    totalQty = Query.Cells(rows, 5).Value
    If (totalQty > 1500) Then
	MsgBox "Time to place an order."
    Else
	MsgBox "Stock is sufficient for now."
    End If

' Ask user if they want to print a chart
    If (MsgBox("Print a chart of the quantities?", 4) = 6) Then
' Add LAST_NAME to the selected columns
	Query.SelectColumn "ITEM_NAME", True
' Create a chart that only includes the detail information
	Set Chart = Query.ChartBuilder(1, 1, 2, 2)
' Set the title for the chart
	Chart.Title = "Quantities from supplier S100325"
' Bring up the print dialog to print out the chart
	Chart.PrintOut
    End If
End Sub

