'***********************************************************
'* ICONS.INC - WanderLink Client Install of Windows Icons
'* (c) Copyright 1994-1995 Funk Software, Inc.
'***********************************************************
'*
'*************************
'*   SYSTEM MANAGER NOTES
'*************************
'*
'* You can distribute the client so that the SETUP will automatically 
'* create Windows Group names, icons, and pre-configured connections 
'* for your environment.  This file allows you to customize the 
'* SETUP procedure for your site.
'*
'*
'* 1.  ADDING CUSTOMIZED CONNECTION ICONS  
'* --------------------------------------
'* There are two steps to creating a customized connection.
'*
'* First, make sure that you have defined a connection in the 
'* version of the WLINK.INI file you include on the distributed disk.
'* To create a connection, use the DOS or Windows version of the 
'* user interface to define the phone number, account, and
'* connection options.
'*
'* Second, add your own customized icon that will be created during
'* the installation procedure.  Add the following lines to the
'* "SECTION 1":
'*
'*  TEXT$ = "wlinkw remote"
'*  i% = pmReplaceItem ( "Dial Remote" )
'*  i% = pmAddItem ( TEXT$,"Dial Remote",WLINKDIR$ + "\WLINKW.EXE",1,-1,-1,WLINKDIR$ + "\" )
'*
'*  Where:
'*    <connection>  Name of the connection in WLINK.INI
'*    <description> Description that will appear under icon in Windows
'*
'* 2.  CHANGING THE WINDOWS GROUP NAME
'* -----------------------------------
'* The Windows group file and name can be changed by modifying the SETUPC.INC
'* file as follows:
'*
'* InstallGrpName$ = <new Windows group name>
'* InstallGrpFile$ = <new Windows *.GRP file name>
'*

	TEXT$ = WINDIR$ + InstallGrpFile$
	CreateProgmanGroup InstallGrpName$,TEXT$,cmoVital

'*
'* SECTION 1:  Client icons
'*

IF SETCLIENT$ = "TRUE" THEN

	TEXT$ = "NOTEPAD " + WLINKDIR$ + "\README.1ST"
	CreateProgmanItem InstallGrpName$,"Read Me First",TEXT$,"",cmoOverwrite

	TEXT$ = WLINKDIR$ + "\WLINKW.EXE"
	CreateProgmanItem InstallGrpName$,"WanderLink Client",TEXT$,"",cmoOverwrite

	TEXT$ = "wlinkw funkdial"
	i% = pmReplaceItem ( "Dial Funk" )
	i% = pmAddItem ( TEXT$,"Dial Funk",WLINKDIR$ + "\WLINKW.EXE",1,-1,-1,WLINKDIR$ + "\" )

	TEXT$ = "wlinkw funkdial | " + LCASE$(WLINKDIR$) + "\guest.pif"
	i% = pmReplaceItem ( "Dial Funk & Guest Login" )
	i% = pmAddItem ( TEXT$,"Dial Funk & Guest Login",WLINKDIR$ + "\WLINKW.EXE",1,-1,-1,WLINKDIR$ + "\" )

	TEXT$ = WLINKDIR$ + "\WLINKWD.EXE"
	CreateProgmanItem InstallGrpName$,"Disconnect WanderLink",TEXT$,"",cmoOverwrite
	
	TEXT$ = "NOTEPAD " + WLINKDIR$ + "\README.TXT"
	CreateProgmanItem InstallGrpName$,"Client ReadMe",TEXT$,"",cmoOverwrite
	
	TEXT$ = "WINHELP " + WLINKDIR$ + "\IPSTACKS.HLP"
	CreateProgmanItem InstallGrpName$,"IP Stack Information",TEXT$,"",cmoOverwrite

	TEXT$ = "NOTEPAD " + LOGFILE$
	CreateProgmanItem InstallGrpName$,"Install Log",TEXT$,"",cmoOverwrite

'*
'* SECTION 1B:  Proxy Master and client icons
'*
	IF SETMASTER$ = "TRUE" THEN
		TEXT$ = "wlinkw funkdial | proxy Funk*"
		i% = pmReplaceItem ( "Dial Funk & Proxy" )
		i% = pmAddItem ( TEXT$,"Dial Funk & Proxy",WLINKDIR$ + "\WLINKW.EXE",1,-1,-1,WLINKDIR$ + "\" )
	ENDIF
ENDIF

'*
'* SECTION 3:  Proxy Master icons
'*

IF SETMASTER$ = "TRUE" THEN

	TEXT$ = PROXYDIR$ + "\PROXY.EXE"
	CreateProgmanItem InstallGrpName$,"Proxy",TEXT$,"",cmoOverwrite

	TEXT$ = PROXYDIR$ + "\PROXY.EXE Funk*"
	CreateProgmanItem InstallGrpName$,"Proxy Funk Demo",TEXT$,"",cmoOverwrite

ENDIF

'*
'* SECTION 4:  Proxy host icons
'*
IF SETHOST$ = "TRUE" THEN

	TEXT$ = PROXYDIR$ + "\PHOSTWIN.EXE"
	CreateProgmanItem InstallGrpName$,"Proxy Host Control Panel",TEXT$,"",cmoOverwrite
ENDIF

'*
'* SECTION 5:  NetWare Client icons
'*
IF VLMCOPY$ = "TRUE" THEN
	TEXT$ = WINDIR$ + "NW.GRP"
	CreateProgmanGroup "NetWare Tools",TEXT$,cmoVital

	TEXT$ = WINDIR$ + "SYSTEM\NWUSER.EXE"
	CreateProgmanItem "NetWare Tools","NetWare User Tools",TEXT$,"",cmoOverwrite
ENDIF
