/*
   wis_tbl.sql - ISQL source for the schema for the Watermark Image Server
                 This script is used by Image Service Install
 
   Copyright (c) 1993-1994, Watermark Software, Inc.
 
   Project: Watermark Image Server
 
   Notes:
    See wis_cre.sql for more information

*/         
declare @curError smallint

while(0=0)
begin

   /* Create the Database Tables */
   /* self-descritption of the service */

create table service (currentVersion char(64))
            select @curError=@@error if @curError<>0 break

insert into service values ('0.95')
            select @curError=@@error if @curError<>0 break




   /* there is a 'document' record for each docment in the service */
create table document (     uniqueID binary(16)    /* UUID of the document */
                                     not null,
                        documentName varchar(32) 
                                     not null,
                             account char(32)      /* storage account */
                                     null,
                              parent binary(16)    /* uniqueID of parent folder*/
                                     null,
                            template varchar(16)   /* user-defined class */
                                     null,
                           createdBy varchar(24)
                                     not null,
                         dateCreated binary(8) 
                                     not null,
                dateMostRecentUpdate binary(8) 
                                     not null,
                  mostRecentUpdateBy varchar(24)
                                     not null,
                         description varchar(40)
                                     not null,
                      expirationDate binary(8)
                                     null,
                            targetID binary(16)    /* server maintained: the 'deep' uniqueID */
                                     not null,     
                               class smallint      /* Watermark-defined class: */ 
                                     not null,     /* 1: Image 3: Folder 5: Template 6: Search */
                                size int           /* server maintained: size of document */
                                     not null,
                           pageCount int
                                     null,
                   accessControlList int  
                                     null,
                         targetClass smallint,     /* server maintained: the 'deep' doc class */
                    deleteInProgress binary(1)     /* server maintained: have we begun deletion? */
                                     not null)
            select @curError=@@error if @curError<>0 break

execute sp_primarykey document, uniqueID
            select @curError=@@error if @curError<>0 break

create unique clustered index docByUniqueID on document(uniqueID)
            select @curError=@@error if @curError<>0 break

create index docByName on document(targetClass,documentName)
            select @curError=@@error if @curError<>0 break

create index docByNameInFolder on document(parent, targetClass, documentName)
            select @curError=@@error if @curError<>0 break

create index docByExperationDate on document(targetClass, expirationDate)
            select @curError=@@error if @curError<>0 break

create index docByCreatedBy on document(createdBy)
            select @curError=@@error if @curError<>0 break

create index docByDescription on document(description)
            select @curError=@@error if @curError<>0 break

create index docByTemplate on document(template)
            select @curError=@@error if @curError<>0 break

create index docByDateCreated on document(targetClass, dateCreated)
            select @curError=@@error if @curError<>0 break

create index docByDateMostRecentUpdate on document(targetClass, dateMostRecentUpdate)
            select @curError=@@error if @curError<>0 break

create index docByMostRecentUpdator on document(targetClass, mostRecentUpdateBy)
            select @curError=@@error if @curError<>0 break





   /*  for each userField of each document, there is a userPropery record
       At the moment, userFields and userKeywords are identified by a text name
       In the future, they may also be identified by a UUID.
       nameStyle determines which naming is used (0=text, 1=uuid), and the 
       name itself is large enough to hold either name of the userField or 
       the text-form of its UUID
   */
create table userField(          name char(36)
                                      null,
                                value char(24)
                                      null,
                     documentUniqueID binary(16) 
                                      not null,
                            nameStyle binary(1)
                                      not null)
            select @curError=@@error if @curError<>0 break

create index userFieldByValue on userField(nameStyle,name,value)
            select @curError=@@error if @curError<>0 break

create index userFieldByDocument on userField(documentUniqueID,nameStyle,name)
            select @curError=@@error if @curError<>0 break

execute sp_foreignkey userField, document, documentUniqueID
            select @curError=@@error if @curError<>0 break



  /* for each user-Keyword of each document, there is a userKeyword record
     Just like userFields, keywords can be identified by a name or a UUID */
create table userKeyword(        name char(36)                 
                                      not null,
                     documentUniqueID binary(16)
                                      not null,
                            nameStyle binary(1)
                                      not null)
            select @curError=@@error if @curError<>0 break

create index userKeywordsByKeyword on userKeyword(name)
            select @curError=@@error if @curError<>0 break

create index userKeywordsByDocumentID on userKeyword(documentUniqueID)
            select @curError=@@error if @curError<>0 break

execute sp_foreignkey userKeyword, document, documentUniqueID
            select @curError=@@error if @curError<>0 break



   /* for each old document imported into the server, there is an
      importSource record to retain the original source of the document */
create table importSource (
                     documentUniqueID binary(16)
                                      not null,
                             pathname char(255)
                                      not null)
            select @curError=@@error if @curError<>0 break

create unique clustered index importSourceByUid 
         on importSource(documentUniqueID)
            select @curError=@@error if @curError<>0 break

create index importSourceByPathname on importSource(pathname)
            select @curError=@@error if @curError<>0 break

execute sp_foreignkey importSource, document, documentUniqueID
            select @curError=@@error if @curError<>0 break



   /* HSM tables */


create table volume (           name char(32)      /* name of the volume */
                                     not null,         
                              volSer int           /* Serial Number of the volume */
                                     not null,
                dateMostRecentUpdate binary(8)     
                                     not null,
                              ledger binary(64),   /* bookkeeping information */
                           volumeSet char(32),    
                         cabinetName char(32),     /* cabinet (jukebox) to hold volume */
                      cabnetLocation char(32),     /* location within cabinet */
                       lastShortName int           /* latest shortName on the volume */
                                     not null,
                         clusterSize int,          
                         lastWritten binary(1)     /* most recently written of volset? */
                                     not null)
            select @curError=@@error if @curError<>0 break

execute sp_primarykey volume, name
            select @curError=@@error if @curError<>0 break

create unique clustered index volumeByName on volume(name)
            select @curError=@@error if @curError<>0 break

                         

                         
   /* since there may be multiple copies of a document in 
      different levels of the hierarchy, we implement
      immigrant as a many:many mapping of documents
      to volumes                                            */
create table immigrant (
                    documentUniqueID binary(16) 
                                     not null,
                           aliasFlag binary(1),
                   documentShortName int,
                               vname char(32) 
                                     not null,
                dateMostRecentUpdate binary(8),
                dateMostRecentAccess binary(8),
                               state binary(1),     /* modified / groomed */
                                size int,           /* size (in bytes) of all clusters of all streams */
                           accountID int,
                   accessControlList int            /* segmentID of ACL */
                                     null,
                    deleteInProgress binary(1))     /* have we begun deletion? */
            select @curError=@@error if @curError<>0 break


/* explain the redundencies */
execute sp_primarykey immigrant, documentUniqueID, vname
            select @curError=@@error if @curError<>0 break

create clustered index locationByDocument on immigrant(documentUniqueID)
            select @curError=@@error if @curError<>0 break

create index locationByLRU on immigrant(dateMostRecentAccess,vname)
            select @curError=@@error if @curError<>0 break

execute sp_foreignkey immigrant, document, documentUniqueID
            select @curError=@@error if @curError<>0 break

execute sp_foreignkey immigrant, volume, vname
            select @curError=@@error if @curError<>0 break
break   /* Get outta dodge! */

end

/* We got here because we failed .... or not */
exit(select @curError)

go
