/*
   wis_cre.sql - ISQL source for the schema for the Watermark Image Server
                 This script is used by Image Service Install
 
   Copyright (c) 1993-1994, Watermark Software, Inc.
 
   Project: Watermark Image Server
 
   Notes:

   Goals:
     (1) find documents that match an arbitrary criteria
         on the properties and keywords of documents
         
     (2) find where a document resides within the storage hierarchy
     
   Motifs:
      - Documents are identified by a uniqueID that is unique over
        all space and time. it is insufficient to identify entities
        by a name, as names may vary over time (e.g., a document can
        be renamed) and names vary over space (e.g., names should
        be translatable into various languages without changing their
        meaning). 
      - Entities that exist within uniquely identified containers (e.g.,
        ACLs contained in Documents) are identified by an int(4) pointer.
        These pointers are not unique in time and are unique only within the
        context of their parent and their usage.
      - Dates are stored in Windows NT Filetime format.

   Preconditions:
      - SQL Server is installed
      - The SQL Server has been started
      - A SQL Server device named wmImageServer is available with sufficient space
      - The following environment variables have been initialized:
        _dbname_        the name of the database
        _dbdevname_     the name of the database device
        _dbdevpath_     the pathname of the database device file
        _dbsize_        the size (in MB) of the database      
        _dbdevsize_     the size (in 2K blocks) of the database device
        _dbdevno_       the virtual device Number for _dbdevname_

*/         


use master
go

declare @curError smallint
while(0=0)
begin

/* Create the Disk File for the Database */
disk init
NAME = '%_dbdevname_%',
PHYSNAME = '%_dbdevpath_%',
VDEVNO = %_dbdevnum_%,
SIZE   = %_dbdevsize_%
            select @curError=@@error if @curError<>0 break

/* Create the Disk File for the Log */
disk init
NAME = '%_dblogdevname_%',
PHYSNAME = '%_dblogdevpath_%',
VDEVNO = %_dblogdevnum_%,
SIZE   = %_dblogdevsize_%
            select @curError=@@error if @curError<>0 break

/* Create the Database itself */
create database %_dbname_% on %_dbdevname_% = %_dbsize_%
       log on %_dblogdevname_% = %_dblogsize_%
            select @curError=@@error if @curError<>0 break

execute sp_dboption %_dbname_%, 'dbo use only', true
            select @curError=@@error if @curError<>0 break
execute sp_dboption %_dbname_%, 'trunc. log on chkpt', true
            select @curError=@@error if @curError<>0 break
checkpoint
            select @curError=@@error if @curError<>0 break
break   /* Get outta dodge! */
end

/* We got here because we failed .... or not */
exit(select @curError)
go                         


