/******************************************************************************
    upgrade.sql - Upgrade the Image Server's database
 
    Copyright (c) 1994-1995 Watermark Software, Inc.
 
*******************************************************************************/


    /* The Image Server database has a fairly small logfiles. Converting a large number
        of rows would exceed the logfile capacity. Thus, conversions are done a
        few at a time. To avoid exteremely lengthy conversions, we create temporary
        indexes to aid conversion, deleting them when conversion is complete */
set rowcount 500
go
declare @curVer char(64)
select @curVer = currentVersion from service
       
if (@curVer = '0.95+++') 
begin
    while exists(select * from immigrant(%INDEXID%) where dirty=null)
        update immigrant 
        set dirty=state%2, 
            state=state/2,
            volset=volume.volumeSet
        from immigrant(%INDEXID%), volume
        where dirty=null and immigrant.vname = volume.name

    drop index immigrant.nullImmigrants

    if not exists (select * from sysindexes where name = 'locationByGroomSequence')
    begin
        create index locationByGroomSequence
            on immigrant(volset,state,dateMostRecentAccess,dirty,accountID)
    end
    if not exists (select * from sysindexes where name = 'locationByVolume')
    begin
        create unique index locationByVolume
            on immigrant(vname,volset,documentShortName)
    end

        /* make sure that all folders have non-null formats */ 
    while exists (select * from document where format=null and targetClass=3 and parent=null)
        update document
        set format = '' 
        where format=null and targetClass=3 and parent=null

    update service set currentVersion='2.00'
end
go

