/***************************************************************************
*
*   A2BAPI.H - definitions / declarations for A2B HLLAPI
*
****************************************************************************/

/*----------------------------------------------------------------------------*/
/* Api Function Codes.                                                        */
/*----------------------------------------------------------------------------*/

#define CONNECTPS               1   /* Connect Presentation Space.          */
#define DISCONNECTPS            2   /* Disconnect Presentation Space.       */
#define SENDKEY                 3   /* Send Key.                            */
#define WAIT                    4   /* Wait.                                */
#define COPYPS                  5   /* Copy Presentation Space.             */
#define SEARCHPS                6   /* Search Presentation Space.           */
#define QUERYCURSORLOC          7   /* Query Cursor Location.               */
#define COPYPSTOSTR             8   /* Copy Presentation Space To String.   */
#define SETSESSIONPARAMETERS    9   /* Set Session Parameters.              */
#define QUERYSESSIONS           10  /* Query Sessions.                      */
#define RESERVE                 11  /* Reserve.                             */
#define RELEASE                 12  /* Release.                             */
#define COPYOIA                 13  /* Copy OIA Information.                */
#define QUERYFIELDATTRIBUTE     14  /* Query Field Attribute.               */
#define COPYSTRTOPS             15  /* Copy String To Presentation Space.   */
#define PAUSE                   18  /* Pause.                               */
#define QUERYSYSTEM             20  /* Query System.                        */
#define RESETSYSTEM             21  /* Reset System.                        */
#define QUERYSESSIONSTATUS      22  /* Query Session Status.                */
#define STARTHOSTNOTIFICATION   23  /* Start Host Notification.             */
#define QUERYHOSTUPDATE         24  /* Query Host Update.                   */
#define STOPHOSTNOTIFICATION    25  /* Stop Host Notification.              */
#define SEARCHFIELD             30  /* Search Field.                        */
#define FINDFIELDPOSITION       31  /* Find Field Position.                 */
#define FINDFIELDLENGTH         32  /* Find Field Length.                   */
#define COPYSTRINGTOFIELD       33  /* Copy String To Field.                */
#define COPYFIELDTOSTRING       34  /* Copy String To Field.                */
#define SETCURSOR               40  /* Set Cursor.                          */
#define CONVERT                 99  /* Convert Position or RowCol.          */

/*---------------------------------------------------------------------------*/
/* A2B HLLAPI Return Codes.                                                  */
/*---------------------------------------------------------------------------*/

#define HLLOK                   0   /* Successful.                          */
#define HLLNOTCONNECTED         1   /* Not Connected To Presentation Space. */
#define HLLBLOCKNOTAVAIL        1   /* Requested size is not available.     */
#define HLLPARAMETERERROR       2   /* Parameter Error/Invalid Function.    */
#define HLLBLOCKIDINVALID       2   /* Invalid Block ID was specified.      */
#define HLLFTXCOMPLETE          3   /* File Transfer Complete.              */
#define HLLFTXSEGMENTED         4   /* File Transfer Complete / segmented.  */
#define HLLPSBUSY               4   /* Presentation Space is Busy.          */
#define HLLINHIBITED            5   /* Inhibited/Keyboard Locked.           */
#define HLLTRUNCATED            6   /* Data Truncated.                      */
#define HLLPOSITIONERROR        7   /* Invalid Presentation Space Position. */
#define HLLNOTAVAILABLE         8   /* Unavailable Operation.               */
#define HLLSYSERROR             9   /* System Error.                        */
#define HLLWOULDBLOCK           10  /* Blocking error.                      */
#define HLLUNAVAILABLE          11  /* Resource is unavailable.             */
#define HLLPSENDED              12  /* The session stopped.                 */
#define HLLUNDEFINEDKEY         20  /* Undefined Key Combination.           */
#define HLLOIAUPDATE            21  /* OIA Updated.                         */
#define HLLPSUPDATE             22  /* PS Updated.                          */
#define HLLBOTHUPDATE           23  /* Both PS And OIA Updated.             */
#define HLLNOFIELD              24  /* No Such Field Found.                 */
#define HLLNOKEYSTROKES         25  /* No Keystrokes are available.         */
#define HLLPSCHANGED            26  /* PS or OIA changed.                   */
#define HLLFTXABORTED           27  /* File transfer aborted.               */
#define HLLZEROLENFIELD         28  /* Field length is zero.                */
#define HLLINVALIDTYPE          30  /* Invalid Cursor Type.                 */
#define HLLKEYOVERFLOW          31  /* Keystroke overflow.                  */
#define HLLSFACONN              32  /* Other application already connected. */
#define HLLTRANCANCLI           34 /* Message sent inbound to host cancelled*/
#define HLLTRANCANCL            35  /* Outbound trans from host cancelled.  */
#define HLLHOSTCLOST            36  /* Contact with host was lost.          */
#define HLLOKDISABLED           37  /* The function was successful.         */
#define HLLNOTCOMPLETE          38  /* The requested fn was not completed.  */
#define HLLSFDDM                39  /* One DDM session already connected.   */
#define HLLSFDPEND              40  /* Disconnected w async requests pending*/
#define HLLBUFFINUSE            41  /* Specified buffer currently in use.   */
#define HLLNOMATCH              42  /* No matching request found.           */

#define HLLINVALIDFUNCTIONNUM  301  /* Invalid function number.             */
#define HLLFILENOTFOUND        302  /* File Not Found.                      */
#define HLLACCESSDENIED        305  /* Access Denied.                       */
#define HLLMEMORY              308  /* Insufficient Memory.                 */
#define HLLINVALIDENVIRONMENT  310  /* Invalid environment.                 */
#define HLLINVALIDFORMAT       311  /* Invalid format.                      */

#define HLLINVALIDPSID        9998  /* Invalid Presentation Space ID.       */
#define HLLINVALIDRC          9999  /* Invalid Row or Column Code.          */

extern VOID FAR PASCAL HLLAPI(LPWORD, LPSTR, LPWORD, LPWORD);
