'**************************************************************************
' vboms.bas -- This file contains all the definitions for various
' OMS symbols, structures and functions for Visual Basic projects.
'**************************************************************************


' Attachment Description structure
Type OmsFile
  Reserved As Long           'Reserved for future/internal use
  Flags As Long              'Flags
  nPosition As Long          'character in text to be replaced by attachment
  PathName As String         'Full path name of attachment file
  FileName As String         'Original file name
  TempName As String         'Temporary name (dependent upon native mail system)
  lFileType As Long          'Attachment file type (optional)
  OnlyFileName  As String    'Only the filename without path
  Icon As Long               'Icon of the server application
  ParcelName As String
  pNextAttachment As Long
End Type
									      
' Mail Recipient Descriptor Structure
Type OmsRecip
  Reserved As Long           ' Reserved for future use
  RecipClass As Long         ' Recipient class VMAIL_TO, VMAIL_CC, VMAIL_BCC, VMAIL_ORIG
  Name As String             ' Recipient name
  FullName As String         ' Recipient fullname
  Address As String          ' Recipient address (optional)
  pNextRecip As Long
End Type
									      
' Mail Message Recipient structure
Type OmsMessage
  Reserved As Long           ' Reserved for future use (M.B. 0)
  MessageType As Long        ' Message Class
  DateReceived As Long       ' Date received in YYYY/MM/DD HH:MM format
  ConversationID As Long     ' conversation thread ID
  Flags As Long              ' unread,return receipt
  RecipCount As Long         ' Number of recipients
  lpRecips As Long           ' Recipient descriptors
  FileCount As Long          ' # of file attachments
  lpFiles As Long            ' Attachment descriptors
  Priority As Integer        ' Priority of this message
  Subject As Long            ' Message Subject
  NoteText As Long           ' Message Text
  Reserved1 As Long          ' Reserved for internal use
  Reserved2 As Long          ' Reserved for internal use
  Reserved3 As Long          ' Reserved for internal use
End Type
									      

'***************************************************
'   OMS Message holds information about a message
'***************************************************

Type BOmsMessage
    Reserved As Long
    Subject As String
    NoteText As String
    MessageType As String
    DateReceived As String
    ConversationID As String
    Flags As Long
    RecipCount As Long
    FileCount As Long
End Type


'************************************************
'   OmsRecip holds information about a message
'   originator or recipient
'************************************************

Type BOmsRecip
    Reserved As Long
    RecipClass As Long
    Name As String
    Address As String
    EIDSize As Long
    EntryID As String
End Type


'******************************************************
'   OmsFile holds information about file attachments
'******************************************************

Type BOmsFile
    Reserved As Long
    Flags As Long
    Position As Long
    FileType As Long
    PathName As String
    FileName As String
End Type

'******************************************************
'   PosRef - position reference
'******************************************************

Type PosRef
    pos(32) As Integer
End Type

'***************************
'   FUNCTION Declarations
'***************************

Declare Function InitOMS Lib "OMS.DLL" (ByVal MailSystem As Integer) As Integer
Declare Function DeInitOMS Lib "OMS.DLL" () As Integer
Declare Function DeleteMail Lib "OMS.DLL" (ByVal session As Long, ByVal MsgID As String) As Integer
Declare Function OpenMailSession Lib "OMS.DLL" (ByVal UserName$, ByVal Password$, ByVal PathName$, session As Long, ByVal FlagUI As Integer, ByVal FlagNewSess As Integer, ByVal FlagDownLoad As Integer) As Integer
Declare Function CloseMailSession Lib "OMS.DLL" (ByVal session&) As Integer
Declare Function GetNextMailEx Lib "OMS.DLL" (ByVal session As Long, Message As OmsMessage, MsgID As PosRef, PrevMsgID As Any, MsdID1 As PosRef, ByVal MailType As Any, ByVal Flags As Long) As Integer
Declare Function AddNewMail Lib "OMS.DLL" (ByVal session As Long, Message As OmsMessage, ByVal Flags As Long) As Integer
Declare Sub FreeVMailBuffer Lib "OMS.DLL" (Message As OmsMessage)

Declare Function BOMSCreateMessage Lib "OMS.DLL" (Message As OmsMessage, BMessage As BOmsMessage, BRecipients As BOmsRecip, BAttachments As BOmsFile) As Integer
Declare Function BOMSGetMessage Lib "OMS.DLL" (Message As OmsMessage, BMessage As BOmsMessage) As Integer
Declare Function BOMSGetRecipientArray Lib "OMS.DLL" (ByVal Recip As Long, BRecipients As BOmsRecip, ByVal RecipCount As Long) As Integer
Declare Function BOMSGetAttachmentArray Lib "OMS.DLL" (ByVal Attach As Long, BAttachments As BOmsFile, ByVal FileCount As Long) As Integer
Declare Function BOMSShowAddressBook Lib "OMS.DLL" (ByVal session As Long, ByVal hParent As Long, Info As Long, BRecipients As Any, RecipCount As Long) As Integer
Declare Function BOMSGetAddress Lib "OMS.DLL" (Info As Long, ByVal RecipCount As Long, BRecipients As BOmsRecip) As Long

'**************************
'   CONSTANT Declarations
'**************************
'
Global Const VM_UNSUPPORTED = 99                     ' Unsupported function
Global Const VM_SUCCESS = 100                        ' No Error.
Global Const VMERR_NATIVE_TO_MAIL_SYS = 101          ' Error native to mail system
						     ' Cannot be described.
Global Const VMERR_CANNOT_LOAD_DLL = 102             ' DLL Could not be loaded   .
Global Const VMERR_MAIL_NOT_INITIALISED = 104        ' Mail functions called without
						     ' initialisation.
Global Const VMERR_NO_VALID_SESSION = 105            ' Trying to close session
						     ' without opening one.
Global Const VMERR_INSUFFICIENT_MEMORY = 106         ' Insufficient memory to complete
						     ' the specified operation
Global Const VMERR_TOO_MANY_SESSIONS = 107           ' User has too many sessions
						     ' open at once
Global Const VMERR_TOO_MANY_FILES = 108              ' Too many file attachments
Global Const VMERR_TOO_MANY_RECIPIENTS = 109         ' Too many message recipients
Global Const VMERR_ATTACHMENT_NOT_FOUND = 110        ' Specified attachment was not found
Global Const VMERR_ATTACHMENT_OPEN_FAILURE = 111     ' Could not open attachment
Global Const VMERR_ATTACHMENT_WRITE_FAILURE = 112
Global Const VMERR_UNKNOWN_RECIPIENT = 113           ' The recipient does not appear
						     ' in the address list
Global Const VMERR_BAD_RECIPTYPE = 114               ' Type of recipient was not TO,
						     ' CC or BCC.
Global Const VMERR_NO_MESSAGES = 115                 '
Global Const VMERR_INVALID_MESSAGE = 116             '
Global Const VMERR_TEXT_TOO_LARGE = 117              ' Text in the message was too
						     ' large to be sent
Global Const VMERR_INVALID_SESSION = 118             ' No valid session is in progress
Global Const VMERR_TYPE_NOT_SUPPORTED = 119          '
Global Const VMERR_LOGON_FAILED = 120                ' User failed to successfully logon
Global Const VMERR_DISK_FULL = 121                   ' Disk is full
Global Const VMERR_ACCESS_DENIED = 122               ' Access Denied :-(

Global Const VMERR_AMBIGUOUS_RECIPIENT = 123
Global Const VMERR_MESSAGE_IN_USE = 124
Global Const VMERR_NETWORK_FAILURE = 125
Global Const VMERR_INVALID_EDITFIELDS = 126
Global Const VMERR_INVALID_RECIPS = 127
Global Const VMERR_NOT_SUPPORTED = 128
Global Const VMERR_SESSION_NOT_STARTED = 129         ' No session started yet
Global Const VMERR_USER_ENUM_INTERRUPT = 130         ' User App interrupted
						     ' enumeration by returning FALSE
Global Const VMERR_NO_DOCS_SPECIFIED = 131           ' Called send documents with no
						     ' document names at all
Global Const VMERR_COULDNOT_CREATE_MESSAGE = 132     ' Could not open the file for
						     ' writing the message (MHS)
Global Const VMERR_USER_ABORTED = 135                ' User aborted the process
Global Const VMERR_CORRUPT_MSG = 136                 ' MAILMSG structure is corrupt !
Global Const VMERR_INIT_FAILURE = 138                ' Could not initialize mail
Global Const VMERR_CANNOT_OPEN_MSG = 139             ' Could not open msg
Global Const VMERR_IO_ERROR = 140
Global Const VMERR_NULL_PARAMETERS = 141             ' One of the required parameters passed
						     ' is NULL
Global Const VMERR_INVALID_TO_RECIP = 300            ' Invalid TO Recipient
Global Const VMERR_INVALID_CC_RECIP = 301            ' Invalid CC Recipient
Global Const VMERR_INVALID_BCC_RECIP = 302           ' Invalid BCC Recipient
Global Const VMERR_INVALID_ORIG_RECIP = 303          ' Invalid BCC Recipient
Global Const VMERR_INVALID_PRIORITY = 304            ' Invalid Subject
Global Const VMERR_INVALID_SUBJECT = 305             ' Invalid Subject
Global Const VMERR_INVALID_NOTE_ATTACH = 306         ' Invalid Note Attachment
Global Const VMERR_INVALID_FILE_ATTACH = 307         ' Invalid File Attachment
Global Const VMERR_INVALID_OBJECT = 308              ' Invalid Session Parameter
Global Const VMERR_NATIVE_MAIL_DLL_NOT_LOADED = 310  ' The native mail DLL file could not be loaded.
Global Const VMERR_CANNOT_READ_MAIL = 311            ' Specified Mail message cannot be read
Global Const VMERR_NO_MORE_MSG = 312
Global Const VMERR_INVALID_MSG_TYPE = 313            ' Invalid custom message type
Global Const VMERR_MSG_TYPE_NOT_SUPPORTED = 314      ' custom message type not supported
Global Const VMERR_COULD_NOT_RESOLVE_NAME = 315      ' Could not resolve the name to a non-ambiguous
						     ' recipient.
Global Const VMERR_FAILURE = 400                     ' General failure


'***************************'
'* Mail System Identifiers *'
'***************************'

Global Const MAIL_SYS_UNKNOWN = 0
Global Const MAIL_SYS_MAPI = 1
Global Const MAIL_SYS_VIM = 2
Global Const MAIL_SYS_MHS = 3
Global Const MAIL_SYS_MHS_LOCAL = 4
Global Const MAIL_SYS_CSERVE = 5

'************************************'
'* extended Mail System Identifiers *'
'************************************'
Global Const EXT_MAIL_SYS_CCMAIL = 1
Global Const EXT_MAIL_SYS_NOTES = 2

'*******************************'
'* Flags for recipient types   *'
'*******************************'

Global Const VMAIL_TO = 1
Global Const VMAIL_CC = 2
Global Const VMAIL_BCC = 4
Global Const VMAIL_ORIG = 8

'***************************'
'* flFlags for MailMsg     *'
'***************************'

'***************************'
'* Priorities for MailMsg  *'
'***************************'
Global Const PRIORITY_HIGH = 1
Global Const PRIORITY_MEDIUM = 2
Global Const PRIORITY_LOW = 3
Global Const PRIORITY_DONT_CARE = 0      ' Don't care priority

'***************************'
'* Flags for various API's *'
'***************************'

Global Const VM_PEEK = 1
Global Const VM_SUPPRESS_ATTACH = 2
Global Const VM_UNREAD = 4
Global Const VM_RECEIPT = 8              ' Return receipt required
Global Const VM_ENABLE_UI = 16
Global Const VM_RESOLVE_ADDRESS = 32

'***************************'
'* Flags for Mail Metrics  *'
'***************************'
Global Const MM_NAMELEN = 1
Global Const MM_FULLNAMELEN = 2
Global Const MM_ADDRESSLEN = 3
Global Const MM_SUBJECTLEN = 4
Global Const MM_CONTENTSLEN = 5
Global Const MM_MAXAPPMSGTYPES = 6
				   
'****************************'
Global Const MAX_SUBJECT_LEN = 512
Global Const MAX_MSG_ID = 64
Global Const MAX_POS_REFERENCE = 64


'************************************'
'* OMS defined types of attachments *'
'************************************'

Global Const AT_UNKNOWN = 0
Global Const AT_OLE = 1
Global Const AT_OLE_STATIC = 2



