; SuperKarts TSR Crack        
; By Mad Vandal
; 4/23/95 
	
	TITLE SuperKarts_Fix
	.MODEL TINY
	JUMPS                           ; Deal with 128+ Bytes Jumps
	.CODE
	ORG 100h

SegOrg  EQU $

; Jump To Loader Code

Start:  
	JMP Loader

;----------------------------------------------------------------------------
; Int2F - Repace Int2F Routine. Monitors Functions AX=1500, 150B, and 1510
;         SuperKarts Makes 18 Calls to 1510 expecting specific results
;         from the CD-ROM. This Routine will intercept calls to the above
;         functions and return the expected results
;----------------------------------------------------------------------------
Int2F:    
	  PUSHF                 ; Save Flags
	  CMP AX,1500h          ; Branch to Appropiate Trapped Routine
	  JE  Func1500
	  CMP AX,150Bh
	  JE  Func150B
	  CMP AX,1510h
	  JE  Func1510

	  POPF                  ; If None of the above then Restore Flags
	  JMP EndInt2F          ; And Execute Int 2F
	  

;----------------------------------------------------------------------------
; Func1500 - Trap Int 2F Function AX=1500 (CD-ROM Installation Check)
;----------------------------------------------------------------------------
Func1500:
	  POPF
	  MOV AX,15FFh          ; Execution Return AL=FF (Unknown)
	  MOV BX,0001h          ; One CD-ROM Drive
	  MOV CX,0003h          ; Drive D:
	  IRET

;----------------------------------------------------------------------------
; Func150B - Trap Int 2F Function AX=150B (CD-ROM Drive Check)
;----------------------------------------------------------------------------
Func150B:
	  POPF
	  MOV AX,3AD4h          ; Drive Supported Code (Unknown)
	  MOV BX,0ADADh         ; ADAD = MSCDEX.EXE Installed
	  IRET

;----------------------------------------------------------------------------
; Func150B - Trap Int 2F Function AX=1510 (Send Device Driver Request)
;            (Function not supported by CD Emulators)
;            (Undocumented DOS Function)
;
;            SuperKarts make 18 calls here to verify it's CD-ROM is in the 
;            drive. 
;----------------------------------------------------------------------------
Func1510:
       
	  ; Check Int 2F AX=1510 SDDR Table. Only Trap Function 07

	  CMP BYTE PTR ES:[BX],7d
	  JE  ProcessFunc7

	  JMP Ignore            ; Proceed and Execute Int 2F Normally

ProcessFunc7:
	  INC CS:[ExecCount]    ; Increment Call Counter

	  ; Branch for each 18 calls and setup the data SuperKarts expects
	  ; in the SDDR Table for each

	  CMP BYTE PTR CS:[ExecCount],1d
	  JE Exec1
	  CMP BYTE PTR CS:[ExecCount],2d
	  JE Exec2
	  CMP BYTE PTR CS:[ExecCount],3d
	  JE Exec3
	  CMP BYTE PTR CS:[ExecCount],4d
	  JE Exec4
	  CMP BYTE PTR CS:[ExecCount],5d
	  JE Exec5
	  CMP BYTE PTR CS:[ExecCount],6d
	  JE Exec6
	  CMP BYTE PTR CS:[ExecCount],7d
	  JE Exec7
	  CMP BYTE PTR CS:[ExecCount],8d
	  JE Exec8
	  CMP BYTE PTR CS:[ExecCount],9d
	  JE Exec9
	  CMP BYTE PTR CS:[ExecCount],10d
	  JE Exec10
	  CMP BYTE PTR CS:[ExecCount],11d
	  JE Exec11
	  CMP BYTE PTR CS:[ExecCount],12d
	  JE Exec12
	  CMP BYTE PTR CS:[ExecCount],13d
	  JE Exec13
	  CMP BYTE PTR CS:[ExecCount],14d
	  JE Exec14
	  CMP BYTE PTR CS:[ExecCount],15d
	  JE Exec15
	  CMP BYTE PTR CS:[ExecCount],16d
	  JE Exec16
	  CMP BYTE PTR CS:[ExecCount],17d
	  JE Exec17
	  CMP BYTE PTR CS:[ExecCount],18d
	  JE Exec18

	  ; Execution Count #19, Reset and Go Do #1

	  MOV BYTE PTR CS:[ExecCount],0
	  JMP ProcessFunc7

Exec1:
	  MOV BYTE PTR ES:[BX+4],01h
	  MOV BYTE PTR ES:[BX+21d],01h
	  MOV BYTE PTr ES:[BX+22d],11h
	  MOV BYTE PTR ES:[BX+23d],46h
	  MOV BYTE PTR ES:[BX+24d],1Dh
	  MOV BYTE PTR ES:[BX+25d],45h
	  POPF
	  IRET

Exec2:

	  MOV BYTE PTR ES:[BX+22d],00h
	  MOV BYTE PTR ES:[BX+23d],02h
	  MOV BYTE PTR ES:[BX+24d],00h
	  MOV BYTE PTR ES:[BX+25d],00h
	  MOV BYTE PTR ES:[BX+26d],41h
	  POPF
	  IRET

Exec3:

	  MOV BYTE PTR ES:[BX+22d],14h
	  MOV BYTE PTR ES:[BX+24d],11h
	  MOV BYTE PTR ES:[BX+26d],01h
	  POPF
	  IRET

Exec4:

	  MOV BYTE PTR ES:[BX+22d],32h
	  MOV BYTE PTR ES:[BX+23d],0Eh
	  MOV BYTE PTR ES:[BX+24d],18h
	  POPF
	  IRET


Exec5:

	  MOV BYTE PTR ES:[BX+22d],22h
	  MOV BYTE PTR ES:[BX+23d],0Ch
	  MOV BYTE PTR ES:[BX+24d],1Bh
	  POPF
	  IRET

Exec6:

	  MOV BYTE PTR ES:[BX+22d],20h
	  MOV BYTE PTR ES:[BX+23d],09h
	  MOV BYTE PTR ES:[BX+24d],1Eh
	  POPF
	  IRET

Exec7:

	  MOV BYTE PTR ES:[BX+22d],3Fh
	  MOV BYTE PTR ES:[BX+23d],2Eh
	  MOV BYTE PTR ES:[BX+24d],22h
	  POPF
	  IRET

Exec8:

	  MOV BYTE PTR ES:[BX+22d],31h
	  MOV BYTE PTR ES:[BX+23d],32h
	  MOV BYTE PTR ES:[BX+24d],25h
	  POPF
	  IRET

Exec9:

	  MOV BYTE PTR ES:[BX+22d],1Ch
	  MOV BYTE PTR ES:[BX+23d],14h
	  MOV BYTE PTR ES:[BX+24d],2Ah
	  POPF
	  IRET


Exec10:

	  MOV BYTE PTR ES:[BX+22d],0Dh
	  MOV BYTE PTR ES:[BX+23d],29h
	  MOV BYTE PTR ES:[BX+24d],2Eh
	  POPF
	  IRET

Exec11:

	  MOV BYTE PTR ES:[BX+22d],27h
	  MOV BYTE PTR ES:[BX+23d],32h
	  MOV BYTE PTR ES:[BX+24d],31h
	  POPF
	  IRET

Exec12:

	  MOV BYTE PTR ES:[BX+22d],41h
	  MOV BYTE PTR ES:[BX+23d],29h
	  MOV BYTE PTR ES:[BX+24d],36h
	  POPF
	  IRET

Exec13:

	  MOV BYTE PTR ES:[BX+22d],0Dh
	  MOV BYTE PTR ES:[BX+23d],16h
	  MOV BYTE PTR ES:[BX+24d],39h
	  POPF
	  IRET


Exec14:

	  MOV BYTE PTR ES:[BX+22d],1Eh
	  MOV BYTE PTR ES:[BX+23d],00h
	  MOV BYTE PTR ES:[BX+24d],3Ch
	  POPF
	  IRET

Exec15:

	  MOV BYTE PTR ES:[BX+22d],32h
	  MOV BYTE PTR ES:[BX+23d],20h
	  MOV BYTE PTR ES:[BX+24d],3Fh
	  POPF
	  IRET

Exec16:

	  MOV BYTE PTR ES:[BX+22d],3Ch
	  MOV BYTE PTR ES:[BX+23d],02h
	  MOV BYTE PTR ES:[BX+24d],42h
	  POPF
	  IRET

Exec17:

	  MOV BYTE PTR ES:[BX+22d],3Bh
	  MOV BYTE PTR ES:[BX+23d],30h
	  MOV BYTE PTR ES:[BX+24d],44h
	  POPF
	  IRET


Exec18:

	  MOV BYTE PTR ES:[BX+22d],1Dh
	  MOV BYTE PTR ES:[BX+23d],0Dh
	  MOV BYTE PTR ES:[BX+24d],45h
	  POPF
	  IRET


;----------------------------------------------------------------------------
; Process Int 2F Normally
;----------------------------------------------------------------------------
Ignore:
	  POPF
	  JMP EndInt2F


;----------------------------------------------------------------------------
; Code to Jump to Int 2F
;----------------------------------------------------------------------------
EndInt2F:
	  DB 0EAh,0,0,0,0


;----------------------------------------------------------------------------
; Function Int 2F AX=1510 Sub:7 Execution Counter
;----------------------------------------------------------------------------

ExecCount DB 0

;----------------------------------------------------------------------------
; Local Stack
;----------------------------------------------------------------------------

EVEN
LStack    DB 256 Dup(0)
TopStack  EQU $-2

;----------------------------------------------------------------------------
; BIOS Parameter Block for INT 21 AX=4B00
;----------------------------------------------------------------------------

SPoint    DW    ?
ParamBlock      Label Word
	  DW    0
	  DW    Offset CmdBuffer
P1        DW    ?
	  DW    5Ch
P2        DW    ?
	  DW    6Ch
P3        DW    ?
CmdBuffer DB    ?
	  DB    ' '
CmdText   DB    80 Dup (?)

FileName  DB    'SK.EXE',0

ExitMesg  DB    10,13,'SUPERKARTS CD Fix',10,13,'C 1995 By Mad Vandal',10,13,'$'

;----------------------------------------------------------------------------
; Loader - Re-Vector Int 2F and Loader SuperKarts (SK.EXE)
;----------------------------------------------------------------------------
Loader:  

	  ; Get Int 2F Interrupt Vector and Save it

	  MOV AX,352Fh
	  INT 21h
	  MOV WORD PTR EndInt2F[1],BX
	  MOV WORD PTR EndInt2F[3],ES

	  ; Re-Vector Int 2F

	  MOV AX,252Fh
	  MOV DX,offset Int2F
	  INT 21h

	  ; Restore ES and DS

	  MOV   AX,CS
	  MOV   ES,AX
	  MOV   DS,AX

	  ; Save Stack Pointer

	  MOV  SP,Offset TopStack
		     
	  ; Copy Command Line for Bios Paramter Block

	  MOV  SI,0081h
	  MOV  DI,Offset CmdText
	  MOV  CH,0
	  MOV  CL,BYTE PTR CS:[80h]
	  MOV  BYTE PTR CS:[CmdBuffer],CL
	  REP  MOVSB

	  ; Re-Allocate Segment Allocation to Free UnUsed Segment Memory

	  MOV  BX,(Offset (LastByte - SegOrg)+15) shr 4
	  ADD  BX,16            ; Account for PSP (100h)
	  MOV  AH,04Ah
	  INT  21h

	  ; Setup Segments in Bios Paramter Block

	  MOV  AX,CS
	  MOV  P1,AX
	  MOV  P2,AX
	  MOV  P3,AX
	  MOV  DX,Offset FileName
	  MOV  BX,Offset ParamBlock
	  MOV  SPoint,SP

	  ; Execute Program

	  MOV  AX,4B00h
	  INT  21h

	  ; Restore ES, DS, and Stack

	  MOV  CX,CS
	  MOV  SS,CX
	  MOV  SP,CS:SPoint
	  MOV  DS,CX
	  MOV  ES,CX

	  ; Restore Original Int 2F Vector

	  MOV AX,252Fh
	  MOV DX, WORD PTR EndInt2F[1]
	  MOV DS, WORD PTR EndInt2F[3]
	  INT 21h
	 
	  ; Display Exit Message

	  PUSH CS
	  POP  DS
	  MOV  DX,Offset ExitMesg
	  MOV  AH,9
	  INT  21h

	  ; Exit to DOS

	  MOV  AX,4C00h
	  INT  21h

LastByte  EQU $
	  End  Start
