VERSION 2.00
Begin Form frmTransfer 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "File Transfer"
   ClientHeight    =   4335
   ClientLeft      =   1230
   ClientTop       =   1965
   ClientWidth     =   8220
   Height          =   4740
   Left            =   1170
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4335
   ScaleWidth      =   8220
   Top             =   1620
   Width           =   8340
   Begin Timer tmrDragDrop 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   1800
      Top             =   5400
   End
   Begin CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   330
      Left            =   6570
      TabIndex        =   13
      Top             =   4575
      Visible         =   0   'False
      Width           =   1365
   End
   Begin CommandButton cmdClose 
      Caption         =   "&Close"
      Height          =   315
      Left            =   6870
      TabIndex        =   11
      Top             =   150
      Width           =   1125
   End
   Begin CommandButton cmdCopyToPC 
      Caption         =   "<-- Copy"
      Height          =   315
      Left            =   5910
      TabIndex        =   10
      Top             =   3840
      Width           =   1185
   End
   Begin DriveListBox drvList 
      Height          =   315
      Left            =   225
      TabIndex        =   1
      Top             =   1215
      Width           =   2265
   End
   Begin DirListBox dirList 
      Height          =   1605
      Left            =   225
      TabIndex        =   3
      Top             =   2025
      Width           =   2265
   End
   Begin CommandButton cmdCopytoHost 
      Caption         =   "Copy -->"
      Height          =   315
      Left            =   3210
      TabIndex        =   6
      Top             =   3840
      Width           =   1185
   End
   Begin ListBox lstVMFileList 
      Height          =   2370
      Left            =   5295
      TabIndex        =   9
      Top             =   1245
      Width           =   2745
   End
   Begin FileListBox filList 
      Height          =   2370
      Left            =   2865
      TabIndex        =   5
      Top             =   1245
      Width           =   1875
   End
   Begin Label lblFTComplete 
      BackStyle       =   0  'Transparent
      Caption         =   "Transfer Status"
      Height          =   240
      Left            =   2670
      TabIndex        =   7
      Top             =   5580
      Visible         =   0   'False
      Width           =   1635
   End
   Begin Label lblhidden 
      BackStyle       =   0  'Transparent
      Caption         =   "NoAccept"
      DragIcon        =   TRANSFER.FRX:0000
      Height          =   225
      Index           =   1
      Left            =   150
      TabIndex        =   15
      Top             =   5580
      Width           =   1035
   End
   Begin Label lblhidden 
      BackStyle       =   0  'Transparent
      Caption         =   "Accept"
      DragIcon        =   TRANSFER.FRX:0302
      Height          =   225
      Index           =   0
      Left            =   150
      TabIndex        =   14
      Top             =   5250
      Visible         =   0   'False
      Width           =   1305
   End
   Begin Label lblFTStatus 
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   330
      Left            =   210
      TabIndex        =   12
      Top             =   4575
      Visible         =   0   'False
      Width           =   5580
   End
   Begin Line Line2 
      X1              =   150
      X2              =   7980
      Y1              =   765
      Y2              =   765
   End
   Begin Label lblCaption 
      BackStyle       =   0  'Transparent
      Caption         =   "V&M File List:"
      Height          =   240
      Index           =   4
      Left            =   5325
      TabIndex        =   8
      Top             =   915
      Width           =   1170
   End
   Begin Label lblCaption 
      BackStyle       =   0  'Transparent
      Caption         =   "&Files:"
      Height          =   240
      Index           =   2
      Left            =   2850
      TabIndex        =   4
      Top             =   945
      Width           =   585
   End
   Begin Label lblCaption 
      BackStyle       =   0  'Transparent
      Caption         =   "D&irectories:"
      Height          =   240
      Index           =   1
      Left            =   225
      TabIndex        =   2
      Top             =   1710
      Width           =   1110
   End
   Begin Label lblCaption 
      BackStyle       =   0  'Transparent
      Caption         =   "Dri&ves:"
      Height          =   225
      Index           =   0
      Left            =   225
      TabIndex        =   0
      Top             =   945
      Width           =   705
   End
   Begin Line Line1 
      X1              =   4950
      X2              =   4950
      Y1              =   885
      Y2              =   4185
   End
End
Option Explicit   ' ensure all variables are declared

Dim Ctrl As Control

Sub Change_Mode (InFileTransfer%)
  ' Changes state of controls and appearance of form
  ' depending on whether a transfer is started or not
  ' InFileTransfer% = TRUE means all lists, buttons are disabled
  ' while the status and cancel button is enabled, and the form's
  ' height is increased
  If InFileTransfer% Then
    lblFTStatus.Visible = True
    cmdCancel.Visible = True
    cmdClose.Enabled = False
    cmdCopyToHost.Enabled = False
    cmdCopytoPC.Enabled = False
    drvlist.Enabled = False
    filList.Enabled = False
    dirList.Enabled = False
    lstVMFileList.Enabled = False
    frmTransfer.Height = 5520
  Else
    lblFTStatus.Visible = False
    cmdCancel.Visible = False
    cmdClose.Enabled = True
    cmdCopyToHost.Enabled = True
    cmdCopytoPC.Enabled = True
    drvlist.Enabled = True
    filList.Enabled = True
    dirList.Enabled = True
    lstVMFileList.Enabled = True
    frmTransfer.Height = 4800
  End If
End Sub

Sub cmdCancel_Click ()
  Dim X%
  X% = frmMain!a2bHostSession.TransferCancel
End Sub

Sub cmdClose_Click ()
  Unload Me
End Sub

Sub cmdCopytoHost_Click ()
  Send_Files
End Sub

Sub cmdCopyToPC_Click ()
  Receive_Files
End Sub

Sub dirList_Change ()
  Refresh_PCFileList
End Sub

Sub drvList_Change ()
  Dim OldPath$  ' stores previous drive/directory value
  Dim Msg$      ' error message text

  ' set the new directory from the drive
  ' an Error 68 or 71 could occur
  On Error GoTo DRIVE_ERROR_TRAP:
  OldPath$ = dirList.Path ' store old setting
  dirList.Path = drvlist.Drive
  Refresh_PCFileList
  Exit Sub

DRIVE_ERROR_TRAP:
  Select Case Err
    Case 68: Msg$ = "Device not available"
    Case 71: Msg$ = "Disk is not ready"
    Case Else: Msg$ = "Error #" & Str$(Err) & ": " & Error$(Err)
  End Select
  If MsgBox(Msg$, MB_ICONHAND + MB_RETRYCANCEL, App.Title) = IDRETRY Then
    Resume 0 ' try again
  Else
    ' restore previous settings
    drvlist.Drive = OldPath$
    dirList.Path = OldPath$
    Exit Sub ' terminate with no change
  End If
End Sub

Sub filList_DragDrop (Source As Control, X As Single, Y As Single)
  ' initiate a Host to PC file transfer
  If Ctrl <> filList Then Receive_Files
End Sub

Sub filList_DragOver (Source As Control, X As Single, Y As Single, State As Integer)
  ' set the icon to accept the drag/drop operation
  If State = ENTER Or State = OVER Then
    Ctrl.DragIcon = lblhidden(0).DragIcon
  Else
    Ctrl.DragIcon = lblhidden(1).DragIcon
  End If
End Sub

Sub filList_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
  ' To initiate drag and drop, activate the timer (which has an interval of
  ' 100 ms - 1/10 of a second) - this will start the drag process unless the user
  ' releases the mouse button quickly

  ' only start the drag/drop if a selection has been made
  Dim i%
  Dim NoSelection%
  NoSelection% = True
  For i% = 0 To filList.ListCount - 1
    If filList.Selected(i%) Then
      NoSelection% = False
      Exit For
    End If
  Next i%
  If NoSelection% Then Exit Sub
  Set Ctrl = filList
  tmrDragDrop.Enabled = True
End Sub

Sub filList_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
  ' To initiate drag and drop, activate the timer (which has an interval of
  ' 100 ms - 1/10 of a second) - this will start the drag process unless the user
  ' releases the mouse button quickly
  tmrDragDrop.Enabled = False
End Sub

Sub Form_Load ()
  ' Fill the lists with filenames by calling the local
  ' procedure - this is also invoked whenever the
  ' user changes the local drive or directory
  Refresh_PCFileList
  ' fill the list with the host filenames
  Refresh_HostFileList
End Sub

Sub lblFTComplete_Change ()
  Static Running%
  If Running% Then Exit Sub
  Running% = True
  ' when the caption changes, the file transfer is complete
  Change_Mode False
  lblFtComplete.Caption = ""
  Running% = False
End Sub

Sub lstVMFIleList_DragDrop (Source As Control, X As Single, Y As Single)
  ' initiate a PC to Host file transfer
  If Ctrl <> lstVMFileList Then Send_Files
End Sub

Sub lstVMFIleList_DragOver (Source As Control, X As Single, Y As Single, State As Integer)
  ' set the icon to accept the drag/drop operation
  If State = ENTER Or State = OVER Then
    Ctrl.DragIcon = lblhidden(0).DragIcon
  Else
    Ctrl.DragIcon = lblhidden(1).DragIcon
  End If
End Sub

Sub lstVMFileList_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
  ' To initiate drag and drop, activate the timer (which has an interval of
  ' 100 ms - 1/10 of a second) - this will start the drag process unless the user
  ' releases the mouse button quickly

  ' only start the drag/drop if a selection has been made
  Dim i%
  Dim NoSelection%
  NoSelection% = True
  For i% = 0 To lstVMFileList.ListCount - 1
    If lstVMFileList.Selected(i%) Then
      NoSelection% = False
      Exit For
    End If
  Next i%
  If NoSelection% Then Exit Sub
  Set Ctrl = lstVMFileList
  tmrDragDrop.Enabled = True

End Sub

Sub lstVMFileList_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
  ' To initiate drag and drop, activate the timer (which has an interval of
  ' 100 ms - 1/10 of a second) - this will start the drag process unless the user
  ' releases the mouse button quickly
  tmrDragDrop.Enabled = False
End Sub

Sub Receive_Files ()
  ' Begins a file transfer from the VM Host to the PC
  Dim i%
  Dim X%
  Dim path$

  ' Set the path portion of the filename.
  ' If it is the root directory, don't add trailing slash
  path$ = dirList.Path
  If (Len(dirList.Path) > 3) Then
    path$ = dirList.Path & "\"
  End If

  Change_Mode True  ' change the appearance of the form
  For i% = 0 To lstVMFileList.ListCount - 1
    If lstVMFileList.Selected(i%) Then
      frmMain!a2bHostSession.TransferRemoteFile = lstVMFileList.List(i%)
      frmMain!a2bHostSession.TransferPCFile = path$ & Convert_VMFile(lstVMFileList.List(i%))
      X% = frmMain!a2bHostSession.TransferReceive
      ' if the user did not cancel, continue
      Exit For
    End If
  Next i%

End Sub

Sub Refresh_HostFileList ()
  ' Fill the VM (Host) file list using the VM 'FL'
  ' command
  
  Dim i%              ' row index
  Dim HostScr$, RW$   ' contains current screen and row contents
  Dim VMFName$        ' VM Filename
  Dim LastPage%       ' indicates when we reach the last page

  'frmMain!lblStatus.Caption = "One moment, reading files."

  ' 1.  Check that the host is ready

  ' 2.  if the FILELIST screen is already present, move
  '     to the first screen
        If InStr(frmMain!a2bHostSession.ReadScreen, "Trunc=") > 0 Then
          frmMain!a2bHostSession.Type = "top"
          frmMain!a2bHostSession.Press = "ENTER"
          ' waitfor the host prompt
          Waitfor_Host
          frmMain!a2bHostSession.Type = "down 1"
          frmMain!a2bHostSession.Press = "ENTER"
          ' waitfor the host prompt
          Waitfor_Host
        Else
          ' otherwise issue the 'FL' command
          frmMain!a2bHostSession.Press = "CLEAR"
          ' waitfor the host prompt
          Waitfor_Host

          frmMain!a2bHostSession.Type = "FL"
          frmMain!a2bHostSession.Press = "ENTER"
          ' waitfor the host prompt
          frmMain!a2bHostSession.WaitFor = "==>"
          Waitfor_Host

        End If


  ' 3.  begin reading the filenames on the screen
  '     stop if the bottom of the screen is reached or the
  '     list is empty

        ' start on row 3, filename is in two parts, 8 bytes each
        ' on columns 7 and 16
        LastPage% = False
        lstVMFileList.Clear ' empty the list
        Do
          frmMain!lblStatus.Caption = frmMain!lblStatus.Caption & "."
          HostScr$ = frmMain!a2bHostSession.ReadScreen
          For i% = 3 To 19
            RW$ = Mid$(HostScr$, (i% - 1) * 80 + 1, 80)
            VMFName$ = Trim$(Mid$(RW$, 7, 8)) & " " & Trim$(Mid$(RW$, 16, 8))
            If Trim$(VMFName$) = "" Then
              LastPage% = True
              Exit For
            End If
            lstVMFileList.AddItem LCase$(VMFName$)
          Next i%
          ' move to the next page (if there is one)
          If Not LastPage% Then
            Waitfor_Host
            frmMain!a2bHostSession.Press = "PF8"
            ' waitfor the host prompt
            frmMain!a2bHostSession.WaitFor = ""
            frmMain!a2bHostSession.CheckFor = "==>"
            'Waitfor_Host
          Else
            Exit Do
          End If
        Loop
        ' return to the "READY;" prompt
        frmMain!a2bHostSession.Press = "PF3"
        ' waitfor the host prompt
        Waitfor_Host

  frmMain!lblStatus.Caption = ""

End Sub

Sub Refresh_PCFileList ()
  ' Fill the local file list using the drive and
  ' directory information
  filList.Path = dirList.Path
End Sub

Sub Send_Files ()
  ' Starts a file transfer for each of the selected files
  ' in the PC File List
  ' uploads the files to the VM Host
  Dim i%
  Dim X%
  Dim path$

  ' Set the path portion of the filename.
  ' If it is the root directory, don't add trailing slash
  path$ = dirList.Path
  If (Len(dirList.Path) > 3) Then
    path$ = dirList.Path & "\"
  End If

  Change_Mode True  ' change the appearance of the form
  For i% = 0 To filList.ListCount - 1
    If filList.Selected(i%) Then
      'frmMain!a2bHostSession.TransferPCFile = dirList.Path & "\" & filList.List(i%)
      frmMain!a2bHostSession.TransferPCFile = path & filList.List(i%)
      frmMain!a2bHostSession.TransferRemoteFile = Convert_PCFile(filList.List(i%))
      X% = frmMain!a2bHostSession.TransferSend
      ' if the user did not cancel, continue
      Exit For
    End If
  Next i%
End Sub

Sub tmrDragDrop_Timer ()
  ' Enable the drag mode on the control which enabled
  ' the timer
  Ctrl.DragIcon = lblhidden(1).DragIcon ' default is the NOACCEPT icon
  Ctrl.Drag BEGIN_DRAG
  tmrDragDrop.Enabled = False ' turn off the timer (to prevent re-entrancy)
End Sub

Sub Waitfor_Host ()
  ' waits until the host is ready
  Do
    DoEvents
    If Not frmMain!a2bHostSession.KeyBoardLocked Then
      Delay 1
      Exit Do
    End If
    Delay 1
  Loop
End Sub

