VERSION 2.00
Begin Form Transfer 
   BackColor       =   &H00C0C0C0&
   Caption         =   "File Transfer (transfer.frm)"
   ClientHeight    =   5820
   ClientLeft      =   150
   ClientTop       =   2295
   ClientWidth     =   7365
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   6225
   Left            =   90
   LinkTopic       =   "Form3"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5820
   ScaleWidth      =   7365
   Top             =   1950
   Width           =   7485
   Begin CommonDialog CMDialog1 
      Left            =   5370
      Top             =   525
   End
   Begin Timer tmrStats 
      Left            =   5400
      Top             =   60
   End
   Begin Frame frmStatus 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Status"
      Height          =   765
      Left            =   285
      TabIndex        =   16
      Top             =   4605
      Width           =   6885
      Begin Label lblComplete 
         BackColor       =   &H00C0C0C0&
         Caption         =   "lblComplete"
         Height          =   240
         Left            =   6270
         TabIndex        =   22
         Top             =   390
         Width           =   570
      End
      Begin Label lblBytes 
         BackColor       =   &H00C0C0C0&
         Caption         =   "lblBytes"
         Height          =   240
         Left            =   3645
         TabIndex        =   20
         Top             =   390
         Width           =   1395
      End
      Begin Label lblSize 
         BackColor       =   &H00C0C0C0&
         Caption         =   "lblSize"
         Height          =   240
         Left            =   1125
         TabIndex        =   18
         Top             =   390
         Width           =   1290
      End
      Begin Label lblPerCent 
         BackColor       =   &H00C0C0C0&
         Caption         =   "% Complete:"
         Height          =   240
         Left            =   5115
         TabIndex        =   21
         Top             =   390
         Width           =   1080
      End
      Begin Label lblTransmitted 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Transmitted:"
         Height          =   240
         Left            =   2490
         TabIndex        =   19
         Top             =   390
         Width           =   1080
      End
      Begin Label lblFileSize 
         BackColor       =   &H00C0C0C0&
         Caption         =   "File Size:"
         Height          =   240
         Left            =   180
         TabIndex        =   17
         Top             =   390
         Width           =   870
      End
   End
   Begin Frame frmSync 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Synchronous Mode"
      ClipControls    =   0   'False
      Height          =   1080
      Left            =   250
      TabIndex        =   0
      Top             =   1080
      Width           =   6885
      Begin OptionButton optSync 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Synchronous  - wait for file transfer to complete."
         Height          =   345
         Left            =   150
         TabIndex        =   2
         Top             =   585
         Width           =   5805
      End
      Begin OptionButton optAsync 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Asynchronous - start file transfer and resume VB code."
         Height          =   315
         Left            =   150
         TabIndex        =   1
         Top             =   315
         Value           =   -1  'True
         Width           =   5760
      End
   End
   Begin Frame fmrFile 
      BackColor       =   &H00C0C0C0&
      Caption         =   "File Selection and Transfer Initiation"
      Height          =   1890
      Left            =   285
      TabIndex        =   3
      Top             =   2385
      Width           =   6885
      Begin ComboBox cboDirection 
         Height          =   300
         Left            =   1455
         Style           =   2  'Dropdown List
         TabIndex        =   9
         Top             =   1110
         Width           =   2730
      End
      Begin ComboBox cboType 
         Height          =   300
         Left            =   1455
         Style           =   2  'Dropdown List
         TabIndex        =   11
         Top             =   1485
         Width           =   2730
      End
      Begin TextBox txtRemote 
         Height          =   315
         Left            =   1455
         TabIndex        =   7
         Text            =   "txtRemote"
         Top             =   720
         Width           =   3450
      End
      Begin CommandButton btnDoTransfer 
         Caption         =   "Do &Transfer"
         Height          =   390
         Left            =   5070
         TabIndex        =   13
         Top             =   735
         Width           =   1680
      End
      Begin CommandButton btnSelFile 
         Caption         =   "&Select PC File..."
         Height          =   390
         Left            =   5070
         TabIndex        =   12
         Top             =   300
         Width           =   1680
      End
      Begin TextBox txtPC 
         Height          =   315
         Left            =   1450
         TabIndex        =   5
         Text            =   "txtPC"
         Top             =   330
         Width           =   3450
      End
      Begin Label lblType 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&File Type:"
         Height          =   255
         Left            =   135
         TabIndex        =   10
         Top             =   1530
         Width           =   1020
      End
      Begin Label lblDirection 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Direction:"
         Height          =   255
         Left            =   135
         TabIndex        =   8
         Top             =   1140
         Width           =   1155
      End
      Begin Label lblRemote 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Remote File:"
         Height          =   255
         Left            =   135
         TabIndex        =   6
         Top             =   750
         Width           =   1155
      End
      Begin Label lblPC 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&PC File:"
         Height          =   255
         Left            =   135
         TabIndex        =   4
         Top             =   345
         Width           =   1395
      End
   End
   Begin CommandButton btnDone 
      Cancel          =   -1  'True
      Caption         =   "Done"
      Height          =   495
      Left            =   5895
      TabIndex        =   14
      Top             =   270
      Width           =   1215
   End
   Begin Label lblDesc 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Set Synchronous Mode, then select both a PC filename and a remost host filename, then select the file transfer direction and then press the Do Transfer button."
      Height          =   600
      Left            =   270
      TabIndex        =   15
      Top             =   285
      Width           =   4935
   End
End
Option Explicit

Dim sXferType As String

Sub btnCancel_Click ()
  Unload Me
End Sub

Sub btnDone_Click ()
  Unload Me
End Sub

Sub btnDoTransfer_Click ()
  Dim iRc As Integer
  Dim sType As String

  'ignore if there aren't 2 file names provided
  If txtPC = "" Then
    txtPC.SetFocus
    Exit Sub
  End If

  'If txtRemote = "" Then
  '  txtRemote.SetFocus
  '  Exit Sub
  'End If

  'Set the sync mode
  ghSWA2VB.Wait = optSync.Value

  'clear the output area
  lblSize.Caption = ""
  lblBytes.Caption = ""
  lblComplete.Caption = ""

  'Set binary / ascii mode (sXferType set in Form Load)
  sType = cboType.Text
  If InStr(sXferType, "SIMXFER") Then
    iRc = A2BSetParm(ghSWA2VB, Csimxferfiletype, sType)
  ElseIf InStr(sXferType, "IND$FILE") Then
    iRc = A2BSetParm(ghSWA2VB, Csimxferfiletype, sType)
  ElseIf InStr(sXferType, "KERMIT") Then
    iRc = A2BSetParm(ghSWA2VB, Csimxferfiletype, sType)
  End If

  'disable the DoTransfer button
  btnDoTransfer.Enabled = False

  'start the file transfer
  ghSWA2VB.TransferPCFile = txtPC
  ghSWA2VB.TransferRemoteFile = txtRemote
  If cboDirection.Text = "This PC to Remote Host" Then
    iRc = ghSWA2VB.TransferSend
  Else
    iRc = ghSWA2VB.TransferReceive
  End If

  'Set Return Value if sync mode set to Wait
  If optSync.Value Then
    lblSize.Caption = Str(Val(ghSWA2VB.TransferStats(4)) + Val(ghSWA2VB.TransferStats(6)))
    lblBytes.Caption = ghSWA2VB.TransferStats(4)
    If lblBytes.Caption = "0" Then
      lblComplete.Caption = "0"
    Else
      lblComplete.Caption = ghSWA2VB.TransferStats(7)
    End If
    btnDoTransfer.Enabled = True
  Else
    tmrStats.Enabled = True
    tmrStats.Interval = 500  '1000 = 1 sec
  End If

End Sub

Sub btnSelFile_Click ()
  ' Select the A2B Program
  On Error GoTo CancelPressed
  CMDialog1.Filter = "All files (*.*)|*.*"
  CMDialog1.FilterIndex = 1
  'CMDialog1.InitDir = ghSWA2VB.DataPath
  CMDialog1.Action = 1
  
  txtPC = CMDialog1.Filename
  txtRemote.SetFocus

CancelPressed:
  Exit Sub
End Sub

Sub Form_Load ()
  Dim sXfer As String

  CentreForm Me

  'Initialize the form fields
  txtPC = ""
  txtRemote = ""
  cboDirection.Clear
  cboDirection.AddItem "This PC to Remote Host"
  cboDirection.AddItem "Remote Host to this PC"
  cboDirection.ListIndex = 0

  'ensure that a file transfer type is specified in the configuration
  sXferType = UCase(A2BGetParm(ghSWA2VB, A2VB_TRANSFER))
  If sXferType = "NONE" Then btnDoTransfer.Enabled = False
  
  cboType.Clear
  cboType.AddItem "Binary"
  cboType.AddItem "Text"
  cboType.ListIndex = 1

  lblSize = ""
  lblBytes = ""
  lblComplete = ""
  
  tmrStats.Enabled = False
  tmrStats.Interval = 0  '1000 = 1 sec

End Sub

Sub tmrStats_Timer ()
  lblSize.Caption = Str(Val(ghSWA2VB.TransferStats(4)) + Val(ghSWA2VB.TransferStats(6)))
  lblBytes.Caption = ghSWA2VB.TransferStats(4)
  If Val(lblSize.Caption) = 0 Then
    lblComplete.Caption = "0"
  Else
    lblComplete.Caption = ghSWA2VB.TransferStats(7)
  End If

  're-enable DoTransfer button when file transfer is finished
  If Val(lblComplete.Caption) = 100 Then btnDoTransfer.Enabled = True
End Sub

