'Option Explicit
'----------------------------------------------------------------------------
' gsA2BObjects is an array of every DDM Object name.
' It is initialized in the A2BObjInit subroutine.
'----------------------------------------------------------------------------
Const A2B_MAX_OBJECTS = 86                      'maximum number of DDM objects
Global gsA2BObjects(A2B_MAX_OBJECTS) As String  'array of every DDM object name
Global bA2BObjInit As Integer     'flag to indicate gsA2bObjects is initialized

'----------------------------------------------------------------------------
'The following 5 constants are for the main setup objects.
'----------------------------------------------------------------------------
Global Const A2VB_APPLICATION = "APPLICATION"
Global Const A2VB_CONNECTION = "CONNECTION"
Global Const A2VB_EMULATION = "EMULATION"
Global Const A2VB_TRANSFER = "TRANSFER"
Global Const A2VB_SERVER = "SERVER"

'----------------------------------------------------------------------------
' The next section declares every DDM parameter as a string that is formatted
' as "#,name".
' #:    - the index (into gsA2BObjects) of the object name that this parameter
'         belongs to.
' name: - the actual parameter name.
' The Advantage 2 Online Help file (ADV2.HLP) describes the Objects and
' Parameters and should be used as a reference when
'----------------------------------------------------------------------------
'3270-1
Global Const C3270charset = "1,Character Set"
Global Const C3270cp = "1,Host Code Page"
Global Const C3270ssd = "1,SplitSecond"
Global Const C3270typeahead = "1,TypeAhead"
Global Const C3270datacomp = "1,Data Compression"
Global Const C3270eds = "1,Extended Data Streams"
Global Const C3270luname = "1,LU Name"
Global Const C3270luselect = "1,LU Selection"
Global Const C3270model = "1,Model"
Global Const C3270printer = "1,Associated Printer Session"
Global Const C3270printscr = "1,Associated Printer"
Global Const C3270priority = "1,Session Priority"

'3287-2
Global Const C3287afl = "2,Actual Form Length"
Global Const C3287charset = "2,Character Set"
Global Const C3287prtslu = "2,Printer SLU"
Global Const C3287sopaction = "2,Start of Print Action"
Global Const C3287sopeach = "2,Start of Print Each"
Global Const C3287trmdoc = "2,Terminal Document"
Global Const C3287trmslu = "2,Terminal SLU"
Global Const C3287type = "2,Type"
Global Const C3287vfl = "2,Virtual Form Length"
Global Const C3287vll = "2,Virtual Line Length"
Global Const C3287cp = "2,Host Code Page"
Global Const C3287datacomp = "2,Data Compression"
Global Const C3287eopff = "2,End of Print Form Feed"
Global Const C3287eopind = "2,End of Print Indicator"
Global Const C3287eoptimeout = "2,End of Print Timeout"
Global Const C3287luname = "2,LU Name"
Global Const C3287luselect = "2,LU Selection"
Global Const C3287priority = "2,Session Priority"

'a2b-3
Global Const Ca2bapplication = "3,Server Operating System"
Global Const Ca2bgroupname = "3,Group Id"
Global Const Ca2bname = "3,Name of A2B"
Global Const Ca2bnewpassword = "3,New Password"
Global Const Ca2bonline = "3,Host Online Keyword"
Global Const Ca2bpassword = "3,Password"
Global Const Ca2bssddir = "3,Directory"
Global Const Ca2bssdmax = "3,Maximum"
Global Const Ca2bssdscroll = "3,Scrolling"
Global Const Ca2buserid = "3,Userid"

'a2bsession-4
Global Const Ca2bsessa2bsess = "4,A2B Session"

'advantage program-5
Global Const Cadvprogadvprog = "5,Advantage Program"

'dialup async-6
Global Const Casyncdiadialtype = "6,Dial Type"
Global Const Casyncdiadlc = "6,DLC"
Global Const Casyncdiamdmcmds = "6,Modem Commands"
Global Const Casyncdianumber = "6,Phone Number"
Global Const Casyncdiaport = "6,Async Settings"
Global Const Casyncdiaprograms = "6,Programs"
Global Const Casyncdiaredials = "6,Busy Redials"
Global Const CasyncdiaX25 = "6,X.25"

'direct async-7
Global Const Casyncdirdlc = "7,DLC"
Global Const Casyncdirport = "7,Async Settings"
Global Const Casyncdirprograms = "7,Programs"
Global Const Casyncdirresponse = "7,Response"
Global Const Casyncdirwakeup = "7,String"
Global Const CasyncdirX25 = "7,X.25"

'direct async programs-8
Global Const Casyncdrppostexec = "8,Postdirect"
Global Const Casyncdrppreexec = "8,Predirect"

'dialup async programs-9
Global Const Casyncupppostexec = "9,Postdialup"
Global Const Casyncupppreexec = "9,Predialup"

'coax common-10
Global Const Ccoaxcommbusypoll = "10,Busy Poll Timer"
Global Const Ccoaxcommidlepoll = "10,Idle Poll Timer"
Global Const Ccoaxcomminboundsa = "10,Inbound SA"
Global Const Ccoaxcommiocomplete = "10,IO Complete Timer"
Global Const Ccoaxcommscretries = "10,Scancode Retries"
Global Const Ccoaxcommsctimer = "10,Scancode Timer"
Global Const Ccoaxcommxclkint = "10,Xclock Interval"

'color-11
Global Const Ccolorbackground = "11,Background"
Global Const Ccolorblink = "11,Blinking"
Global Const Ccolorscheme = "11,Color scheme"
Global Const Ccolorstatusline = "11,Status Line"
Global Const Ccolortty = "11,TTY"
Global Const Ccolorturquois = "11,Turquoise"
Global Const Ccolorunprotected = "11,Unprotected"
Global Const Ccolorwhite = "11,White"
Global Const Ccoloryellow = "11,Yellow"
Global Const Ccolorblue = "11,Blue"
Global Const Ccolorbright = "11,Bright"
Global Const Ccolorgreen = "11,Green"
Global Const Ccolorhiprotected = "11,High Intensity Protected"
Global Const Ccolorhiunprotected = "11,High Intensity Unprotected"
Global Const Ccolorpink = "11,Pink"
Global Const Ccolorprotected = "11,Protected"
Global Const Ccolorred = "11,Red"

'dlc-12
Global Const Cdlcacktimeout = "12,Acknowledgment Timeout"
Global Const Cdlcackwindowsize = "12,Acknowledgment Window Size"
Global Const Cdlcpacketsize = "12,Packet Size"

'dma network profile-13
Global Const Cdmanetbaudrate = "13,Baud Rate"
Global Const Cdmanetdefclass = "13,Default Throughput Class"
Global Const Cdmanetmaxpkt = "13,Maximum Packet Size"
Global Const Cdmanetmode = "13,Connection Mode"
Global Const Cdmanetphone = "13,Phone Number"
Global Const Cdmanetport = "13,Logical Port"
Global Const Cdmanetretry = "13,Frame Retries"
Global Const Cdmanetsetup = "13,Modem Setup String"
Global Const Cdmanetsig = "13,X32 SIG"
Global Const Cdmanetsvclower = "13,SVC Lower Limit"
Global Const Cdmanetsvcupper = "13,SVC Upper Limit"
Global Const Cdmanetthroughput = "13,Throughput Class Negotiation"
Global Const Cdmanetdefpkt = "13,Default Packet Size"
Global Const Cdmanettimeout = "13,Retransmission Timeout"
Global Const Cdmanetwindow = "13,Window Size"
Global Const Cdmanetyear = "13,CCITT Conformance Year"
Global Const Cdmanetdefwindowsize = "13,Default Window Size"
Global Const Cdmanetdnic = "13,DNIC"
Global Const Cdmanetflowcntl = "13,Flow Control Negotiation"
Global Const Cdmanetframe = "13,Maximum Frame Size"
Global Const Cdmanetgender = "13,Gender Emulation"
Global Const Cdmanetid = "13,X32 ID"
Global Const Cdmanetlink = "13,Link"

'dma session profile-14
Global Const Cdmasesbicug = "14,Bilateral Closed User Group"
Global Const Cdmasesbicugnum = "14,Bilateral Closed User Group Number"
Global Const Cdmasesnui = "14,Network User ID"
Global Const Cdmasesouraddr = "14,Local Address"
Global Const Cdmasespktsize = "14,Packet Size"
Global Const Cdmasesrevchrg = "14,Reverse Charge"
Global Const Cdmasesrpoa = "14,RPOA"
Global Const Cdmasesrpoanum = "14,RPOA Number"
Global Const Cdmasesthroughputneg = "14,Throughput Class Negotiation"
Global Const Cdmasesthroughput = "14,Throughput Class"
Global Const Cdmaseswindowsize = "14,Window Size"
Global Const Cdmasescalladdr = "14,Remote Address"
Global Const Cdmasescalldata = "14,Call Data"
Global Const Cdmasescharge = "14,Local Charge"
Global Const Cdmasescug = "14,Closed User Group"
Global Const Cdmasescugnum = "14,Closed User Group Number"
Global Const Cdmasesdelay = "14,Network Delay"
Global Const Cdmasesfast = "14,Fast Select"
Global Const Cdmasesflowcntl = "14,Flow Control Negotiation"

'dma system profile-15
Global Const Cdmasysaddress1 = "15,Physical Port Address 1"
Global Const Cdmasysaddress2 = "15,Physical Port Address 2"
Global Const Cdmasysvol1 = "15,Modem Volume 1"
Global Const Cdmasysvol2 = "15,Modem Volume 2"
Global Const Cdmasyscmdtime = "15,Command Timeout"
Global Const Cdmasysdial1 = "15,Dial Type 1"
Global Const Cdmasysdial2 = "15,Dial Type 2"
Global Const Cdmasysirq1 = "15,Physical Port IRQ1"
Global Const Cdmasysirq2 = "15,Physical Port IRQ2"
Global Const Cdmasysport1 = "15,Physical Port 1"
Global Const Cdmasysport2 = "15,Physical Port 2"
Global Const Cdmasystimeout = "15,Link Timeout"

'dma sync x25-16
Global Const Cdmax25dmanet = "16,Network Profile"
Global Const Cdmax25dmases = "16,Session Profile"
Global Const Cdmax25dmasys = "16,System Profile"

'eicon sdlc gateway-17
Global Const Cecsdlcluname = "17,LU Name"
Global Const Cecsdlclunum = "17,LU Number"
Global Const Cecsdlclutype = "17,LU Type"
Global Const Cecsdlcmode = "17,Mode Name"
Global Const Cecsdlcport = "17,Port Number"
Global Const Cecsdlcpuname = "17,PU Name"

'eicon x.25 gateway-18
Global Const Cecx25dlc = "18,DLC"
Global Const Cecx25dnic = "18,DNIC"
Global Const Cecx25lcladdr = "18,Local Address"
Global Const Cecx25netid = "18,Network Id"
Global Const Cecx25port = "18,Async Settings"
Global Const Cecx25programs = "18,Programs"
Global Const Cecx25remaddr = "18,Remote Address"
Global Const Cecx25response = "18,Response"
Global Const Cecx25userdata = "18,Call User Data"
Global Const Cecx25wakeup = "18,String"

'eicon x.25 gateway programs-19
Global Const Cecx25prpostexec = "19,Postgateway"
Global Const Cecx25prpreexec = "19,Pregateway"

'eicon xpad-20
Global Const Cecxpadaddress = "20,Address"
Global Const Cecxpaddlc = "20,DLC"
Global Const Cecxpaddnic = "20,DNIC"
Global Const Cecxpadport = "20,Async Settings"
Global Const Cecxpadprograms = "20,Programs"
Global Const Cecxpadx3 = "20,X.3"

'eicon xpad programs-21
Global Const Cecxprogspostexec = "21,Postgateway"
Global Const Cecxprogspreexec = "21,Pregateway"

'font-22
Global Const Cfontautoscal = "22,Automatic Scaling"
Global Const Cfontfont = "22,Font"
Global Const Cfontsize = "22,Size"

'generic int 14-23
Global Const Cgenint14dlc = "23,DLC"
Global Const Cgenint14port = "23,Async Settings"
Global Const Cgenint14programs = "23,Programs"

'protocol converter-24
Global Const Chpcname = "24,Hardware Protocol Converter"
Global Const Chpcprompt1 = "24,Prompt on screen one"
Global Const Chpcprompt2 = "24,Prompt on screen two"
Global Const Chpcprompt3 = "24,Prompt on screen three"
Global Const Chpcreply1 = "24,Reply on screen one"
Global Const Chpcreply2 = "24,Reply on screen two"
Global Const Chpcreply3 = "24,Reply on screen three"

'ibm-25
Global Const Cibmcommon = "25,Common"

'ind$file-26
Global Const Cindfilecommon = "26,Common"
Global Const Cindfileexists = "26,If File Exists"
Global Const Cindfilefiletype = "26,File Type"
Global Const Cindfileos = "26,Remote System"
Global Const Cindfileprint = "26,Print"
Global Const Cindfilesend = "26,Send"

'ind$file common-27
Global Const Cindfilecdlgstats = "27,Display Status in Dialog"
Global Const Cindfilecheading = "27,Status Window Heading"
Global Const Cindfileclog = "27,Log File Transfer"
Global Const Cindfilecprogname = "27,IND$FILE Program Name"
Global Const Cindfilecrespwait = "27,Wait for Response"
Global Const Cindfilecwait = "27,Wait When Done"

'ind$file send-28
Global Const Cindfilesblocksize = "28,Host File block size"
Global Const Cindfilescomment = "28,Comment"
Global Const Cindfileslrecl = "28,Host File LRECL"
Global Const Cindfilesprimalloc = "28,Primary allocation"
Global Const Cindfilesrecfm = "28,Host File RECFM"
Global Const Cindfilessecalloc = "28,Secondary allocation"
Global Const Cindfilesunits = "28,Allocation units"

'generic int 14 programs-29
Global Const Cintprogspostexec = "29,Postgateway"
Global Const Cintprogspreexec = "29,Pregateway"

'ipxspx-30
Global Const Cipxspxvoid = "30,Void"

'irma-31
Global Const Cirmacommon = "31,Common"
Global Const Cirmaioaddres = "31,Base IO address"

'kermit-32
Global Const Ckermitcommon = "32,Common"
Global Const Ckermitexists = "32,If File Exists"
Global Const Ckermitfiletype = "32,File Type"

'kermit common-33
Global Const Ckermitcoblockcheck = "33,Block Check"
Global Const Ckermitcodlgstats = "33,Display Status in Dialog"
Global Const Ckermitcoheading = "33,Status Window Heading"
Global Const Ckermitcolog = "33,Log File Transfer"
Global Const Ckermitcopacketlen = "33,Packet Length"
Global Const Ckermitcowait = "33,Wait When Done"

'keypad-34
Global Const Ckeypaddisplay = "34,Display Keypad"
Global Const Ckeypadtype = "34,Type"

'lan application-35
Global Const Clanapplanapp = "35,LAN Application"

'local application-36
Global Const Clocalapplocalapp = "36,Local Application"

'logon-37
Global Const Clogongroupname = "37,Group Id"
Global Const Clogonlogoffprog = "37,Logoff Programs"
Global Const Clogonlogondata = "37,Logon data"
Global Const Clogonlogonprog = "37,Logon Programs"
Global Const Clogonnewpassword = "37,New Password"
Global Const Clogonpassword = "37,Password"
Global Const Clogonuserid = "37,User Id"

'modem commands-38
Global Const Cmdmcmdsacknowledge = "38,Acknowledge"
Global Const Cmdmcmdsbusy = "38,Busy"
Global Const Cmdmcmdsreset = "38,Reset"
Global Const Cmdmcmdssuffix = "38,Suffix"
Global Const Cmdmcmdstype = "38,Modem Type"
Global Const Cmdmcmdsconnect = "38,Connect"
Global Const Cmdmcmdsdialpulse = "38,Dial pulse"
Global Const Cmdmcmdsdialtone = "38,Dial tone"
Global Const Cmdmcmdsescape = "38,Escape"
Global Const Cmdmcmdsfailure = "38,Failure"
Global Const Cmdmcmdshangup = "38,Hang up"
Global Const Cmdmcmdsinit = "38,Initialize"
Global Const Cmdmcmdsprefix = "38,Prefix"

'nacs dialup async-39
Global Const Cnacsdialdialtype = "39,Dial Type"
Global Const Cnacsdialdlc = "39,DLC"
Global Const Cnacsdialmdmcmds = "39,Modem Commands"
Global Const Cnacsdialnacsser = "39,Service Name"
Global Const Cnacsdialnumber = "39,Phone Number"
Global Const Cnacsdialport = "39,Async Settings"
Global Const Cnacsdialprograms = "39,Programs"
Global Const Cnacsdialredials = "39,Busy Redials"
Global Const Cnacsdialx25 = "39,X.25"

'nacs direct async-40
Global Const Cnacsdirdlc = "40,DLC"
Global Const Cnacsdirnacsser = "40,Service Name"
Global Const Cnacsdirport = "40,Async Settings"
Global Const Cnacsdirprograms = "40,Programs"
Global Const Cnacsdirresponse = "40,Response"
Global Const Cnacsdirwakeup = "40,String"
Global Const Cnacsdirx25 = "40,X.25"

'nacs direct async programs-41
Global Const Cnacsdrprpostexec = "41,Postdirect"
Global Const Cnacsdrprpreexec = "41,Predirect"

'service name-42
Global Const Cnacssergeneral = "42,General Name"
Global Const Cnacsserserver = "42,Server Name"
Global Const Cnacsserspecific = "42,Specific Name"

'nacs dialup async programs-43
Global Const Cnacsupprpostexec = "43,Postdialup"
Global Const Cnacsupprpreexec = "43,Predialup"

'none-44
Global Const Cnonevoid = "44,Void"

'novell netware-45
Global Const Cnovellfileserver = "45,Preferred File Server"
Global Const Cnovelllogscript = "45,Custom Login Script"
Global Const Cnovelllogtoserver = "45,Login to File Server"
Global Const Cnovellpassword = "45,Password"
Global Const Cnovellrunscript = "45,Run Login Script"
Global Const Cnovelluserid = "45,User Id"

'async settings-46
Global Const Cportbaudrate = "46,Baud Rate"
Global Const Cportcommport = "46,Port"
Global Const Cportdatabits = "46,Data Bits"
Global Const Cportduplex = "46,Duplex"
Global Const Cportflowctrl = "46,Flow Control"
Global Const Cportlocalecho = "46,Local Echo"
Global Const Cportmdmcmds = "46,Modem Commands"
Global Const Cportparity = "46,Parity"
Global Const Cportparitycheck = "46,Parity Checking"
Global Const Cportstopbits = "46,Stop Bits"

'preferences-47
Global Const Cpreferensetup = "47,Enable Session Setup"

'print-48
Global Const Cprintbypass = "48,Print Driver Bypass"

'logoff programs-49
Global Const Cprlogoffpostexec = "49,Postlogoff"
Global Const Cprlogoffpreexec = "49,Prelogoff"

'logon programs-50
Global Const Cprlogonpostexec = "50,Postlogon"
Global Const Cprlogonpreexec = "50,Prelogon"

'server programs-51
Global Const Cprserverpostcon = "51,Postconnect"
Global Const Cprserverpostdis = "51,Postdisconnect"
Global Const Cprserverprecon = "51,Preconnect"
Global Const Cprserverpredis = "51,Predisconnect"

'x.25 programs-52
Global Const Cprx25postexec = "52,Postnetwork"
Global Const Cprx25preexec = "52,Prenetwork"

'a2b remote lan-53
Global Const Cremotepassword = "53,Gateway Password"
Global Const Cremoteprograms = "53,Programs"
Global Const Cremoteuserid = "53,Gateway User Id"

'a2b remote lan programs-54
Global Const Cremprogspostexec = "54,Postgateway"
Global Const Cremprogspreexec = "54,Pregateway"

'netware saa-55
Global Const Csaaname = "55,Server Name"
Global Const Csaapassword = "55,Password"
Global Const Csaaservice = "55,Service Name"
Global Const Csaauserid = "55,Userid"

'security-56
Global Const Csecuritypassword = "56,Password"

'session-57
Global Const Csessioncolor = "57,Color"
Global Const Csessioncondoc = "57,Connection Document"
Global Const Csessionfont = "57,Font"
Global Const Csessionkeyboard = "57,Keyboard"
Global Const Csessionkeypad = "57,Keypad"
Global Const Csessionpath = "57,Session Path"
Global Const Csessionpreferences = "57,Preferences"
Global Const Csessionprint = "57,Print"
Global Const Csessionsetup = "57,Setup"

'setup-58
Global Const Csetupapplication = "58,Application"
Global Const Csetupconnection = "58,Connection Type"
Global Const Csetupslipapp = "58,SLIP Application"
Global Const Csetupemulation = "58,Emulation"
Global Const Csetupfilexfer = "58,File Transfer"
Global Const Csetuphllapiid = "58,EHLLAPI Id"
Global Const Csetuplogon = "58,Logon"
Global Const Csetupnetapp = "58,Network Application"
Global Const Csetupnetwork = "58,Network"
Global Const Csetupprograms = "58,Programs"
Global Const Csetupserver = "58,Simware Server Software"

'sim3278-59
Global Const Csim3278application = "59,Server Operating System"
Global Const Csim3278name = "59,Name of Sim3278"
Global Const Csim3278online = "59,Online Indicator"
Global Const Csim3278retrys = "59,Retransmission Attempts"
Global Const Csim3278timeout = "59,Error Detection Timeout"

'simxfer-60
Global Const Csimxfercommon = "60,Common"
Global Const Csimxferexists = "60,If File Exists"
Global Const Csimxferfiletype = "60,File Type"
Global Const Csimxferos = "60,Remote System"
Global Const Csimxferprint = "60,Print"
Global Const Csimxferreceive = "60,Receive"
Global Const Csimxfersend = "60,Send"

'simxfer common-61
Global Const Csimxfercafterlast = "61,Pause after Last Block"
Global Const Csimxfercbeforelast = "61,Pause before Last Block"
Global Const Csimxfercrespwait = "61,Wait for Response"
Global Const Csimxferctimeouts = "61,Timeouts"
Global Const Csimxfercwait = "61,Wait When Done"
Global Const Csimxfercblockpause = "61,Pause between Blocks"
Global Const Csimxfercblocksize = "61,Transfer Block Size"
Global Const Csimxferccrc = "61,CRC Error Detection"
Global Const Csimxfercdlgstats = "61,Display Status in Dialog"
Global Const Csimxfercheading = "61,Status Window Heading"
Global Const Csimxferchostmsgs = "61,Display Host System Messages"
Global Const Csimxferclog = "61,Log File Transfer"
Global Const Csimxfercmaxrec = "61,Maximum Record Size"

'simxfer receive-62
Global Const Csimxferrcc = "62,Carriage Control"
Global Const Csimxferrchkpoint = "62,Checkpoint Frequency"
Global Const Csimxferrcolumn = "62,Column Filter"
Global Const Csimxferrdatacomp = "62,Data Compression"
Global Const Csimxferrline = "62,Line Filter"
Global Const Csimxferrlpp = "62,Lines per Page"
Global Const Csimxferrpceof = "62,Append PC EOF"
Global Const Csimxferrsequence = "62,Strip Sequence Numbers"
Global Const Csimxferrtable = "62,Translate Table Name"
Global Const Csimxferrtrailing = "62,Strip Trailing Blanks"

'simxfer send-63
Global Const Csimxferschkpoint = "63,Checkpoint Frequency"
Global Const Csimxferscolumn = "63,Column Filter"
Global Const Csimxfersdatacomp = "63,Data Compression"
Global Const Csimxfersline = "63,Line Filter"
Global Const Csimxferslrecl = "63,Host File LRECL"
Global Const Csimxfersrecfm = "63,Host File RECFM"
Global Const Csimxferstable = "63,Translate Table Name"
Global Const Csimxferstabs = "63,Expand Tabs"

'slip/ppp-64
Global Const Cslipconfig = "64,Serial Configuration"
Global Const Cslipname = "64,Server Name"
Global Const Cslippassword = "64,Password"
Global Const Cslipreadip = "64,Read IP Address"
Global Const Cslipslipprgs = "64,SLIP Programs"
Global Const Cslipstr1look = "64,String1 Look For"
Global Const Cslipstr1type = "64,String1 Type When Found"
Global Const Cslipstr2look = "64,String2 Look For"
Global Const Cslipstr2type = "64,String2 Type When Found"
Global Const Cslipuserid = "64,User Id"

'slip advantage program-65
Global Const Cslipaprgslipaprg = "65,SLIP Advantage Program"

'slip local application-66
Global Const Csliplappsliplapp = "66,SLIP Local Application"

'a2b slip/ppp programs-67
Global Const Cslipprogpostsrvr = "67,Postserver"
Global Const Cslipprogpresrvr = "67,Preserver"

'slip a2b session-68
Global Const Cslipsessslipsess = "68,SLIP A2B Session"

'telnet-69
Global Const Ctelnetdlc = "69,DLC"
Global Const Ctelnethost = "69,Host name or address"
Global Const Ctelnetportnum = "69,Port Number"

'tn3270-70
Global Const Ctn3270host = "70,Host name or address"
Global Const Ctn3270portnum = "70,Port Number"

'tty-71
Global Const Cttylfappend = "71,Append LF to CR"

'ubass niu-72
Global Const Cubniudlc = "72,DLC"
Global Const Cubniuport = "72,Async Settings"
Global Const Cubniuprograms = "72,Programs"
Global Const Cubniuresource = "72,Resource Id"

'ungermann bass niu programs-73
Global Const Cubprogspostexec = "73,Postgateway"
Global Const Cubprogspreexec = "73,Pregateway"

'vt100-74
Global Const Cvt100autowrap = "74,Wrap line overflow automatically"
Global Const Cvt100columns = "74,132-column mode"
Global Const Cvt100lfappend = "74,Append LF to inbound CR"
Global Const Cvt100translate = "74,Translations"

'vt220-75
Global Const Cvt220backspace = "75,Backspace translation"
Global Const Cvt220chrmapgl = "75,Character Map GL"
Global Const Cvt220keypad = "75,Keypad translation"
Global Const Cvt220newline = "75,Newline"
Global Const Cvt220chrmapgr = "75,Character Map GR"
Global Const Cvt220chrtabg0 = "75,Character Table G0"
Global Const Cvt220chrtabg1 = "75,Character Table G1"
Global Const Cvt220chrtabg2 = "75,Character Table G2"
Global Const Cvt220chrtabg3 = "75,Character Table G3"
Global Const Cvt220columns = "75,8 column tabs"
Global Const Cvt220controls = "75,Control character sequence"
Global Const Cvt220cursor = "75,Cursor key translation"

'x.25-76
Global Const Cx25address = "76,Address"
Global Const Cx25dnic = "76,DNIC"
Global Const Cx25network = "76,Network"
Global Const Cx25password = "76,Password"
Global Const Cx25programs = "76,X.25 Programs"
Global Const Cx25userid = "76,User Id"
Global Const Cx25x3 = "76,X.3"

'x.3-77
Global Const Cx31 = "77,PAD Recall Character"
Global Const Cx310 = "77,Line Folding"
Global Const Cx36 = "77,Messages and Prompts to Receive"
Global Const Cx37 = "77,PAD Reaction to Break Signal"
Global Const Cx38 = "77,Discard Output"
Global Const Cx39 = "77,Padding after CR"
Global Const Cx312 = "77,Terminal Controls Flow from PAD"
Global Const Cx313 = "77,When to Insert a LF after CR"
Global Const Cx314 = "77,Padding after LF"
Global Const Cx315 = "77,Editing"
Global Const Cx32 = "77,Echo Characters"
Global Const Cx33 = "77,Data Forwarding Characters"
Global Const Cx34 = "77,Idle Timer Delay"
Global Const Cx35 = "77,Ancillary Device Control"

'xircom-78
Global Const Cxircomcommon = "78,Common"

'xmodem-79
Global Const Cxmodemblocksize = "79,Block Size"
Global Const Cxmodemcommon = "79,Common"
Global Const Cxmodemexists = "79,If File Exists"

'xmodem common-80
Global Const Cxmodemcocrc = "80,CRC"
Global Const Cxmodemcodlgstats = "80,Display Status in Dialog"
Global Const Cxmodemcoheading = "80,Status Window Heading"
Global Const Cxmodemcolog = "80,Log File Transfer"
Global Const Cxmodemcowait = "80,Wait When Done"

'ymodem-81
Global Const Cymodemcommon = "81,Common"
Global Const Cymodemexists = "81,If File Exists"

'ymodem common-82
Global Const Cymodemcodlgstats = "82,Display Status in Dialog"
Global Const Cymodemcoheading = "82,Status Window Heading"
Global Const Cymodemcolog = "82,Log File Transfer"
Global Const Cymodemcowait = "82,Wait When Done"

'ymodemg-83
Global Const Cymodemgcommon = "83,Common"
Global Const Cymodemgexists = "83,If File Exists"

'ymodemg common-84
Global Const Cymodemgcdlgstats = "84,Display Status in Dialog"
Global Const Cymodemgcheading = "84,Status Window Heading"
Global Const Cymodemgclog = "84,Log File Transfer"
Global Const Cymodemgcwait = "84,Wait When Done"

'zmodem-85
Global Const Czmodemcommon = "85,Common"
Global Const Czmodemexists = "85,If File Exists"

'zmodem common-86
Global Const Czmodemcoblockcheck = "86,Block Check"
Global Const Czmodemcobuffer = "86,Buffer Limit"
Global Const Czmodemcotransfer = "86,Transfer If"
Global Const Czmodemcowait = "86,Wait When Done"
Global Const Czmodemcocancel = "86,Cancel If No Destination File"
Global Const Czmodemcoconvert = "86,Convert NL to Local EOL"
Global Const Czmodemcoctrlchar = "86,Escape All Control Characters"
Global Const Czmodemcodlgstats = "86,Display Status in Dialog"
Global Const Czmodemcodownload = "86,Auto Download"
Global Const Czmodemcoencoding = "86,Run Length Encoding"
Global Const Czmodemcoheading = "86,Status Window Heading"
Global Const Czmodemcolog = "86,Log File Transfer"

' Return code constants.
'
Global Const A2VB_OK                            =   0
Global Const A2VB_INTERNAL_ERROR                =   1
Global Const A2VB_LOW_MEMORY                    =   2
Global Const A2VB_RMT_LOW_MEMORY                =   3
Global Const A2VB_PROGRAMUNREADABLE             =   3
Global Const A2VB_LOAD_FAILED                   =   4
Global Const A2VB_PROGRAMINTERRUPTED            =   4
Global Const A2VB_RMT_LOAD_FAILED               =   5
Global Const A2VB_NORESOURCES                   =   5
Global Const A2VB_PROC_INIT_FAILED              =   6
Global Const A2VB_RMT_PROC_INIT_FAILED          =   7
Global Const A2VB_WHENEXPECTED                  =   7
Global Const A2VB_CODEWORD_CHECK_FAILED         =   8
Global Const A2VB_UNEXPECTEDTHEN                =   8
Global Const A2VB_MAX_USERS_EXCEEDED            =   9
Global Const A2VB_UNEXPECTEDWHEN                =   9
Global Const A2VB_PROCESS_LOST                  =  10
Global Const A2VB_UNEXPECTEDEND                 =  10
Global Const A2VB_STOP_REQUESTED                =  11
Global Const A2VB_LINK_INUSE                    =  12
Global Const A2VB_LINK_INVALID                  =  13
Global Const A2VB_LINK_INIT_FAILED              =  14
Global Const A2VB_LINK_FAILED                   =  15
Global Const A2VB_LINK_WRONG_SERVER             =  16
Global Const A2VB_NOLABEL                       =  16
Global Const A2VB_MAXIMUM_RETRIES               =  17
Global Const A2VB_UNEXPECTEDPROCEDURE           =  17
Global Const A2VB_MAX_CIRCUITS_EXCEEDED         =  19
Global Const A2VB_USERID_INVALID                =  20
Global Const A2VB_PASSWORD_INVALID              =  21
Global Const A2VB_PASSWORD_EXPIRED              =  22
Global Const A2VB_NEW_PASSWORD_INVALID          =  23
Global Const A2VB_APPL_ACCESS_DENIED            =  24
Global Const A2VB_BADTRACE                      =  24
Global Const A2VB_TERMINAL_ACCESS_DENIED        =  25
Global Const A2VB_USER_ACCESS_REVOKED           =  26
Global Const A2VB_BADNUMBER                     =  26
Global Const A2VB_GROUP_ACCESS_REVOKED          =  27
Global Const A2VB_USERID_NOT_IN_GROUP           =  28
Global Const A2VB_BADLEAVE                      =  28
Global Const A2VB_USERID_NOT_AUTH_NOW           =  29
Global Const A2VB_BADENVIRONMENT                =  29
Global Const A2VB_TERMINAL_NOT_AUTH_NOW         =  30
Global Const A2VB_AUTH_FAILED_BY_USER_EXIT      =  32
Global Const A2VB_AUTH_FAILED_BY_SIM_EXIT       =  33
Global Const A2VB_BADEXPRESSION                 =  33
Global Const A2VB_BADLOGICALVALUE               =  34
Global Const A2VB_ACCESS_DENIED                 =  39
Global Const A2VB_STACKOVERFLOW                 =  39
Global Const A2VB_SECURITY_SYSTEM_INACTIVE      =  40
Global Const A2VB_BADCALLTOROUTINE              =  40
Global Const A2VB_SPECIFIED_SLU_NOT_FOUND       =  41
Global Const A2VB_BADARITHMETIC                 =  41
Global Const A2VB_SPECIFIED_SLU_NOT_AVAILABLE   =  42
Global Const A2VB_ARTITHMETICOVERFLOW           =  42
Global Const A2VB_ROUTINENOTFOUND               =  43
Global Const A2VB_NOFUNCTIONRETURN              =  44
Global Const A2VB_NODATARETURN                  =  45
Global Const A2VB_APPL_NOT_AVAILABLE            =  46
Global Const A2VB_APPL_LOGON_FAILED             =  47
Global Const A2VB_UNBIND_RECEIVED               =  48
Global Const A2VB_INACTIVE_PRINT_TIMEOUT        =  50
Global Const A2VB_BADCALLEDROUTINE              =  50
Global Const A2VB_ASSOCIATED_SLU_IN_USE         =  51
Global Const A2VB_NO_SLU_FOR_ASSOCIATION        =  52
Global Const A2VB_SLU_IN_USE                    =  53
Global Const A2VB_NO_MATCHING_SLU               =  54
Global Const A2VB_SNA_NETWORK_SHUTTING_DOWN     =  55
Global Const A2VB_USERID_MISSING                =  56
Global Const A2VB_PASSWORD_MISSING              =  57
Global Const A2VB_LINK_ALREADY_CONNECTED        =  58
Global Const A2VB_INVALID_LU_TYPE               =  59
Global Const A2VB_EMULATION_FAILED              =  60
Global Const A2VB_NO_APPL_SPECIFIED             =  61
Global Const A2VB_DATABITS_MISMATCH             =  62
Global Const A2VB_CLIENT_SERVER_MISMATCH        =  64
Global Const A2VB_SERVER_QUIESCED               =  65
Global Const A2VB_INCORRECT_3270_MODEL          =  66
Global Const A2VB_ADAPTER_NO_RESPONSE           =  67
Global Const A2VB_ADAPTER_SEND_TIMEOUT          =  68
Global Const A2VB_IRMA_ADAPTER_NOT_FOUND        =  69
Global Const A2VB_TCPIP_NETWORK_ERROR           =  70
Global Const A2VB_TCPIP_DLL_ERROR               =  71
Global Const A2VB_TCPIP_WINSOCK_ERROR           =  72
Global Const A2VB_TCPIP_INIT_ERROR              =  73
Global Const A2VB_TCPIP_HOST_INVALID            =  74
Global Const A2VB_TCPIP_INTERNAL_ERROR          =  75
Global Const A2VB_TCPIP_SOCKET_ERROR            =  76
Global Const A2VB_TCPIP_RESOURCE_ERROR          =  77
Global Const A2VB_TCPIP_ADDRESSING_ERROR        =  78
Global Const A2VB_TCPIP_CONNECTING_ERROR        =  79
Global Const A2VB_TCPIP_MSGSIZE_ERROR           =  80
Global Const A2VB_TCPIP_CONNECTION_ERROR        =  81
Global Const A2VB_TCPIP_UNKNOWN_ERROR           =  82
Global Const A2VB_SAA_LOGON_INVALID             =  83
Global Const A2VB_SAA_LINK_ERROR                =  84
Global Const A2VB_SAA_SERVER_UNKNOWN_STATE      =  87
Global Const A2VB_SAA_DATAGRAM_INIT_FAILED      =  88
Global Const A2VB_SAA_SERVER_NAME_NOT_FOUND     =  89
Global Const A2VB_TELNET_NO_HOST_NAME           =  91
Global Const A2VB_TN3270_NO_HOST_NAME           =  92
Global Const A2VB_SAA_SERVER_NOT_FOUND          =  93
Global Const A2VB_ADAPTER_NOT_FOUND             =  94
Global Const A2VB_TCPIP_NETWORK_UNREACHABLE     = 100
Global Const A2VB_TCPIP_SOCKET_INUSE            = 101
Global Const A2VB_XIRCOM_DLL_NOT_LOADED         = 105
Global Const A2VB_DMA_CALLBUSY                  = 106
Global Const A2VB_DMA_INVALID_DTE               = 107
Global Const A2VB_DPMI_ERROR                    = 108
Global Const A2VB_TSR_NOT_INSTALLED             = 109
Global Const A2VB_X25_LINK_FAILED               = 110
Global Const A2VB_ADAPTER_MODEL_MISMATCH        = 111
Global Const A2VB_X25_CLEAR                     = 112
Global Const A2VB_X25_RESET                     = 113
Global Const A2VB_MODEM_NOT_AUTOSYNC            = 114
Global Const A2VB_MODEM_NOT_RESPONDING          = 115
Global Const A2VB_CARRIER_LOST                  = 116
Global Const A2VB_SYNC_LOST                     = 117
Global Const A2VB_NO_SYNCUP_RESP                = 118
Global Const A2VB_NO_RESPONSE_MODE              = 119
Global Const A2VB_NO_CARRIER                    = 120
Global Const A2VB_CONNECT_ERROR                 = 121
Global Const A2VB_SYNCUP_MISMATCH               = 122
Global Const A2VB_X25_TIMEOUT                   = 123
Global Const A2VB_PROGRAM                       = -9
Global Const A2VB_MODEM                         = -6000
Global Const A2VB_NOPHONENUMBER                 = -6010
Global Const A2VB_LINEBUSY                      = -6011
Global Const A2VB_NOCARRIER                     = -6012
Global Const A2VB_NODIALTONE                    = -6013
Global Const A2VB_PHONEPROBLEM                  = -6014
Global Const A2VB_NOREDIAL                      = -6015
Global Const A2VB_NOWAKEUP                      = -6050
Global Const A2VB_NONETWORK                     = -6100
Global Const A2VB_NONETWORKATTENTION            = -6101
Global Const A2VB_NODNIC                        = -6102
Global Const A2VB_NOADDRESS                     = -6103
Global Const A2VB_NONETWORKUSERID               = -6104
Global Const A2VB_NONETWORKPASSWORD             = -6105
Global Const A2VB_NOPASSWORDPROMPT              = -6106
Global Const A2VB_NONETWORKPROMPT               = -6107
Global Const A2VB_NONETWORKREADYPROMPT          = -6108
Global Const A2VB_BADDNIC                       = -6109
Global Const A2VB_BADADDRESS                    = -6110
Global Const A2VB_BADNETWORKUSERID              = -6111
Global Const A2VB_BADNETWORKPASSWORD            = -6112
Global Const A2VB_BADX3                         = -6113
Global Const A2VB_BADMETHOD                     = -6290
Global Const A2VB_NOONLINEPROMPT                = -6300
Global Const A2VB_NONETSOLPROMPT                = -6305
Global Const A2VB_BADSERVER                     = -6306
Global Const A2VB_NOCONNECTSIGNAL               = -6307
' The folowing error message is in regards to
' VTAM, VM/VTAM or TCP/IP server problems
'Global Const A2VB_BADSERVER                    = -6310
Global Const A2VB_NOVTAMSERVER                  = -6311
Global Const A2VB_NOTCPIPPROMPT                 = -6312
Global Const A2VB_NOVMLOGONPROMPT               = -6320
Global Const A2VB_NOTERMINALPROMPT              = -6321
Global Const A2VB_NOVMSERVER                    = -6322
Global Const A2VB_NOLOGONPROMPT                 = -6400
Global Const A2VB_NOAPPLUSERID                  = -6401
Global Const A2VB_BADAPPLUSERID                 = -6402
Global Const A2VB_NOAPPLPASSWORD                = -6403
Global Const A2VB_BADAPPLPASSWORD               = -6404
Global Const A2VB_NOLOGONAPPLUSERID             = -6405
Global Const A2VB_NOGROUPID                     = -6406
Global Const A2VB_NOISPFPROMPT                  = -6407
Global Const A2VB_NOTSOREADYPROMPT              = -6500
Global Const A2VB_NOTSOLOGOFFPROMPT             = -6501
Global Const A2VB_LISTFILE                      = -6502
Global Const A2VB_NOSTRINGTYPE                  = -6600
Global Const A2VB_BADSESSIONCONNECT             = -6601
Global Const A2VB_BADSESSIONDISCONNECT          = -6602
Global Const A2VB_BADSESSIONLOGOFF              = -6603
Global Const A2VB_MAXRETRIES                    = -6604
Global Const A2VB_NOWAITFOR                     = -6605
Global Const A2VB_BADPROMPTDIALOG               = -6606
Global Const A2VB_NOPCPROMPT1                   = -6701
Global Const A2VB_NOPCPROMPT2                   = -6702
Global Const A2VB_NOPCPROMPT3                   = -6703
Global Const A2VB_BADSTRINGTYPE                 = -6800
Global Const A2VB_KEYBOARDLOCKED                = -6801
Global Const A2VB_CURSORINPROTECTEDFIELD        = -6802


Function A2BGetIndex (xA2VB As A2VB, sName As String) As Integer

Dim i As Integer
Dim j As Integer
Dim s As String
Dim sUpperName As String
Dim sUpperParm As String

A2BGetIndex = -1

i = InStr(sName, ",")
If (i <> 0) Then
  s = Mid$(sName, i + 1)
  If (Len(s) <> 0) Then
    sUpperName = UCase(s)
    For j = 0 To xA2VB.ParameterCount - 1
      sUpperParm = UCase(xA2VB.Parameter(j))
      If (sUpperName = sUpperParm) Then Exit For
    Next
    If j < xA2VB.ParameterCount Then A2BGetIndex = j
  End If
End If
End Function

Function A2BGetObject (xA2VB As A2VB, sName As String) As String

Dim i As Integer
Dim j As Integer
Dim s As String
Dim sUpperName As String
Dim sUpperParm As String

A2BGetObject = ""

i = InStr(sName, ",")
If (i <> 0) Then
  s = Mid$(sName, 1, i - 1)
  If (Len(s) <> 0) Then
    j = Val(s)
    If (j > 0 And j < A2B_MAX_OBJECTS) Then A2BGetObject = gsA2BObjects(j)
  End If
End If

End Function

Function A2BGetParm (xA2VB As A2VB, sParmName As String) As String

' Declarations
Dim i As Integer
Dim iModel As Integer
Dim sBS As String
Dim sConnType As String
Dim sDevType As String
Dim sOS As String
Dim sSrvType As String
Dim sTmpDev As String
Dim sXfrType As String
Dim iIndex As Integer
Dim sObj As String

If bA2BObjInit <> True Then A2BObjInit

sParmName = UCase$(sParmName)         ' Uppercase before doing anything
A2BGetParm = ""

'----------------------------------------------------------------------------------

Select Case sParmName
Case "APPLICATION"
  A2BGetParm = A2BGetParm(xA2VB, Csetupapplication)
'----------------------------------------------------------------------------------

Case "CONNECTION"
  sConnType = UCase$(A2BGetParm(xA2VB, Csetupconnection))

  Select Case sConnType
  Case "DIALUP ASYNC"
    sOS = A2BGetParm(xA2VB, CasyncdiaX25)
    If sOS = "X.25" Then
      A2BGetParm = "DIAL-UP X.25"
    Else
      A2BGetParm = "DIAL-UP ASYNC"
    End If
  Case "DIRECT ASYNC"
    sOS = A2BGetParm(xA2VB, CasyncdirX25)
    If sOS = "X.25" Then
      A2BGetParm = "DIRECT X.25"
    Else
      A2BGetParm = sConnType
    End If
  Case "NACS DIALUP ASYNC"
    sOS = A2BGetParm(xA2VB, Cnacsdialx25)
    If sOS = "X.25" Then
      A2BGetParm = "NACS DIAL-UP X.25"
    Else
      A2BGetParm = "NACS DIAL-UP ASYNC"
    End If
  Case "NACS DIRECT ASYNC"
    sOS = A2BGetParm(xA2VB, Cnacsdirx25)
    If sOS = "X.25" Then
      A2BGetParm = "NACS DIRECT X.25"
    Else
      A2BGetParm = sConnType
    End If
  Case "EICON XPAD"
    A2BGetParm = "EICON X-PAD"
  Case "UBASS NIU"
    A2BGetParm = "UNGERMANN-BASS NIU"
  Case "IRMA"
    A2BGetParm = "IRMA 3270 ADAPTER"
  Case "IBM"
    A2BGetParm = "IBM 3270 ADAPTER"
  Case "XIRCOM"
    A2BGetParm = "XIRCOM 3270 ADAPTER"
  Case Else
    A2BGetParm = sConnType
  End Select
   
'----------------------------------------------------------------------------

Case "EMULATION"
  sDevType = A2BGetParm(xA2VB, Csetupemulation)

  Select Case sDevType
  Case "3270"
    iEDS = A2BGetParm(xA2VB, C3270eds)
    If iEDS = 0 Then
      sTmpDev = "3278"
    Else
      sTmpDev = "3279"
    End If
    iModel = Val(A2BGetParm(xA2VB, C3270model))   ' Get model number
    Select Case iModel
      Case 2
        A2BGetParm = sTmpDev & " Model 2"
      Case 3
        A2BGetParm = sTmpDev & " Model 3"
      Case 4
        A2BGetParm = sTmpDev & " Model 4"
      Case 5
        A2BGetParm = sTmpDev & " Model 5"
      Case Else
        A2BGetParm = "-1"                    'Error - Unknown model number
    End Select
  Case Else
    A2BGetParm = sDevType
  End Select

'----------------------------------------------------------------------------------

Case "SERVER"
  sSrvType = UCase$(A2BGetParm(xA2VB, Csetupserver))

  Select Case sSrvType
  Case "SIM3278"
    sOS = A2BGetParm(xA2VB, Csim3278application)
    If sOS = "VM" Or sOS = "VM/VTAM" Or sOS = "VTAM" Then
      A2BGetParm = sSrvType & " " & sOS
    Else
      A2BGetParm = sOS
    End If
  Case "A2B"
    A2BGetParm = sSrvType & " MVS SERVER"
  Case Else
    A2BGetParm = sSrvType
  End Select

'------------------------------------------------------------------------------------

Case "TRANSFER"
  sXfrType = UCase$(A2BGetParm(xA2VB, Csetupfilexfer))

  Select Case sXfrType
  Case "SIMXFER"
    sOS = A2BGetParm(xA2VB, Csimxferos)
    A2BGetParm = sXfrType & " " & sOS
  Case "IND$FILE"
    sOS = A2BGetParm(xA2VB, Cindfileos)
    A2BGetParm = sXfrType & " " & sOS
  Case "XMODEM"
    sBS = A2BGetParm(xA2VB, Cxmodemblocksize)
    If sBS = "1K" Then
      A2BGetParm = sXfrType & " " & sBS
    Else
      A2BGetParm = sXfrType
    End If
  Case Else
    A2BGetParm = sXfrType
  End Select

'---------------------------------------------------------------------------------

Case Else
  ' sParmName is not one of the five main paramaters, so check if it is one
  ' of the regular parameters (such as BaudRate).
  sObj = A2BGetObject(xA2VB, sParmName)
  If sObj = "" Then
    A2BGetParm = "-1"                          'Syntax error - Invalid parameter name
  Else
    xA2VB.Object = sObj
    iIndex = A2BGetIndex(xA2VB, sParmName)
    If iIndex < 0 Then
      A2BGetParm = "-2"                        'Internal error - parameter name not in object
    Else
      A2BGetParm = xA2VB.ParameterValue(iIndex)
    End If
  End If
End Select
End Function

Sub A2BNewConnection (xA2VB As A2VB, sConn As String)
  Dim sDesiredEmul As String
  Dim sCurrentEmul As String
  Dim sTmp As String
  Dim sType As String
  Dim iSpcPos As Integer
  Dim i As Integer
    
  ' get the first word of the connection type (ie, IBM, IRMA, XIRCOM, ...)
  iSpcPos = InStr(1, sConn, " ")    ' Find space.
  If iSpcPos Then
    sType = Left$(sConn, iSpcPos - 1)  ' Get left word.
  Else
    sType = sConn
  End If

  sCurrentEmulation = "TTY"   'presume tty
  sDesiredEmulation = "TTY"   'presume tty
  
  sTmp = A2BGetParm(xA2VB, Csetupemulation)
  If (Mid$(sTmp, 1, 1) = "3") Then sCurrentEmulation = "3270"
  
  If (sType = "TN3270" Or sType = "IRMA" Or sType = "IBM" Or sType = "XIRCOM") Then sDesiredEmulation = "3270"

  If sCurrentEmulation = sDesiredEmulation Then Exit Sub    'nothing to do

  'the current is different from the desired, so need to set both emulation and
  'file transfer to match the desired mode.
  If sDesiredEmulation = "3270" Then
    i = A2BSetParm(xA2VB, Csetupemulation, "3270")
  Else
    i = A2BSetParm(xA2VB, Csetupemulation, "TTY")
  End If
    
  i = A2BSetParm(xA2VB, Csetupfilexfer, "None")

End Sub

Sub A2BObjInit ()
  gsA2BObjects(0) = ""    'the first string is intentionally null.
  gsA2BObjects(1) = "3270"
  gsA2BObjects(2) = "3287"
  gsA2BObjects(3) = "A2B"
  gsA2BObjects(4) = "A2B Session"
  gsA2BObjects(5) = "Advantage Program"
  gsA2BObjects(6) = "Dialup Async"
  gsA2BObjects(7) = "Direct Async"
  gsA2BObjects(8) = "Direct Async Programs"
  gsA2BObjects(9) = "Dialup Async Programs"
  gsA2BObjects(10) = "Coax Common"
  gsA2BObjects(11) = "Color"
  gsA2BObjects(12) = "DLC"
  gsA2BObjects(13) = "DMA Network Profile"
  gsA2BObjects(14) = "DMA Session Profile"
  gsA2BObjects(15) = "DMA System Profile"
  gsA2BObjects(16) = "DMA Sync X25"
  gsA2BObjects(17) = "Eicon SDLC Gateway"
  gsA2BObjects(18) = "Eicon X.25 Gateway"
  gsA2BObjects(19) = "Eicon X.25 Gateway Programs"
  gsA2BObjects(20) = "Eicon XPAD"
  gsA2BObjects(21) = "Eicon XPAD Programs"
  gsA2BObjects(22) = "Font"
  gsA2BObjects(23) = "Generic Int 14"
  gsA2BObjects(24) = "Protocol Converter"
  gsA2BObjects(25) = "IBM"
  gsA2BObjects(26) = "IND$FILE"
  gsA2BObjects(27) = "IND$FILE Common"
  gsA2BObjects(28) = "IND$FILE Send"
  gsA2BObjects(29) = "Generic Int 14 Programs"
  gsA2BObjects(30) = "IPXSPX"
  gsA2BObjects(31) = "IRMA"
  gsA2BObjects(32) = "Kermit"
  gsA2BObjects(33) = "Kermit Common"
  gsA2BObjects(34) = "Keypad"
  gsA2BObjects(35) = "LAN Application"
  gsA2BObjects(36) = "Local Application"
  gsA2BObjects(37) = "Logon"
  gsA2BObjects(38) = "Modem Commands"
  gsA2BObjects(39) = "NACS Dialup Async"
  gsA2BObjects(40) = "NACS Direct Async"
  gsA2BObjects(41) = "NACS Direct Async Programs"
  gsA2BObjects(42) = "Service Name"
  gsA2BObjects(43) = "NACS Dialup Async Programs"
  gsA2BObjects(44) = "None"
  gsA2BObjects(45) = "Novell NetWare"
  gsA2BObjects(46) = "Async Settings"
  gsA2BObjects(47) = "Preferences"
  gsA2BObjects(48) = "Print"
  gsA2BObjects(49) = "Logoff Programs"
  gsA2BObjects(50) = "Logon Programs"
  gsA2BObjects(51) = "Server Programs"
  gsA2BObjects(52) = "X.25 Programs"
  gsA2BObjects(53) = "A2B Remote LAN"
  gsA2BObjects(54) = "A2B Remote LAN Programs"
  gsA2BObjects(55) = "NetWare SAA"
  gsA2BObjects(56) = "Security"
  gsA2BObjects(57) = "Session"
  gsA2BObjects(58) = "Setup"
  gsA2BObjects(59) = "Sim3278"
  gsA2BObjects(60) = "SimXfer"
  gsA2BObjects(61) = "SimXfer Common"
  gsA2BObjects(62) = "SimXfer Receive"
  gsA2BObjects(63) = "SimXfer Send"
  gsA2BObjects(64) = "SLIP/PPP"
  gsA2BObjects(65) = "SLIP Advantage Program"
  gsA2BObjects(66) = "SLIP Local Application"
  gsA2BObjects(67) = "A2B SLIP/PPP Programs"
  gsA2BObjects(68) = "SLIP A2B Session"
  gsA2BObjects(69) = "Telnet"
  gsA2BObjects(70) = "TN3270"
  gsA2BObjects(71) = "TTY"
  gsA2BObjects(72) = "UBass NIU"
  gsA2BObjects(73) = "Ungermann Bass NIU Programs"
  gsA2BObjects(74) = "VT100"
  gsA2BObjects(75) = "VT220"
  gsA2BObjects(76) = "X.25"
  gsA2BObjects(77) = "X.3"
  gsA2BObjects(78) = "Xircom"
  gsA2BObjects(79) = "Xmodem"
  gsA2BObjects(80) = "Xmodem Common"
  gsA2BObjects(81) = "Ymodem"
  gsA2BObjects(82) = "Ymodem Common"
  gsA2BObjects(83) = "YmodemG"
  gsA2BObjects(84) = "YmodemG Common"
  gsA2BObjects(85) = "Zmodem"
  gsA2BObjects(86) = "Zmodem Common"

  bA2BObjInit = True
End Sub

Function A2BSetConnection (xA2VB As A2VB, sConn As String) As Integer
  Dim i As Integer

  A2BSetConnection = 0

  i = A2BSetParm(xA2VB, Csetupconnection, sConn)
  If i <> 0 Then
    A2BSetConnection = i
    Exit Function
  End If

  A2BSetConnection = xA2VB.ObjectSave
End Function

Function A2BSetEmulation (xA2VB As A2VB, sEmul As String) As Integer
  Dim i As Integer

  A2BSetEmulation = 0

  i = A2BSetParm(xA2VB, Csetupemulation, sEmul)
  If i <> 0 Then
    A2BSetEmulation = i
    Exit Function
  End If

  A2BSetEmulation = xA2VB.ObjectSave
End Function

Function A2BSetParm (xA2VB As A2VB, sParmName As String, sParmValue As String) As Integer

' Declarations
Dim i As Integer
Dim sEDS As String
Dim iSpcPos As Integer
Dim sBS As String
Dim sDevType As String
Dim sOS As String
Dim sSrvType As String
Dim sXfrType As String
Dim iIndex As Integer
Dim sObj As String
Dim sOrgParmValue As String

If bA2BObjInit <> True Then A2BObjInit

sParmName = UCase$(sParmName)         ' Uppercase before doing anything
sOrgParmValue = sParmValue            ' preserve case of value
sParmValue = UCase$(sParmValue)
A2BSetParm = 0

Select Case sParmName
Case "APPLICATION"
  i = A2BSetParm(xA2VB, Csetupapplication, sOrgParmValue)
  If i = 0 Then
    A2BSetParm = xA2VB.ObjectSave
  Else
    A2BSetParm = i
  End If

'----------------------------------------------------------------------------------

Case "CONNECTION"

  Select Case sParmValue
  Case "DIAL-UP ASYNC"
    ' Call the sub that resets the emulation and transfer settings if a
    ' TTY->3270 or 3270->TTY change occurs based on this new connection.
    A2BNewConnection xA2VB, sParmValue
    i = A2BSetConnection(xA2VB, "Dialup Async")
    If i <> 0 Then
      A2BSetParm = i
      Exit Function
    End If

    i = A2BSetParm(xA2VB, CasyncdiaX25, "None")
    If (i = 0) Then i = xA2VB.ObjectSave
    A2BSetParm = i

  Case "DIAL-UP X.25"
    A2BNewConnection xA2VB, sParmValue
    i = A2BSetConnection(xA2VB, "Dialup Async")
    If i <> 0 Then
      A2BSetParm = i
      Exit Function
    End If

    i = A2BSetParm(xA2VB, CasyncdiaX25, "X.25")
    If (i = 0) Then i = xA2VB.ObjectSave
    A2BSetParm = i

  Case "DIRECT ASYNC"
    A2BNewConnection xA2VB, sParmValue
    i = A2BSetConnection(xA2VB, "Direct Async")
    If i <> 0 Then
      A2BSetParm = i
      Exit Function
    End If

    i = A2BSetParm(xA2VB, CasyncdirX25, "None")
    If (i = 0) Then i = xA2VB.ObjectSave
    A2BSetParm = i

  Case "DIRECT X.25"
    A2BNewConnection xA2VB, sParmValue
    i = A2BSetConnection(xA2VB, "Direct Async")
    If i <> 0 Then
      A2BSetParm = i
      Exit Function
    End If

    i = A2BSetParm(xA2VB, CasyncdirX25, "X.25")
    If (i = 0) Then i = xA2VB.ObjectSave
    A2BSetParm = i

  Case "EICON X.25 GATEWAY"
    A2BNewConnection xA2VB, sParmValue
    A2BSetParm = A2BSetConnection(xA2VB, "Eicon X.25 Gateway")

  Case "EICON X.PAD"
    A2BNewConnection xA2VB, sParmValue
    A2BSetParm = A2BSetConnection(xA2VB, "Eicon XPAD")

  Case "UNGERMANN-BASS NIU"
    A2BNewConnection xA2VB, sParmValue
    A2BSetParm = A2BSetConnection(xA2VB, "Ubass NIU")
  
  Case "GENERIC INT 14"
    A2BNewConnection xA2VB, sParmValue
    A2BSetParm = A2BSetConnection(xA2VB, "Generic Int 14")
  
  Case "TELNET"
    A2BNewConnection xA2VB, sParmValue
    A2BSetParm = A2BSetConnection(xA2VB, "Telnet")
  
  Case "TN3270"
    A2BNewConnection xA2VB, sParmValue
    A2BSetParm = A2BSetConnection(xA2VB, "TN3270")
  
  Case "IRMA 3270 ADAPTER"
    A2BNewConnection xA2VB, sParmValue
    A2BSetParm = A2BSetConnection(xA2VB, "IRMA")
  
  Case "IBM 3270 ADAPTER"
    A2BNewConnection xA2VB, sParmValue
    i = A2BSetConnection(xA2VB, "IBM")
    If i <> 0 Then
      A2BSetParm = i
      Exit Function
    End If
  
    i = A2BSetParm(xA2VB, C3270eds, "0")
    If (i = 0) Then i = xA2VB.ObjectSave
    A2BSetParm = i

  Case "XIRCOM 3270 ADAPTER"
    A2BNewConnection xA2VB, sParmValue
    i = A2BSetConnection(xA2VB, "Xircom")
    If i <> 0 Then
      A2BSetParm = i
      Exit Function
    End If
  
    i = A2BSetParm(xA2VB, C3270eds, "0")
    If (i = 0) Then i = A2BSetParm(xA2VB, C3270model, "2")
    If (i = 0) Then i = xA2VB.ObjectSave
    A2BSetParm = i

  Case "NACS DIAL-UP ASYNC"
    A2BNewConnection xA2VB, sParmValue
    i = A2BSetConnection(xA2VB, "NACS Dialup Async")
    If i <> 0 Then
      A2BSetParm = i
      Exit Function
    End If

    i = A2BSetParm(xA2VB, Cnacsdialx25, "None")
    If (i = 0) Then i = xA2VB.ObjectSave
    A2BSetParm = i

  Case "NACS DIAL-UP X.25"
    A2BNewConnection xA2VB, sParmValue
    i = A2BSetConnection(xA2VB, "NACS Dialup Async")
    If i <> 0 Then
      A2BSetParm = i
      Exit Function
    End If

    i = A2BSetParm(xA2VB, Cnacsdialx25, "X.25")
    If (i = 0) Then i = xA2VB.ObjectSave
    A2BSetParm = i

  Case "NACS DIRECT ASYNC"
    A2BNewConnection xA2VB, sParmValue
    i = A2BSetConnection(xA2VB, "NACS Direct Async")
    If i <> 0 Then
      A2BSetParm = i
      Exit Function
    End If

    i = A2BSetParm(xA2VB, Cnacsdirx25, "None")
    If (i = 0) Then i = xA2VB.ObjectSave
    A2BSetParm = i

  Case "NACS DIRECT X.25"
    A2BNewConnection xA2VB, sParmValue
    i = A2BSetConnection(xA2VB, "NACS Direct Async")
    If i <> 0 Then
      A2BSetParm = i
      Exit Function
    End If

    i = A2BSetParm(xA2VB, Cnacsdirx25, "X.25")
    If (i = 0) Then i = xA2VB.ObjectSave
    A2BSetParm = i

  Case Else
    A2BSetParm = -999                             'Invalid Connection Method
  End Select
   
'------------------------------------------------------------------------------------

Case "EMULATION"
  iSpcPos = InStr(1, sParmValue, " ")  ' Find space.
  If iSpcPos Then
    sDevType = Left$(sParmValue, iSpcPos - 1)  ' Get left word.
  Else
    sDevType = sParmValue
  End If

  Select Case sDevType
  Case "TTY"
    If Len(sParmValue) = 3 Then
      A2BSetParm = A2BSetEmulation(xA2VB, "TTY")
    Else
      A2BSetParm = -999                      'Syntax error - Incorrect device type
    End If

  Case "VT100"
    If Len(sParmValue) = 5 Then
      A2BSetParm = A2BSetEmulation(xA2VB, "VT100")
    Else
      A2BSetParm = -999                      'Syntax error - Incorrect device type
    End If

  Case "VT220"
    If Len(sParmValue) = 5 Then
      A2BSetParm = A2BSetEmulation(xA2VB, "VT220")
    Else
      A2BSetParm = -999                      'Syntax error - Incorrect device type
    End If

  Case "3287"
    If Len(sParmValue) = 4 Then
      A2BSetParm = A2BSetEmulation(xA2VB, "3287")
    Else
      A2BSetParm = -999                      'Syntax error - Incorrect device type
    End If

  Case "3278" To "3279"
    i = A2BSetEmulation(xA2VB, "3270")
    If (i <> 0) Then
      A2BSetParm = i
      Exit Function
    End If
    
    If iSpcPos > 0 Then
      If sDevType = "3278" Then
        sEDS = "0"
      Else
        sEDS = "1"
      End If
    
      i = A2BSetParm(xA2VB, C3270eds, sEDS)
      If (i <> 0) Then
        A2BSetParm = i
        Exit Function
      End If

      sModel = Right$(sParmValue, Len(sParmValue) - iSpcPos) ' Get model number
      Select Case sModel
        Case "MODEL 2"
          i = A2BSetParm(xA2VB, C3270model, "2")
          If (i <> 0) Then
            A2BSetParm = i
            Exit Function
          End If

          i = xA2VB.ObjectSave
          If i <> 0 Then
            A2BSetParm = i
          End If
        
        Case "MODEL 3"
          i = A2BSetParm(xA2VB, C3270model, "3")
          If (i <> 0) Then
            A2BSetParm = i
            Exit Function
          End If

          i = xA2VB.ObjectSave
          If i <> 0 Then
            A2BSetParm = i
          End If
        
        Case "MODEL 4"
          i = A2BSetParm(xA2VB, C3270model, "4")
          If (i <> 0) Then
            A2BSetParm = i
            Exit Function
          End If

          i = xA2VB.ObjectSave
          If i <> 0 Then
            A2BSetParm = i
          End If
        
        Case "MODEL 5"
          i = A2BSetParm(xA2VB, C3270model, "5")
          If (i <> 0) Then
            A2BSetParm = i
            Exit Function
          End If

          i = xA2VB.ObjectSave
          If i <> 0 Then
            A2BSetParm = i
          End If
        
        Case Else
          A2BSetParm = -999                 'Syntax error - Expected model number here
      End Select
      Else
        A2BSetParm = -999                   'Syntax error - No model number specified
      End If
  Case Else
    A2BSetParm = -999                       'Syntax error - Incorrect device type
  End Select

'------------------------------------------------------------------------------------

Case "SERVER"
  iSpcPos = InStr(1, sParmValue, " ")    ' Find space.
  If iSpcPos Then
    sSrvType = Left$(sParmValue, iSpcPos - 1)  ' Get left word.
  Else
    sSrvType = sParmValue
  End If

  Select Case sSrvType
  Case "NONE"
    If Len(sParmValue) = 4 Then
      xA2VB.Object = "Setup"
      xA2VB.ParameterValue(10) = "None"
      If xA2VB.ParameterValue(1) <> "IRMA" And xA2VB.ParameterValue(1) <> "IBM" And xA2VB.ParameterValue(1) <> "Xircom" And xA2VB.ParameterValue(1) <> "TN3270" And (xA2VB.ParameterValue(3) = "3270" Or xA2VB.ParameterValue(3) = "3287") Then
        xA2VB.ParameterValue(3) = "TTY"
      End If
      If xA2VB.ParameterValue(1) <> "IRMA" And xA2VB.ParameterValue(1) <> "IBM" And xA2VB.ParameterValue(1) <> "Xircom" And xA2VB.ParameterValue(1) <> "TN3270" And (xA2VB.ParameterValue(4) = "SimXfer" Or xA2VB.ParameterValue(4) = "IND$FILE") Then
        xA2VB.ParameterValue(4) = "None"
      End If
      i = xA2VB.ObjectSave
      If i <> 0 Then
        A2BSetParm = i
      End If
    Else
      A2BSetParm = -999                      'Syntax error - Incorrect server type
    End If

  Case "SLIP/PPP"
    If Len(sParmValue) = 8 Then
      xA2VB.Object = "Setup"
      xA2VB.ParameterValue(10) = "SLIP/PPP"
      If xA2VB.ParameterValue(1) <> "Dialup Async" And xA2VB.ParameterValue(1) <> "Direct Async" Then
        xA2VB.ParameterValue(1) = "Dialup Async"
      End If
      If xA2VB.ParameterValue(3) = "3270" Or xA2VB.ParameterValue(3) = "3287" Then
        xA2VB.ParameterValue(3) = "TTY"
      End If
      If xA2VB.ParameterValue(4) <> "None" Then
        xA2VB.ParameterValue(4) = "None"
      End If
      i = xA2VB.ObjectSave
      If i <> 0 Then
        A2BSetParm = i
      End If
    Else
      A2BSetParm = -999                      'Syntax error - Incorrect server type
    End If

  Case "SIM3278"
    If iSpcPos > 0 Then
      sOS = Right$(sParmValue, Len(sParmValue) - iSpcPos) ' Get O/S
      If sOS = "VM" Or sOS = "VTAM" Or sOS = "VM/VTAM" Then
        xA2VB.Object = "Sim3278"
        xA2VB.ParameterValue(0) = sOS
        i = xA2VB.ObjectSave
        If i <> 0 Then
          A2BSetParm = i
        End If
        xA2VB.Object = "Setup"
        xA2VB.ParameterValue(10) = "Sim3278"
        Select Case xA2VB.ParameterValue(1)
          Case "IPXSPX", "TN3270", "IRMA", "IBM", "Xircom", "DMA Sync X25"
            xA2VB.ParameterValue(1) = "Dialup Async"
          Case Else
            If sOS = "VM" And xA2VB.ParameterValue(1) = "Telnet" Then
              xA2VB.ParameterValue(1) = "Dialup Async"
            End If
        End Select
        If xA2VB.ParameterValue(3) <> "3270" Then
          xA2VB.ParameterValue(3) = "3270"
        End If
        If xA2VB.ParameterValue(4) <> "SimXfer" And xA2VB.ParameterValue(4) <> "IND$FILE" And xA2VB.ParameterValue(4) <> "None" Then
          xA2VB.ParameterValue(4) = "None"
        End If
        i = xA2VB.ObjectSave
        If i <> 0 Then
          A2BSetParm = i
        End If
      Else
          A2BSetParm = -999                  'Syntax error - Expected O/S
      End If
    Else
      A2BSetParm = -999                      'Syntax error - Incorrect server type
    End If

  Case "SIMTCP/IP"
    If iSpcPos > 0 Then
      sOS = Right$(sParmValue, Len(sParmValue) - iSpcPos) ' Get O/S
      If sOS = "MVS" Or sOS = "VM" Then
        xA2VB.Object = "Sim3278"
        xA2VB.ParameterValue(0) = "SimTCP/IP " & sOS
        i = xA2VB.ObjectSave
        If i <> 0 Then
          A2BSetParm = i
        End If
        xA2VB.Object = "Setup"
        xA2VB.ParameterValue(10) = "Sim3278"
        If xA2VB.ParameterValue(1) <> "Telnet" Then
          xA2VB.ParameterValue(1) = "Telnet"
        End If
        If xA2VB.ParameterValue(4) <> "SimXfer" And xA2VB.ParameterValue(4) <> "IND$FILE" And xA2VB.ParameterValue(4) <> "None" Then
          xA2VB.ParameterValue(4) = "None"
        End If
        If xA2VB.ParameterValue(3) <> "3270" Then
          xA2VB.ParameterValue(3) = "3270"
        End If
        i = xA2VB.ObjectSave
        If i <> 0 Then
          A2BSetParm = i
        Else
          xA2VB.Object = "3270"
          xA2VB.ParameterValue(8) = 2
          xA2VB.ParameterValue(5) = 0
          i = xA2VB.ObjectSave
          If i <> 0 Then
            A2BSetParm = i
          End If
        End If
      Else
        A2BSetParm = -999                 'Syntax error - Expected O/S
      End If
    Else
      A2BSetParm = -999                      'Syntax error - Incorrect server type
    End If

  Case "A2B"
    If sParmValue = "A2B MVS SERVER" Then
      xA2VB.Object = "Setup"
      xA2VB.ParameterValue(10) = sSrvType
      If xA2VB.ParameterValue(1) = "TN3270" Or xA2VB.ParameterValue(1) = "IRMA" Or xA2VB.ParameterValue(1) = "IBM" Or xA2VB.ParameterValue(1) = "Xircom" Then
        xA2VB.ParameterValue(1) = "Dialup Async"
      End If
      If xA2VB.ParameterValue(3) <> "3270" Then
        xA2VB.ParameterValue(3) = "3270"
      End If
      If xA2VB.ParameterValue(4) <> "SimXfer" And xA2VB.ParameterValue(4) <> "IND$FILE" And xA2VB.ParameterValue(4) <> "None" Then
        xA2VB.ParameterValue(4) = "None"
      End If
      i = xA2VB.ObjectSave
      If i <> 0 Then
        A2BSetParm = i
      End If
    Else
      If sParmValue = "A2B REMOTE LAN" Then
        xA2VB.Object = "Setup"
        xA2VB.ParameterValue(10) = "A2B Remote LAN"
        If xA2VB.ParameterValue(1) <> "Dialup Async" And xA2VB.ParameterValue(1) <> "Direct Async" Then
          xA2VB.ParameterValue(1) = "Dialup Async"
        End If
        xA2VB.ParameterValue(7) = "None"
        xA2VB.ParameterValue(8) = "Novell NetWare"
        i = xA2VB.ObjectSave
        If i <> 0 Then
          xA2VB.Object = "Direct Async"
          xA2VB.ParameterValue(5) = "X.25"
          i = xA2VB.ObjectSave
          If i <> 0 Then
            A2BSetParm = i
          Else
            xA2VB.Object = "Setup"
            xA2VB.ParameterValue(10) = "A2B Remote LAN"
            If xA2VB.ParameterValue(1) <> "Dialup Async" And xA2VB.ParameterValue(1) <> "Direct Async" Then
              xA2VB.ParameterValue(1) = "Dialup Async"
            End If
            xA2VB.ParameterValue(7) = "None"
            xA2VB.ParameterValue(8) = "Novell NetWare"
            i = xA2VB.ObjectSave
            If i <> 0 Then
              A2BSetParm = i
            End If
          End If
        End If
      Else
        A2BSetParm = -1                      'Syntax error - Invalid server type
      End If
    End If

  'Case "EICON"
  '  If iSpcPos > 0 Then
  '    sBS = Right$(sParmValue, Len(sParmValue) - iSpcPos)
  '    If sBS = "SDLC GATEWAY" Then
  '      xA2VB.Object = "Setup"
  '      xA2VB.ParameterValue(10) = "Eicon SDLC Gateway"
  '    Else
  '      A2BSetParm = -1                    'Syntax error - Invalid server type
  '    End If
  '  Else
  '    A2BSetParm = -1                      'Syntax error - Invalid server type
  '  End If

  Case "PROTOCOL"
    If sParmValue = "PROTOCOL CONVERTER" Then
      xA2VB.Object = "Setup"
      xA2VB.ParameterValue(10) = "Protocol Converter"
      Select Case xA2VB.ParameterValue(1)
      Case "IRMA", "IBM", "Xircom", "Telnet", "TN3270", "IPXSPX", "DMA Sync X25"
        xA2VB.ParameterValue(1) = "Dialup Async"
      End Select
      If xA2VB.ParameterValue(3) <> "3270" Then
        xA2VB.ParameterValue(3) = "3270"
      End If
      If xA2VB.ParameterValue(4) <> "SimXfer" And xA2VB.ParameterValue(4) <> "None" Then
        xA2VB.ParameterValue(4) = "None"
      End If
      i = xA2VB.ObjectSave
      If i <> 0 Then
        A2BSetParm = i
      End If
    Else
      A2BSetParm = -999                    'Syntax error - Invalid server type
    End If

  Case "NETWARE"
    If sParmValue = "NETWARE SAA" Then
      xA2VB.Object = "Setup"
      xA2VB.ParameterValue(10) = "NetWare SAA"
      xA2VB.ParameterValue(1) = "IPXSPX"
      If xA2VB.ParameterValue(3) <> "3270" Then
        xA2VB.ParameterValue(3) = "3270"
      End If
      If xA2VB.ParameterValue(4) <> "SimXfer" And xA2VB.ParameterValue(4) <> "IND$FILE" And xA2VB.ParameterValue(4) <> "None" Then
        xA2VB.ParameterValue(4) = "None"
      End If
      i = xA2VB.ObjectSave
      If i <> 0 Then
        A2BSetParm = i
      End If
    Else
      A2BSetParm = -999                    'Syntax error - Invalid server type
    End If
  Case Else
    A2BSetParm = -999
  End Select

'------------------------------------------------------------------------------------

Case "TRANSFER"
  iSpcPos = InStr(1, sParmValue, " ")  ' Find space.
  If iSpcPos Then
    sXfrType = Left$(sParmValue, iSpcPos - 1)  ' Get left word.
  Else
    sXfrType = sParmValue
  End If

  Select Case sXfrType
  Case "KERMIT"
    If Len(sParmValue) = 6 Then
      i = A2BSetParm(xA2VB, Csetupfilexfer, "Kermit")
      If i = 0 Then A2BSetParm = xA2VB.ObjectSave
    Else
      A2BSetParm = -999                       'Syntax error - Invalid Xfer type
    End If

  Case "YMODEM"
    If Len(sParmValue) = 6 Then
      i = A2BSetParm(xA2VB, Csetupfilexfer, "Ymodem")
      If i = 0 Then A2BSetParm = xA2VB.ObjectSave
    Else
      A2BSetParm = -999                       'Syntax error - Invalid Xfer type
    End If

  Case "YMODEMG"
    If Len(sParmValue) = 7 Then
      i = A2BSetParm(xA2VB, Csetupfilexfer, "YmodemG")
      If i = 0 Then A2BSetParm = xA2VB.ObjectSave
    Else
      A2BSetParm = -999                       'Syntax error - Invalid Xfer type
    End If

  Case "SIMXFER"
    If iSpcPos > 0 Then
      sOS = Right$(sParmValue, Len(sParmValue) - iSpcPos) ' Get O/S
      If sOS = "CMS" Or sOS = "TSO" Or sOS = "VTAM" Or sOS = "CICS" Then
        i = A2BSetParm(xA2VB, Csetupfilexfer, "SimXfer")
        If i = 0 Then i = xA2VB.ObjectSave
        
        If i <> 0 Then
          A2BSetParm = i
        Else
          i = A2BSetParm(xA2VB, Csimxferos, sOS)
          If i = 0 Then A2BSetParm = xA2VB.ObjectSave
        End If
      Else
        A2BSetParm = -999                     'Syntax error - Expected O/S
      End If
    Else
      A2BSetParm = -999                       'Syntax error - Invalid Xfer type
    End If

  Case "IND$FILE"
    If iSpcPos > 0 Then
      sOS = Right$(sParmValue, Len(sParmValue) - iSpcPos) ' Get O/S
      If sOS = "CMS" Or sOS = "TSO" Or sOS = "CICS" Then
        i = A2BSetParm(xA2VB, Csetupfilexfer, "IND$FILE")
        If i = 0 Then i = xA2VB.ObjectSave
        
        If i <> 0 Then
          A2BSetParm = i
        Else
          i = A2BSetParm(xA2VB, Cindfileos, sOS)
          If i = 0 Then A2BSetParm = xA2VB.ObjectSave
        End If
      Else
          A2BSetParm = -999                   'Syntax error - Expected O/S
      End If
    Else
      A2BSetParm = -999                      'Syntax error - Invalid Xfer type
    End If

  Case "XMODEM"
    If Len(sParmValue) = 6 Then
      i = A2BSetParm(xA2VB, Csetupfilexfer, "Xmodem")
      If i = 0 Then i = xA2VB.ObjectSave
      
      If i <> 0 Then
        A2BSetParm = i
      Else
        i = A2BSetParm(xA2VB, Cxmodemblocksize, "128")
        If i = 0 Then A2BSetParm = xA2VB.ObjectSave
      End If
    Else
      If iSpcPos > 0 Then
        sBS = Right$(sParmValue, Len(sParmValue) - iSpcPos) ' Get Block Size
        If sBS = "1K" Then
          i = A2BSetParm(xA2VB, Csetupfilexfer, "Xmodem")
          If i = 0 Then i = xA2VB.ObjectSave
          
          If i <> 0 Then
            A2BSetParm = i
          Else
            i = A2BSetParm(xA2VB, Cxmodemblocksize, sBS)
            If i = 0 Then A2BSetParm = xA2VB.ObjectSave
          End If
        Else
          A2BSetParm = -999                    'Syntax error - Invalid Xfer type
        End If
      Else
        A2BSetParm = -999                      'Syntax error - Invalid Xfer type
      End If
    End If

  Case "ZMODEM"
    If Len(sParmValue) = 6 Then
      i = A2BSetParm(xA2VB, Csetupfilexfer, "Zmodem")
      If i = 0 Then A2BSetParm = xA2VB.ObjectSave
    Else
      A2BSetParm = -999                        'Syntax error - Invalid Xfer type
    End If

  Case "NONE"
    If Len(sParmValue) = 4 Then
      i = A2BSetParm(xA2VB, Csetupfilexfer, "None")
      If i = 0 Then A2BSetParm = xA2VB.ObjectSave
    Else
      A2BSetParm = -999                        'Syntax error - Invalid Xfer type
    End If
  Case Else
    A2BSetParm = -999
  End Select

Case Else
  ' sParmName is not one of the five main paramaters, so check if it is one
  ' of the regular parameters (such as BaudRate).
  sObj = A2BGetObject(xA2VB, sParmName)
  If sObj = "" Then
    A2BSetParm = -998                          'Syntax error - Invalid parameter name
  Else
    If (sObj <> xA2VB.Object) Then xA2VB.Object = sObj  'only get if you have to
    iIndex = A2BGetIndex(xA2VB, sParmName)
    If iIndex < 0 Then
      A2BSetParm = -997                        'Internal error - parameter name not in object
    Else
      xA2VB.ParameterValue(iIndex) = sOrgParmValue
      A2BSetParm = xA2VB.ObjectSave
    End If
  End If
End Select
sParmValue = sOrgParmValue            ' preserve case of value

End Function

