VERSION 2.00
Begin Form SessTTY 
   BackColor       =   &H00C0C0C0&
   Caption         =   "TTY / VTxxx Session Configuration (sesstty.frm)"
   ClientHeight    =   4305
   ClientLeft      =   1350
   ClientTop       =   2055
   ClientWidth     =   7365
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   4710
   Left            =   1290
   LinkTopic       =   "Form5"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4305
   ScaleWidth      =   7365
   Top             =   1710
   Width           =   7485
   Begin CommandButton btnOptions 
      Caption         =   "type Options"
      Height          =   495
      Left            =   2310
      TabIndex        =   10
      Top             =   1395
      Width           =   1560
   End
   Begin TextBox txtAppl 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   3135
      MaxLength       =   8
      TabIndex        =   19
      Text            =   "txtAppl"
      Top             =   2700
      Width           =   1620
   End
   Begin TextBox txtName 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   2700
      MaxLength       =   8
      TabIndex        =   15
      Text            =   "VBTTY"
      Top             =   270
      Width           =   1215
   End
   Begin Frame frm 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Terminal Type"
      ClipControls    =   0   'False
      Height          =   1410
      Left            =   480
      TabIndex        =   12
      Top             =   765
      Width           =   1650
      Begin OptionButton optVT220 
         BackColor       =   &H00C0C0C0&
         Caption         =   "VT&220"
         Height          =   270
         Left            =   165
         TabIndex        =   18
         Top             =   1080
         Width           =   975
      End
      Begin OptionButton optVT100 
         BackColor       =   &H00C0C0C0&
         Caption         =   "VT&100"
         Height          =   330
         Left            =   150
         TabIndex        =   14
         Top             =   675
         Width           =   960
      End
      Begin OptionButton optTTY 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&TTY"
         Height          =   315
         Left            =   165
         TabIndex        =   13
         Top             =   345
         Value           =   -1  'True
         Width           =   855
      End
   End
   Begin Frame frmHost 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Host Information"
      Height          =   1815
      Left            =   480
      TabIndex        =   2
      Top             =   2355
      Width           =   5085
      Begin ComboBox cboXfer 
         Height          =   300
         Left            =   2655
         Style           =   2  'Dropdown List
         TabIndex        =   5
         Top             =   1350
         Width           =   1620
      End
      Begin TextBox txtPassword 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   2655
         MaxLength       =   8
         TabIndex        =   4
         Text            =   "txtpassw"
         Top             =   1035
         Width           =   1620
      End
      Begin TextBox txtUserid 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   2655
         MaxLength       =   8
         TabIndex        =   3
         Text            =   "txtUseri"
         Top             =   690
         Width           =   1620
      End
      Begin Label lblXfer 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&File Transfer"
         Height          =   240
         Left            =   405
         TabIndex        =   9
         Top             =   1380
         Width           =   1125
      End
      Begin Label lblPassword 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Pass&word "
         Height          =   225
         Left            =   405
         TabIndex        =   8
         Top             =   1065
         Width           =   1785
      End
      Begin Label lblUserid 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Userid for Application"
         Height          =   225
         Left            =   405
         TabIndex        =   7
         Top             =   750
         Width           =   1905
      End
      Begin Label lblAppl 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Host &Application Name"
         Height          =   240
         Left            =   420
         TabIndex        =   6
         Top             =   420
         Width           =   2055
      End
   End
   Begin CommandButton btnCancel 
      Caption         =   "Cancel"
      Height          =   495
      Left            =   6015
      TabIndex        =   1
      Top             =   750
      Width           =   1215
   End
   Begin CommandButton btnOK 
      Caption         =   "OK"
      Height          =   495
      Left            =   6000
      TabIndex        =   0
      Top             =   195
      Width           =   1215
   End
   Begin Label lblOptions 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Terminal Type Specific Options"
      Height          =   495
      Left            =   3990
      TabIndex        =   11
      Top             =   1440
      Width           =   1560
   End
   Begin Label lblName 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Connection Profile &Name"
      Height          =   285
      Left            =   495
      TabIndex        =   17
      Top             =   315
      Width           =   2175
   End
   Begin Label lblNameDesc 
      BackColor       =   &H00C0C0C0&
      Caption         =   "(1-8 Characters)"
      Height          =   240
      Left            =   4000
      TabIndex        =   16
      Top             =   315
      Width           =   1590
   End
End
Option Explicit

Dim sTermType As String
Dim sTermTypeOrig As String

Sub btnCancel_Click ()
  Dim iRc As Integer

  giSessType = gSESSCANCEL
  
  'Reset Terminal Type on Cancel
  iRc = A2BSetParm(ghSWA2VB, A2VB_EMULATION, sTermTypeOrig)
  Unload Me
End Sub

Sub btnOK_Click ()
  Dim iRc As Integer
  Dim sEmul As String
  Dim sXfer As String
  Dim sAppl As String
  Dim sUserid As String
  Dim sPassword As String
  Dim sPath As String
  Dim sMsg As String

  'check for second time thru
  If giConfigNameSet = False Then
    'Ensure a value is in the config name field.
    If txtName.Text = "" Then
      txtName.SetFocus
      Exit Sub
    End If
    
    'Ensure that the selected Configuration Name doesn't already exist.
    On Error Resume Next
    sPath = ghSWA2VB.DataPath
    sPath = sPath & "\" & txtName.Text & ".wsd"
    Open sPath For Input As #1
    
    If Err = 0 Then
      Close #1
      sMsg = "The " & txtName.Text & " profile name already exists.  Do you want to overwrite it?"
      iRc = MsgBox(sMsg, MB_YESNO, "Profile Exists")
      If iRc = IDNO Then
        txtName.SetFocus
        Exit Sub
      End If
    Else
      If Err <> 53 Then
        sMsg = "File Open Error: " & Err
        MsgBox sMsg, MB_OK
        txtName.SetFocus
        Exit Sub
      End If
    End If
  
    'Don't allow user to modify session from here on.
    giConfigNameSet = True
    gsProfileName = txtName.Text
  
    'Set the A2B Session name to the Configuration Name.
    ghSWA2VB.Session = txtName.Text
  End If

  iRc = A2BSetParm(ghSWA2VB, A2VB_EMULATION, sTermType)
  
  sXfer = cboXfer.Text
  iRc = A2BSetParm(ghSWA2VB, A2VB_TRANSFER, sXfer)
  
  sAppl = txtAppl.Text
  iRc = A2BSetParm(ghSWA2VB, A2VB_APPLICATION, sAppl)
  
  sUserid = txtUserid.Text
  iRc = A2BSetParm(ghSWA2VB, Clogonuserid, sUserid)
  
  sPassword = txtPassword.Text
  iRc = A2BSetParm(ghSWA2VB, Clogonpassword, sPassword)

  Unload Me

End Sub

Sub btnOptions_Click ()
  Dim iDlgID As Integer

  iDlgID = A2VB_DLG_SESSIONSETUP  'set default to main setup screen

  Select Case sTermType
    Case "TTY"
    iDlgID = A2VB_DLG_TTY

    Case "VT100"
    iDlgID = A2VB_DLG_VT100

    Case "VT220"
    iDlgID = A2VB_DLG_VT220
  End Select

  ghSWA2VB.Setup = iDlgID
End Sub

Sub Form_Load ()
  Dim sXfer As String
  Dim sPassword As String
  Dim i As Integer

  CentreForm Me

  'Disable the name field if it has already been set.
  If giConfigNameSet Then
    txtName.Text = gsProfileName
    txtName.Enabled = False
  Else
    txtName.Enabled = True
  End If

  'Initialize the Terminal Type and Options button caption
  sTermTypeOrig = A2BGetParm(ghSWA2VB, A2VB_EMULATION)
  Select Case sTermTypeOrig
    Case "TTY"
      optTTY.Value = True
      btnOptions.Caption = TTY_CAPTION
    Case "VT100"
      optVT100.Value = True
      btnOptions.Caption = VT100_CAPTION
    Case "VT220"
      optVT220.Value = True
      btnOptions.Caption = VT220_CAPTION
  End Select
  
  'Initialize the File Transfer Types
  sXfer = A2BGetParm(ghSWA2VB, A2VB_TRANSFER)
  cboXfer.AddItem "None"
  cboXfer.AddItem "Kermit"
  cboXfer.AddItem "Xmodem"
  cboXfer.AddItem "Xmodem 1K"
  cboXfer.AddItem "Ymodem (Batch)"
  cboXfer.AddItem "Ymodem-G"
  cboXfer.AddItem "Zmodem"
  
  For i = 0 To cboXfer.ListCount - 1
    If sXfer = UCase(cboXfer.List(i)) Then Exit For
  Next
  If i = cboXfer.ListCount Then i = 0
  cboXfer.ListIndex = i
 
  'Initialize the Host information
  txtAppl.Text = A2BGetParm(ghSWA2VB, A2VB_APPLICATION)

  txtUserid = A2BGetParm(ghSWA2VB, Clogonuserid)
  sPassword = A2BGetParm(ghSWA2VB, Clogonpassword)
  txtPassword = ""

End Sub

Sub optTTY_Click ()
  Dim iRc As Integer
  
  'Set the button caption
  btnOptions.Caption = "TTY Options"
  sTermType = "TTY"
  iRc = A2BSetParm(ghSWA2VB, A2VB_EMULATION, sTermType)
End Sub

Sub optVT100_Click ()
  Dim iRc As Integer
  
  'Set the button caption
  btnOptions.Caption = "VT100 Options"
  sTermType = "VT100"
  iRc = A2BSetParm(ghSWA2VB, A2VB_EMULATION, sTermType)
End Sub

Sub optVT220_Click ()
  Dim iRc As Integer
  
  'Set the button caption
  btnOptions.Caption = "VT220 Options"
  sTermType = "VT220"
  iRc = A2BSetParm(ghSWA2VB, A2VB_EMULATION, sTermType)
End Sub

Sub txtName_Change ()
  'Don't allow user to press OK with a null string in the name field.
  If txtName.Text = "" Then
    btnOK.Enabled = False
  Else
    btnOK.Enabled = True
 End If
End Sub

