VERSION 2.00
Begin Form SessSLIP 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Remote TCP/IP Access Configuration (sesslip.frm)"
   ClientHeight    =   4530
   ClientLeft      =   2385
   ClientTop       =   6090
   ClientWidth     =   7365
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   4935
   Left            =   2325
   LinkTopic       =   "Form6"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4530
   ScaleWidth      =   7365
   Top             =   5745
   Width           =   7485
   Begin CommonDialog CMDialog1 
      Left            =   6690
      Top             =   1515
   End
   Begin CommandButton Command1 
      Caption         =   "&SLIP/PPP Settings..."
      Height          =   495
      Left            =   540
      TabIndex        =   14
      Top             =   1065
      Width           =   2115
   End
   Begin Frame frmAppl 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Application Selection"
      ClipControls    =   0   'False
      Height          =   810
      Left            =   540
      TabIndex        =   11
      Top             =   3510
      Width           =   5400
      Begin ComboBox cboAppl 
         Height          =   300
         Left            =   1305
         Style           =   2  'Dropdown List
         TabIndex        =   10
         Top             =   360
         Width           =   2000
      End
      Begin CommandButton btnAppl 
         Caption         =   "&Select..."
         Height          =   300
         Left            =   3500
         TabIndex        =   13
         Top             =   360
         Width           =   1560
      End
      Begin Label lblAppl 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Application"
         Height          =   225
         Left            =   180
         TabIndex        =   12
         Top             =   405
         Width           =   1125
      End
   End
   Begin Frame frm 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Terminal Type"
      ClipControls    =   0   'False
      Height          =   1410
      Left            =   525
      TabIndex        =   3
      Top             =   1815
      Width           =   5430
      Begin CommandButton btnOptions 
         Caption         =   "type &Options"
         Height          =   495
         Left            =   1710
         TabIndex        =   16
         Top             =   600
         Width           =   1560
      End
      Begin OptionButton optTTY 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&TTY"
         Height          =   315
         Left            =   165
         TabIndex        =   6
         Top             =   345
         Value           =   -1  'True
         Width           =   855
      End
      Begin OptionButton optVT100 
         BackColor       =   &H00C0C0C0&
         Caption         =   "VT&100"
         Height          =   330
         Left            =   150
         TabIndex        =   5
         Top             =   675
         Width           =   960
      End
      Begin OptionButton optVT220 
         BackColor       =   &H00C0C0C0&
         Caption         =   "VT&220"
         Height          =   270
         Left            =   165
         TabIndex        =   4
         Top             =   1080
         Width           =   975
      End
      Begin Label lblOptions 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Terminal Type Specific Options"
         Height          =   495
         Left            =   3465
         TabIndex        =   7
         Top             =   645
         Width           =   1560
      End
   End
   Begin TextBox txtName 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   2730
      MaxLength       =   8
      TabIndex        =   2
      Text            =   "VBSLIP"
      Top             =   435
      Width           =   1215
   End
   Begin CommandButton btnOK 
      Caption         =   "OK"
      Height          =   495
      Left            =   6000
      TabIndex        =   1
      Top             =   300
      Width           =   1215
   End
   Begin CommandButton btnCancel 
      Caption         =   "Cancel"
      Height          =   495
      Left            =   6015
      TabIndex        =   0
      Top             =   885
      Width           =   1215
   End
   Begin Label lblSLIP 
      BackColor       =   &H00C0C0C0&
      Caption         =   "SLIP or PPP, Service Name, Userid/Password"
      Height          =   405
      Left            =   2910
      TabIndex        =   15
      Top             =   1095
      Width           =   2655
   End
   Begin Label lblNameDesc 
      BackColor       =   &H00C0C0C0&
      Caption         =   "(1-8 Characters)"
      Height          =   240
      Left            =   4000
      TabIndex        =   9
      Top             =   480
      Width           =   1590
   End
   Begin Label lblName 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Connection Profile &Name"
      Height          =   285
      Left            =   555
      TabIndex        =   8
      Top             =   480
      Width           =   2145
   End
End
Option Explicit

Dim sTermType As String
Dim sTermTypeOrig As String
Dim sApplName As String

Sub btnAppl_Click ()
  Select Case cboAppl.Text
    Case "A2B Session"
      ' Select the session document
      CMDialog1.Filter = "All files (*.*)|*.*|Session Documents (*.WSD)|*.WSD"
      CMDialog1.FilterIndex = 2
      CMDialog1.InitDir = ghSWA2VB.DataPath
    Case "Advantage Program"
      ' Select the session document
      CMDialog1.Filter = "All files (*.*)|*.*|Advantage Programs (*.SRX)|*.SRX"
      CMDialog1.FilterIndex = 2
      CMDialog1.InitDir = ghSWA2VB.DataPath
    Case Else
      ' Select the session document
      CMDialog1.Filter = "All Applications (*.EXE)|*.EXE"
      CMDialog1.FilterIndex = 1
  End Select

  On Error GoTo CancelPressed
  CMDialog1.Action = 1
  
  sApplName = CMDialog1.Filename

CancelPressed:
  Exit Sub

End Sub

Sub btnCancel_Click ()
  giSessType = gSESSCANCEL
  Unload Me
End Sub

Sub btnOK_Click ()
  Dim iRc As Integer
  Dim sAppl As String
  Dim sPath As String
  Dim sServer As String
  Dim sMsg As String

  'check for second time thru
  If giConfigNameSet = False Then
    'Ensure a value is in the config name field.
    If txtName.Text = "" Then
      txtName.SetFocus
      Exit Sub
    End If
    
    'Ensure that the selected Configuration Name doesn't already exist.
    On Error Resume Next
    sPath = ghSWA2VB.DataPath
    sPath = sPath & "\" & txtName.Text & ".wsd"
    Open sPath For Input As #1
    
    If Err = 0 Then
      Close #1
      sMsg = "The " & txtName.Text & " profile name already exists.  Do you want to overwrite it?"
      iRc = MsgBox(sMsg, MB_YESNO, "Profile Exists")
      If iRc = IDNO Then
        txtName.SetFocus
        Exit Sub
      End If
    Else
      If Err <> 53 Then
        sMsg = "File Open Error: " & Err
        MsgBox sMsg, MB_OK
        txtName.SetFocus
        Exit Sub
      End If
    End If
  
    'Don't allow user to modify session from here on.
    giConfigNameSet = True
    gsProfileName = txtName.Text
  
    'Set the A2B Session name to the Configuration Name.
    ghSWA2VB.Session = txtName.Text
  End If

  'Ensure we are beginning with a SLIP/PPP setup
  sServer = A2BGetParm(ghSWA2VB, A2VB_SERVER)
  If sServer <> "SLIP/PPP" Then
    iRc = A2BSetParm(ghSWA2VB, A2VB_SERVER, "SLIP/PPP")
  End If

  iRc = A2BSetParm(ghSWA2VB, A2VB_EMULATION, sTermType)
  
  sAppl = cboAppl.Text
  If sApplName = "" Then sAppl = "None"
  If sAppl <> "None" Then sAppl = "SLIP " & sAppl
  iRc = A2BSetParm(ghSWA2VB, Csetupslipapp, sAppl)
  
  If sAppl <> "None" Then
    Select Case sAppl
      Case "Local Application"
        iRc = A2BSetParm(ghSWA2VB, Csliplappsliplapp, sApplName)
      Case "A2B Session"
        iRc = A2BSetParm(ghSWA2VB, Cslipsessslipsess, sApplName)
      Case "Advantage Program"
        iRc = A2BSetParm(ghSWA2VB, Cslipaprgslipaprg, sApplName)
    End Select
  End If

  Unload Me
End Sub

Sub btnOptions_Click ()
  Dim iDlgID As Integer

  iDlgID = A2VB_DLG_SESSIONSETUP  'set default to main setup screen

  Select Case sTermType
    Case "TTY"
    iDlgID = A2VB_DLG_TTY

    Case "VT100"
    iDlgID = A2VB_DLG_VT100

    Case "VT220"
    iDlgID = A2VB_DLG_VT220
  End Select

  ghSWA2VB.Setup = iDlgID
End Sub

Sub cboAppl_Click ()
  If cboAppl.ListIndex = 0 Then
    btnAppl.Enabled = False
  Else
    btnAppl.Enabled = True
  End If
End Sub

Sub cboAppl_KeyUp (KeyCode As Integer, Shift As Integer)
  If cboAppl.ListIndex = 0 Then
    btnAppl.Enabled = False
  Else
    btnAppl.Enabled = True
  End If
End Sub

Sub Command1_Click ()
  ghSWA2VB.Setup = A2VB_DLG_SLIP
End Sub

Sub Form_Load ()
  Dim sAppl As String
  Dim i As Integer

  CentreForm Me

  'Disable the name field if it has already been set.
  If giConfigNameSet Then
    txtName.Text = gsProfileName
    txtName.Enabled = False
  Else
    txtName.Enabled = True
  End If

  'Initialize the Terminal Type and Options button caption
  sTermTypeOrig = A2BGetParm(ghSWA2VB, A2VB_EMULATION)
  Select Case sTermTypeOrig
    Case "TTY"
      optTTY.Value = True
      btnOptions.Caption = TTY_CAPTION
    Case "VT100"
      optVT100.Value = True
      btnOptions.Caption = VT100_CAPTION
    Case "VT220"
      optVT220.Value = True
      btnOptions.Caption = VT220_CAPTION
  End Select
  
  'Initialize the Netowrk Application list
  sAppl = A2BGetParm(ghSWA2VB, Csetupslipapp)
  cboAppl.Clear
  cboAppl.AddItem "None"
  cboAppl.AddItem "Local Application"
  cboAppl.AddItem "A2B Session"
  cboAppl.AddItem "Advantage Program"
  
  For i = 0 To cboAppl.ListCount - 1
    If sAppl = cboAppl.List(i) Then Exit For
  Next
  If i = cboAppl.ListCount Then i = 0
  cboAppl.ListIndex = i
 
  If i = 0 Then btnAppl.Enabled = False

End Sub

Sub optTTY_Click ()
  Dim iRc As Integer
  
  'Set the button caption
  btnOptions.Caption = "TTY Options"
  sTermType = "TTY"
  iRc = A2BSetParm(ghSWA2VB, A2VB_EMULATION, sTermType)
End Sub

Sub optVT100_Click ()
  Dim iRc As Integer
  
  'Set the button caption
  btnOptions.Caption = "VT100 Options"
  sTermType = "VT100"
  iRc = A2BSetParm(ghSWA2VB, A2VB_EMULATION, sTermType)
End Sub

Sub optVT220_Click ()
  Dim iRc As Integer
  
  'Set the button caption
  btnOptions.Caption = "VT220 Options"
  sTermType = "VT220"
  iRc = A2BSetParm(ghSWA2VB, A2VB_EMULATION, sTermType)
End Sub

Sub txtName_Change ()
  'Don't allow user to press OK with a null string in the name field.
  If txtName.Text = "" Then
    btnOK.Enabled = False
  Else
    btnOK.Enabled = True
 End If
End Sub

