VERSION 2.00
Begin Form SessRLA 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Remote LAN Access Configuration (sessrla.frm)"
   ClientHeight    =   2370
   ClientLeft      =   1425
   ClientTop       =   4260
   ClientWidth     =   7365
   Height          =   2775
   Left            =   1365
   LinkTopic       =   "Form7"
   ScaleHeight     =   2370
   ScaleWidth      =   7365
   Top             =   3915
   Width           =   7485
   Begin CommonDialog CMDialog1 
      Left            =   6705
      Top             =   1680
   End
   Begin CommandButton btnAppl 
      Caption         =   "&Select..."
      Height          =   300
      Left            =   3825
      TabIndex        =   10
      Top             =   1410
      Width           =   1560
   End
   Begin CommandButton btnGateway 
      Caption         =   "&Gateway..."
      Height          =   300
      Left            =   3825
      TabIndex        =   12
      Top             =   1785
      Width           =   1560
   End
   Begin ComboBox cboAppl 
      Height          =   300
      Left            =   1635
      Style           =   2  'Dropdown List
      TabIndex        =   9
      Top             =   1410
      Width           =   2000
   End
   Begin ComboBox cboNetwork 
      Height          =   300
      Left            =   1635
      Style           =   2  'Dropdown List
      TabIndex        =   6
      Top             =   1035
      Width           =   2000
   End
   Begin TextBox txtName 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   2700
      MaxLength       =   8
      TabIndex        =   3
      Text            =   "VBRLA"
      Top             =   345
      Width           =   1330
   End
   Begin CommandButton btnLogon 
      Caption         =   "&Logon..."
      Height          =   300
      Left            =   3825
      TabIndex        =   7
      Top             =   1035
      Width           =   1560
   End
   Begin CommandButton btnCancel 
      Caption         =   "Cancel"
      Height          =   495
      Left            =   5985
      TabIndex        =   1
      Top             =   840
      Width           =   1215
   End
   Begin CommandButton btnOK 
      Caption         =   "OK"
      Height          =   495
      Left            =   6000
      TabIndex        =   0
      Top             =   255
      Width           =   1215
   End
   Begin Label lblGateway 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Remote LAN Gateway settings."
      Height          =   210
      Left            =   495
      TabIndex        =   11
      Top             =   1860
      Width           =   2865
   End
   Begin Label lblAppl 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Application"
      Height          =   225
      Left            =   495
      TabIndex        =   8
      Top             =   1455
      Width           =   1125
   End
   Begin Label lblNetwork 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Net&work"
      Height          =   240
      Left            =   495
      TabIndex        =   5
      Top             =   1110
      Width           =   1125
   End
   Begin Label lblNameDesc 
      BackColor       =   &H00C0C0C0&
      Caption         =   "(1-8 Characters)"
      Height          =   240
      Left            =   4100
      TabIndex        =   4
      Top             =   390
      Width           =   1590
   End
   Begin Label lblName 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Connection Profile &Name"
      Height          =   285
      Left            =   495
      TabIndex        =   2
      Top             =   390
      Width           =   2220
   End
End
Option Explicit

Dim sApplName As String

Sub btnAppl_Click ()
  Select Case cboAppl.Text
    Case "A2B Session"
      ' Select the session document
      CMDialog1.Filter = "All files (*.*)|*.*|Session Documents (*.WSD)|*.WSD"
      CMDialog1.FilterIndex = 2
      CMDialog1.InitDir = ghSWA2VB.DataPath
    Case "Advantage Program"
      ' Select the session document
      CMDialog1.Filter = "All files (*.*)|*.*|Advantage Programs (*.SRX)|*.SRX"
      CMDialog1.FilterIndex = 2
      CMDialog1.InitDir = ghSWA2VB.DataPath
    Case Else
      ' Select the session document
      CMDialog1.Filter = "All Applications (*.EXE)|*.EXE"
      CMDialog1.FilterIndex = 1
  End Select

  On Error GoTo CancelPressed
  CMDialog1.Action = 1
  
  sApplName = CMDialog1.Filename

CancelPressed:
  Exit Sub
End Sub

Sub btnCancel_Click ()
  giSessType = gSESSCANCEL
  Unload Me
End Sub

Sub btnGateway_Click ()
  Dim iDlgID As Integer

  iDlgID = A2VB_DLG_REMOTESERVER
  ghSWA2VB.Setup = iDlgID
End Sub

Sub btnLogon_Click ()
  Dim iDlgID As Integer

  iDlgID = A2VB_DLG_REMOTENETWORK
  ghSWA2VB.Setup = iDlgID
End Sub

Sub btnOK_Click ()
  Dim iRc As Integer
  Dim sAppl As String
  Dim sServer As String
  Dim sNetwork As String
  Dim sPath As String
  Dim sMsg As String

  'check for second time thru
  If giConfigNameSet = False Then
    'Ensure a value is in the config name field.
    If txtName.Text = "" Then
      txtName.SetFocus
      Exit Sub
    End If
    
    'Ensure that the selected Configuration Name doesn't already exist.
    On Error Resume Next
    sPath = ghSWA2VB.DataPath
    sPath = sPath & "\" & txtName.Text & ".wsd"
    Open sPath For Input As #1
    
    If Err = 0 Then
      Close #1
      sMsg = "The " & txtName.Text & " profile name already exists.  Do you want to overwrite it?"
      iRc = MsgBox(sMsg, MB_YESNO, "Profile Exists")
      If iRc = IDNO Then
        txtName.SetFocus
        Exit Sub
      End If
    Else
      If Err <> 53 Then
        sMsg = "File Open Error: " & Err
        MsgBox sMsg, MB_OK
        txtName.SetFocus
        Exit Sub
      End If
    End If
  
    'Don't allow user to modify session from here on.
    giConfigNameSet = True
    gsProfileName = txtName.Text
  
    'Set the A2B Session name to the Configuration Name.
    ghSWA2VB.Session = txtName.Text
  End If

  sServer = A2BGetParm(ghSWA2VB, A2VB_SERVER)
  If sServer <> "A2B REMOTE LAN" Then
    iRc = A2BSetParm(ghSWA2VB, A2VB_SERVER, "A2B REMOTE LAN")
  End If

  sAppl = cboAppl.Text
  If sApplName = "" Then sAppl = "None"
  iRc = A2BSetParm(ghSWA2VB, Csetupnetapp, sAppl)
  
  If sAppl <> "None" Then
    Select Case sAppl
      Case "Local Application"
        iRc = A2BSetParm(ghSWA2VB, Clocalapplocalapp, sApplName)
      Case "LAN Application"
        iRc = A2BSetParm(ghSWA2VB, Clanapplanapp, sApplName)
      Case "A2B Session"
        iRc = A2BSetParm(ghSWA2VB, Ca2bsessa2bsess, sApplName)
      Case "Advantage Program"
        iRc = A2BSetParm(ghSWA2VB, Cadvprogadvprog, sApplName)
    End Select
  End If

  sNetwork = cboNetwork.Text
  iRc = A2BSetParm(ghSWA2VB, Csetupnetwork, sNetwork)
  
  Unload Me
End Sub

Sub cboAppl_Click ()
  If cboAppl.ListIndex = 0 Then
    btnAppl.Enabled = False
  Else
    btnAppl.Enabled = True
  End If
End Sub

Sub cboAppl_KeyUp (KeyCode As Integer, Shift As Integer)
  If cboAppl.ListIndex = 0 Then
    btnAppl.Enabled = False
  Else
    btnAppl.Enabled = True
  End If
End Sub

Sub Form_Load ()
  Dim sAppl As String
  Dim sNetwork As String
  Dim sServer As String
  Dim i As Integer
  Dim iRc As Integer

  CentreForm Me

  'Enusre we are starting in RLA mode
  sServer = A2BGetParm(ghSWA2VB, A2VB_SERVER)
  If sServer <> "A2B REMOTE LAN" Then
    iRc = A2BSetParm(ghSWA2VB, A2VB_SERVER, "A2B Remote LAN")
  End If
  
  'Disable the name field if it has already been set.
  If giConfigNameSet Then
    txtName.Text = gsProfileName
    txtName.Enabled = False
  Else
    txtName.Enabled = True
  End If

  'Initialize the Network Type
  sNetwork = A2BGetParm(ghSWA2VB, Csetupnetwork)
  cboNetwork.Clear
  cboNetwork.AddItem "Novell NetWare"
  cboNetwork.ListIndex = 0
  
  'Initialize the Netowrk Application list
  sAppl = A2BGetParm(ghSWA2VB, Csetupnetapp)
  cboAppl.Clear
  cboAppl.AddItem "None"
  cboAppl.AddItem "Local Application"
  cboAppl.AddItem "LAN Application"
  cboAppl.AddItem "A2B Session"
  cboAppl.AddItem "Advantage Program"
  
  For i = 0 To cboAppl.ListCount - 1
    If sAppl = cboAppl.List(i) Then Exit For
  Next
  If i = cboAppl.ListCount Then i = 0
  cboAppl.ListIndex = i
 
  If i = 0 Then btnAppl.Enabled = False
End Sub

