VERSION 2.00
Begin Form Sess3270 
   BackColor       =   &H00C0C0C0&
   Caption         =   "3270 / 3287 Configuration (sess3270.frm)"
   ClientHeight    =   4110
   ClientLeft      =   690
   ClientTop       =   2745
   ClientWidth     =   7365
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   4515
   Left            =   630
   LinkTopic       =   "Form4"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4110
   ScaleWidth      =   7365
   Top             =   2400
   Width           =   7485
   Begin Frame frmHost 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Host Information"
      Height          =   1815
      Left            =   390
      TabIndex        =   13
      Top             =   2025
      Width           =   5085
      Begin TextBox txtUserid 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   2640
         MaxLength       =   8
         TabIndex        =   17
         Text            =   "txtUseri"
         Top             =   690
         Width           =   1620
      End
      Begin TextBox txtPassword 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   2640
         MaxLength       =   8
         TabIndex        =   19
         Text            =   "txtpassw"
         Top             =   1020
         Width           =   1620
      End
      Begin ComboBox cboAppl 
         BackColor       =   &H00FFFFFF&
         Height          =   300
         Left            =   2640
         TabIndex        =   15
         Text            =   "cboAppl"
         Top             =   345
         Width           =   1620
      End
      Begin ComboBox cboXfer 
         Height          =   300
         Left            =   2640
         Style           =   2  'Dropdown List
         TabIndex        =   21
         Top             =   1350
         Width           =   1620
      End
      Begin Label lblAppl 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Host &Application Name"
         Height          =   240
         Left            =   420
         TabIndex        =   14
         Top             =   420
         Width           =   2055
      End
      Begin Label lblUserid 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Userid for Application"
         Height          =   225
         Left            =   405
         TabIndex        =   16
         Top             =   750
         Width           =   1905
      End
      Begin Label lblPassword 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Pass&word "
         Height          =   225
         Left            =   405
         TabIndex        =   18
         Top             =   1065
         Width           =   1785
      End
      Begin Label lblXfer 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&File Transfer"
         Height          =   240
         Left            =   405
         TabIndex        =   20
         Top             =   1380
         Width           =   1125
      End
   End
   Begin Frame frmTerminal 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Terminal Settings"
      Height          =   1020
      Left            =   2760
      TabIndex        =   8
      Top             =   765
      Width           =   2700
      Begin ComboBox cboMode 
         Height          =   300
         Left            =   870
         Style           =   2  'Dropdown List
         TabIndex        =   10
         Top             =   285
         Width           =   1620
      End
      Begin ComboBox cboModel 
         Height          =   300
         Left            =   870
         Style           =   2  'Dropdown List
         TabIndex        =   12
         Top             =   615
         Width           =   1620
      End
      Begin Label lblMode 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Mode"
         Height          =   255
         Left            =   240
         TabIndex        =   9
         Top             =   345
         Width           =   570
      End
      Begin Label lblModel 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Mode&l"
         Height          =   225
         Left            =   210
         TabIndex        =   11
         Top             =   690
         Width           =   615
      End
   End
   Begin Frame frm 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Terminal/Printer"
      ClipControls    =   0   'False
      Height          =   1020
      Left            =   390
      TabIndex        =   5
      Top             =   765
      Width           =   2025
      Begin OptionButton opt3270 
         BackColor       =   &H00C0C0C0&
         Caption         =   "3270 &Terminal"
         Height          =   315
         Left            =   150
         TabIndex        =   6
         Top             =   360
         Value           =   -1  'True
         Width           =   1605
      End
      Begin OptionButton opt3287 
         BackColor       =   &H00C0C0C0&
         Caption         =   "3287 &Printer"
         Height          =   330
         Left            =   150
         TabIndex        =   7
         Top             =   660
         Width           =   1530
      End
   End
   Begin TextBox txtName 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   2600
      MaxLength       =   8
      TabIndex        =   3
      Text            =   "VB3270"
      Top             =   270
      Width           =   1215
   End
   Begin CommandButton btnOK 
      Caption         =   "OK"
      Height          =   495
      Left            =   6015
      TabIndex        =   0
      Top             =   150
      Width           =   1215
   End
   Begin CommandButton btnCancel 
      Caption         =   "Cancel"
      Height          =   495
      Left            =   6015
      TabIndex        =   1
      Top             =   720
      Width           =   1215
   End
   Begin Label lblNameDesc 
      BackColor       =   &H00C0C0C0&
      Caption         =   "(1-8 Characters)"
      Height          =   240
      Left            =   4000
      TabIndex        =   4
      Top             =   315
      Width           =   1590
   End
   Begin Label lblName 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Connection Profile &Name"
      Height          =   285
      Left            =   405
      TabIndex        =   2
      Top             =   315
      Width           =   2200
   End
End
Option Explicit

Sub btnCancel_Click ()
  giSessType = gSESSCANCEL
  Unload Me
End Sub

Sub btnOK_Click ()
  Dim iRc As Integer
  Dim sEmul As String
  Dim sXfer As String
  Dim sAppl As String
  Dim sUserid As String
  Dim sPassword As String
  Dim sPath As String
  Dim sMsg As String

  'check for second time thru
  If giConfigNameSet = False Then
    'Ensure a value is in the config name field.
    If txtName.Text = "" Then
      txtName.SetFocus
      Exit Sub
    End If
    
    'Ensure that the selected Configuration Name doesn't already exist.
    On Error Resume Next
    sPath = ghSWA2VB.DataPath
    sPath = sPath & "\" & txtName.Text & ".wsd"
    Open sPath For Input As #1
    
    If Err = 0 Then
      Close #1
      sMsg = "The " & txtName.Text & " profile name already exists.  Do you want to overwrite it?"
      iRc = MsgBox(sMsg, MB_YESNO, "Profile Exists")
      If iRc = IDNO Then
        txtName.SetFocus
        Exit Sub
      End If
    Else
      If Err <> 53 Then
        sMsg = "File Open Error: " & Err
        MsgBox sMsg, MB_OK
        txtName.SetFocus
        Exit Sub
      End If
    End If
  
    'Don't allow user to modify session from here on.
    giConfigNameSet = True
    gsProfileName = txtName.Text

    'Set the A2B Session name to the Configuration Name.
    ghSWA2VB.Session = txtName.Text
    
    'Set the server to "A2B MVS Server" so that new 3270 settings
    'will not be rejected.
    iRc = A2BSetParm(ghSWA2VB, A2VB_SERVER, "A2B MVS Server")

  End If

  If opt3287.Value = True Then  'it a printer
    iRc = A2BSetParm(ghSWA2VB, A2VB_EMULATION, "3287")
  Else 'its a terminal
    sEmul = cboMode.Text & " Model " & cboModel.Text
    iRc = A2BSetParm(ghSWA2VB, A2VB_EMULATION, sEmul)
    
    sXfer = cboXfer.Text
    iRc = A2BSetParm(ghSWA2VB, A2VB_TRANSFER, sXfer)
    
    sAppl = cboAppl.Text
    iRc = A2BSetParm(ghSWA2VB, A2VB_APPLICATION, sAppl)
    
    sUserid = txtUserid.Text
    iRc = A2BSetParm(ghSWA2VB, Clogonuserid, sUserid)
    
    sPassword = txtPassword.Text
    iRc = A2BSetParm(ghSWA2VB, Clogonpassword, sPassword)
  End If

  Unload Me
End Sub

Sub Command1_Click ()
  Unload Me
End Sub

Sub Form_Load ()
  Dim sXfer As String
  Dim sEmul As String
  Dim sPassword As String
  Dim iModel As Integer
  Dim i As Integer

  CentreForm Me

  iModel = 2
  'Disable the name field if it has already been set.
  If giConfigNameSet Then
    txtName.Text = gsProfileName
    txtName.Enabled = False
  Else
    txtName.Enabled = True
  End If

  'Initialize the Mode, Model and File Transfer combo boxes
  cboMode.AddItem "3278"
  cboMode.AddItem "3279"
  sEmul = A2BGetParm(ghSWA2VB, A2VB_EMULATION)
  i = InStr(sEmul, "3287")
  If i Then
    opt3287.Value = True
    cboMode.ListIndex = 0
  Else
    opt3270.Value = True
    iModel = Val(Mid$(sEmul, Len(sEmul), 1))  'get model # as integer
    If iModel = 0 Then iModel = 2

    i = InStr(sEmul, "3278")
    If i Then
      cboMode.ListIndex = 0
    Else
      cboMode.ListIndex = 1
    End If
  End If
  
  cboModel.AddItem "2"
  cboModel.AddItem "3"
  cboModel.AddItem "4"
  cboModel.AddItem "5"
  cboModel.ListIndex = iModel - 2

  sXfer = A2BGetParm(ghSWA2VB, A2VB_TRANSFER)
  cboXfer.AddItem "None"
  cboXfer.AddItem "Ind$File CICS"
  cboXfer.AddItem "Ind$File CMS"
  cboXfer.AddItem "Ind$File TSO"
  cboXfer.AddItem "SimXfer CICS"
  cboXfer.AddItem "SimXfer CMS"
  cboXfer.AddItem "SimXfer TSO"
  cboXfer.AddItem "SimXfer VTAM"
  
  For i = 0 To cboXfer.ListCount - 1
    If sXfer = UCase(cboXfer.List(i)) Then Exit For
  Next
  If i = cboXfer.ListCount Then i = 0
  cboXfer.ListIndex = i
 
  cboAppl.Text = A2BGetParm(ghSWA2VB, A2VB_APPLICATION)
  cboAppl.AddItem "CICS"
  cboAppl.AddItem "IMS"
  cboAppl.AddItem "TSO"
  cboAppl.AddItem "VM"

  txtUserid = A2BGetParm(ghSWA2VB, Clogonuserid)
  sPassword = A2BGetParm(ghSWA2VB, Clogonpassword)
  txtPassword = ""

  If opt3287.Value = True Then
    SetForPrinter
  Else
    SetForTerminal
  End If
End Sub

Sub opt3270_Click ()
  SetForTerminal
End Sub

Sub opt3287_Click ()
  SetForPrinter
End Sub

Sub SetForPrinter ()
  'Grey the labels and disable the Mode, Model and File Transfer combo boxes
  frmTerminal.Enabled = False
  lblMode.Enabled = False
  cboMode.Enabled = False
  cboMode.FontBold = False
  
  lblModel.Enabled = False
  cboModel.Enabled = False
  cboModel.FontBold = False
  
  frmHost.Enabled = False
  lblAppl.Enabled = False
  cboAppl.Enabled = False
  cboAppl.FontBold = False
  
  lblUserid.Enabled = False
  txtUserid.Enabled = False
  txtUserid.FontBold = False
  
  lblPassword.Enabled = False
  txtPassword.Enabled = False
  txtPassword.FontBold = False
  
  lblXfer.Enabled = False
  cboXfer.Enabled = False
  cboXfer.FontBold = False
End Sub

Sub SetForTerminal ()
  'Enable the Mode, Model and File Transfer combo boxes
  frmTerminal.Enabled = True
  lblMode.Enabled = True
  cboMode.Enabled = True
  cboMode.FontBold = True
  
  lblModel.Enabled = True
  cboModel.Enabled = True
  cboModel.FontBold = True
  
  frmHost.Enabled = True
  lblAppl.Enabled = True
  cboAppl.Enabled = True
  cboAppl.FontBold = True
  
  lblUserid.Enabled = True
  txtUserid.Enabled = True
  txtUserid.FontBold = True
  
  lblPassword.Enabled = True
  txtPassword.Enabled = True
  txtPassword.FontBold = True
  
  lblXfer.Enabled = True
  cboXfer.Enabled = True
  cboXfer.FontBold = True
End Sub

Sub txtName_Change ()
  'Don't allow user to press OK with a null string in the name field.
  If txtName.Text = "" Then
    btnOK.Enabled = False
  Else
    btnOK.Enabled = True
 End If
End Sub

