VERSION 2.00
Begin Form MainApp 
   BackColor       =   &H00FFFFFF&
   Caption         =   "Simware's A2B for Visual Basic Demo (mainapp.frm)"
   ClientHeight    =   6525
   ClientLeft      =   855
   ClientTop       =   2580
   ClientWidth     =   7365
   Height          =   7215
   Left            =   795
   LinkTopic       =   "Form1"
   ScaleHeight     =   6525
   ScaleWidth      =   7365
   Top             =   1950
   Width           =   7485
   Begin CommandButton btnModify 
      Caption         =   "&Modify Connection"
      Height          =   495
      Left            =   525
      TabIndex        =   7
      Top             =   4845
      Visible         =   0   'False
      Width           =   2385
   End
   Begin CommandButton btnControls 
      Caption         =   "&Other A2B Controls"
      Height          =   495
      Left            =   510
      TabIndex        =   6
      Top             =   4215
      Visible         =   0   'False
      Width           =   2385
   End
   Begin CommandButton btnPrograms 
      Caption         =   "A2B &Programs"
      Height          =   495
      Left            =   510
      TabIndex        =   5
      Top             =   3570
      Visible         =   0   'False
      Width           =   2385
   End
   Begin CommandButton btnTransfer 
      Caption         =   "File &Transfer"
      Height          =   495
      Left            =   495
      TabIndex        =   4
      Top             =   2925
      Visible         =   0   'False
      Width           =   2385
   End
   Begin CommandButton btnEmulation 
      Caption         =   "&Emulation Access"
      Height          =   495
      Left            =   510
      TabIndex        =   3
      Top             =   2295
      Visible         =   0   'False
      Width           =   2385
   End
   Begin CommandButton btnConnect 
      Caption         =   "&Connect/Disconnect"
      Height          =   495
      Left            =   510
      TabIndex        =   2
      Top             =   1635
      Visible         =   0   'False
      Width           =   2385
   End
   Begin CommonDialog CMDialog1 
      CancelError     =   -1  'True
      Left            =   6795
      Top             =   45
   End
   Begin Label lblStatus 
      BackColor       =   &H00C0C0C0&
      Caption         =   "lblStatus"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   4065
      TabIndex        =   19
      Top             =   975
      Visible         =   0   'False
      Width           =   1545
   End
   Begin Label lblStatusTitle 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Status:"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   3210
      TabIndex        =   18
      Top             =   960
      Visible         =   0   'False
      Width           =   780
   End
   Begin Label lblModify 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Invoke the Connection Profile setup dialogs."
      Height          =   255
      Left            =   3090
      TabIndex        =   17
      Top             =   5010
      Visible         =   0   'False
      Width           =   4005
   End
   Begin Label lblControls 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Demo the EditText, LabelText, PressKey, ProgramRun and FileTransfer Controls."
      Height          =   435
      Left            =   3090
      TabIndex        =   16
      Top             =   4275
      Visible         =   0   'False
      Width           =   4005
   End
   Begin Label lblPrograms 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Run A2B Rexx Programs."
      Height          =   255
      Left            =   3090
      TabIndex        =   15
      Top             =   3720
      Visible         =   0   'False
      Width           =   4005
   End
   Begin Label lblTransfer 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Perform FileTransfer examples."
      Height          =   255
      Left            =   3090
      TabIndex        =   14
      Top             =   3090
      Visible         =   0   'False
      Width           =   4005
   End
   Begin Label lblEmulation 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Perform Emulation Screen examples."
      Height          =   255
      Left            =   3090
      TabIndex        =   13
      Top             =   2450
      Visible         =   0   'False
      Width           =   4005
   End
   Begin Label lblConnect 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Connect or Disconnect the A2B Profile."
      Height          =   255
      Left            =   3090
      TabIndex        =   12
      Top             =   1800
      Visible         =   0   'False
      Width           =   4005
   End
   Begin Label lblType 
      BackColor       =   &H00C0C0C0&
      Caption         =   "lblType"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   4065
      TabIndex        =   11
      Top             =   690
      Visible         =   0   'False
      Width           =   2715
   End
   Begin Label lblName 
      BackColor       =   &H00C0C0C0&
      Caption         =   "lblName"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Left            =   4065
      TabIndex        =   10
      Top             =   315
      Visible         =   0   'False
      Width           =   1500
   End
   Begin Label lblTypeTitle 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Connection Type:"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   2100
      TabIndex        =   9
      Top             =   690
      Visible         =   0   'False
      Width           =   1875
   End
   Begin Label lblTitle 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Connection Profile Name:"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Left            =   885
      TabIndex        =   8
      Top             =   315
      Visible         =   0   'False
      Width           =   3105
   End
   Begin Label lblOpen 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Use File Open to access a previously defined connection profile."
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   825
      Left            =   1125
      TabIndex        =   1
      Top             =   2325
      Width           =   4695
   End
   Begin Label lblNew 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Use File New to create and configure a new connection profile."
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   750
      Left            =   1125
      TabIndex        =   0
      Top             =   1200
      Width           =   4245
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFileNew 
         Caption         =   "&New"
      End
      Begin Menu mnuFileOpen 
         Caption         =   "&Open..."
      End
      Begin Menu mnuFileClose 
         Caption         =   "&Close"
         Enabled         =   0   'False
      End
      Begin Menu mnuFileSep1 
         Caption         =   "-"
      End
      Begin Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuOptions 
      Caption         =   "&Options"
      Begin Menu mnuOptionsA2B 
         Caption         =   "&A2B Visible"
         Checked         =   -1  'True
      End
      Begin Menu mnuOptionsAutoClose 
         Caption         =   "Auto&Close"
         Checked         =   -1  'True
      End
   End
   Begin Menu mnuHelp 
      Caption         =   "&Help"
      Begin Menu mnuHelpAbout 
         Caption         =   "&About"
      End
      Begin Menu mnuHelpSWA2VB 
         Caption         =   "&SWA2VB Help"
      End
      Begin Menu mnuHelpEmul 
         Caption         =   "&Emulation over RLA or SLIP/PPP"
      End
   End
End
Option Explicit

Sub btnConnect_Click ()
  connect.Show 1
  EnableButtons
End Sub

Sub btnControls_Click ()
  a2bcntls.Show 1
  EnableButtons
End Sub

Sub btnEmulation_Click ()
  emulate.Show 1
  EnableButtons
End Sub

Sub btnModify_Click ()
  Dim iSessType As Integer

  'Remember the session type in case Cancel is pressed
  iSessType = giSessType

  'Don't automatically walk thru each configuration form.
  giAutoNav = False
  giConfigNameSet = True

  Select Case giSessType
    Case gSESS3270
      'Configure a 3270/3287 session.
      cfg3270.Show 1
    Case gSESSTTY
      'Configure a TTY/VT100/VT220 session.
      cfgtty.Show 1
    Case gSESSSLIP
      'Configure a remote TCP/IP (SLIP or PPP) connection.
      cfgslip.Show 1
    Case gSESSRLA
      'Configure a Remote LAN Access connection.
      cfgrla.Show 1
    Case Else
      'ERROR!!!
      MsgBox "Unknown Session Type - Aborting Program", MB_OK
      End
  End Select
  
  'Restore the session type in case Cancel was pressed
  giSessType = iSessType
End Sub

Sub btnPrograms_Click ()
  programs.Show 1
  EnableButtons
End Sub

Sub btnTransfer_Click ()
  transfer.Show 1
  EnableButtons
End Sub

Sub DemoMode ()
  Dim sServer As String
  Dim sEmul As String
  Dim i As Integer

  'Enter Demo Mode, so adjust File menu commands
  '(New and Open get disabled and Close gets enabled),
  'make the 2 helper labels disappear, make the form gray
  'and make the demo buttons and their labels visible.
  'File Close undoes all this.

  mnuFileNew.Enabled = False
  mnuFileOpen.Enabled = False
  mnuFileClose.Enabled = True

  lblNew.Visible = False
  lblOpen.Visible = False

  Me.BackColor = &HC0C0C0
  lblTitle.Visible = True
  lblName.Visible = True
  lblName.Caption = gsProfileName
  
  lblTypeTitle.Visible = True
  lblType.Visible = True
  sServer = A2BGetParm(ghSWA2VB, A2VB_SERVER)
  Select Case sServer
    Case "A2B REMOTE LAN"
      giSessType = gSESSRLA
      SwitchToSess2
      lblType.Caption = "Remote LAN Access"
      btnEmulation.Enabled = False
      btnTransfer.Enabled = False
      btnControls.Enabled = False

    Case "SLIP/PPP"
      giSessType = gSESSSLIP
      SwitchToSess2
      lblType.Caption = "Remote TCP/IP Access"
      btnEmulation.Enabled = False
      btnTransfer.Enabled = False
      btnControls.Enabled = False

    Case Else
      EnableButtons

      sEmul = A2BGetParm(ghSWA2VB, A2VB_EMULATION)
      i = InStr(sEmul, "32")
      If i Then
        giSessType = gSESS3270
        lblType.Caption = "3270/3287 Emulation"
      Else
        giSessType = gSESSTTY
        lblType.Caption = "TTY/VTxxx Emulation"
      End If

  End Select

  lblStatusTitle.Visible = True
  lblStatus.Visible = True
  
  If ghSWA2VB.Connected Then
    lblStatus.Caption = "Connected"
  Else
    lblStatus.Caption = "Disconnected"
  End If

  btnConnect.Visible = True
  lblConnect.Visible = True

  btnEmulation.Visible = True
  lblEmulation.Visible = True

  btnTransfer.Visible = True
  lblTransfer.Visible = True

  btnPrograms.Visible = True
  lblPrograms.Visible = True

  btnControls.Visible = True
  lblControls.Visible = True

  btnModify.Visible = True
  lblModify.Visible = True
End Sub

Sub EnableButtons ()
  'Depending on connection state, enable/disable buttons
  btnControls.Enabled = True
  If ghSWA2VB.Connected Then
    lblStatus.Caption = "Connected"
    btnEmulation.Enabled = True
    btnTransfer.Enabled = True
    btnModify.Enabled = False
  Else
    lblStatus.Caption = "Disconnected"
    btnEmulation.Enabled = False
    btnTransfer.Enabled = False
    btnModify.Enabled = True
  End If
End Sub

Sub Form_Load ()
  'set the global var to be the emulation session (not slip/rla session)
  Set ghSWA2VB = main!A2VB1
  giSWA2VB = SESS_A2VB1
  
  If main!A2VB1.A2BVisible Then
    main!A2VB1.A2BVisible = True
    mnuOptionsA2B.Checked = True
  Else
    main!A2VB1.A2BVisible = False
    mnuOptionsA2B.Checked = False
  End If
End Sub

Sub mnuFileClose_Click ()
  Set ghSWA2VB = main!A2VB1
  giSWA2VB = SESS_A2VB1

  mnuFileNew.Enabled = True
  mnuFileOpen.Enabled = True
  mnuFileClose.Enabled = False

  lblNew.Visible = True
  lblOpen.Visible = True

  Me.BackColor = &HFFFFFF
  lblTitle.Visible = False
  lblName.Visible = False
  lblTypeTitle.Visible = False
  lblType.Visible = False
  lblStatusTitle.Visible = False
  lblStatus.Visible = False

  btnConnect.Visible = False
  lblConnect.Visible = False

  btnEmulation.Visible = False
  lblEmulation.Visible = False

  btnTransfer.Visible = False
  lblTransfer.Visible = False

  btnPrograms.Visible = False
  lblPrograms.Visible = False

  btnControls.Visible = False
  lblControls.Visible = False

  btnModify.Visible = False
  lblModify.Visible = False
End Sub

Sub mnuFileExit_Click ()
  'Close all sessions and shut down the demo app.
  CloseAllSessions
  End
End Sub

Sub mnuFileNew_Click ()
  Const MB_OK = 0

  'Let other forms know this is from File New
  giFileNew = True

  'Have user select the session type (Emulation, RLA, SLIP/PPP)
  SessType.Show 1

  'reset to the untitled session
  gsProfileName = ""
  giConfigNameSet = False
  'ghSWA2VB.Session = ""

  'Automatically walk thru each configuration form.
  giAutoNav = True

  Select Case giSessType
    Case gSESSCANCEL
      'Cancel was pressed, not an error, so just ignore for now.
    Case gSESS3270
      'Configure a 3270/3287 session.
      cfg3270.Show 1
    Case gSESSTTY
      'Configure a TTY/VT100/VT220 session.
      cfgtty.Show 1
    Case gSESSSLIP
      'Configure a remote TCP/IP (SLIP or PPP) connection.
      cfgslip.Show 1
    Case gSESSRLA
      'Configure a Remote LAN Access connection.
      cfgrla.Show 1
    Case Else
      'ERROR!!!
      MsgBox "Unknown Session Type - Aborting Program", MB_OK
      End
  End Select

  'Either Cancel was pressed or one of the 4 connections types has been configured.
  If giSessType Then
    DemoMode
  Else
    'Cancel was pressed somewhere along the line, so ignore this File New request.
  End If
End Sub

Sub mnuFileOpen_Click ()
  Dim i As Integer
  Dim iRc As Integer
  Dim sEmul As String
  Dim sServer As String
  Dim sDesiredSess As String
  Dim sCurrentSess As String
  
  'set the global var to be the emulation session (not slip/rla session)
  Set ghSWA2VB = main!A2VB1
  giSWA2VB = SESS_A2VB1
  gsPrevSess = ghSWA2VB.Session

  'Let other forms know this is not from File New
  giFileNew = False
  giAutoNav = False
  giConfigNameSet = False
  gsProfileName = ""

  ' Select the session document
  On Error GoTo CancelPressed
  CMDialog1.Filter = "All files (*.*)|*.*|Session Documents (*.WSD)|*.WSD"
  CMDialog1.FilterIndex = 2
  CMDialog1.InitDir = ghSWA2VB.DataPath
  CMDialog1.Action = 1
  
  gsProfileName = CMDialog1.Filetitle
  i = InStr(gsProfileName, ".")
  If i Then gsProfileName = Mid$(gsProfileName, 1, i - 1)

  sDesiredSess = UCase(gsProfileName)
  sCurrentSess = UCase(main!A2VB2.Session)
  If InStr(sCurrentSess, sDesiredSess) Then
    Set ghSWA2VB = main!A2VB2
    giSWA2VB = SESS_A2VB2
  End If

  ghSWA2VB.Session = CMDialog1.Filename
  giConfigNameSet = True
  
  DemoMode
  Exit Sub

CancelPressed:
  'User pressed cancel in common dialog box
  Exit Sub
End Sub

Sub mnuFileSave_Click ()
  Dim iRc As Integer

  'save the session doc settings permanently
  If gsProfileName <> "" Then
    iRc = ghSWA2VB.SessionSave
  End If
End Sub

Sub mnuHelpAbout_Click ()
  'Show the About box modally
  about.Show 1
End Sub

Sub mnuHelpEmul_Click ()
  EmulHelp.Show 1
End Sub

Sub mnuHelpSWA2VB_Click ()
  Dim sFile As String
  Dim i As Integer

  sFile = main!A2VB1.ExePath & "\VBTOOLS\SWA2VB.HLP"
  i = WinHelp(Me.hWnd, sFile, HELP_INDEX, 0&)

End Sub

Sub mnuOptionsA2B_Click ()
  If mnuOptionsA2B.Checked Then
    ghSWA2VB.A2BVisible = False
    mnuOptionsA2B.Checked = False
  Else
    ghSWA2VB.A2BVisible = True
    mnuOptionsA2B.Checked = True
  End If
End Sub

Sub mnuOptionsAutoClose_Click ()
  If mnuOptionsA2B.Checked Then
    ghSWA2VB.AutoClose = False
    main!A2VB2.AutoClose = False
    mnuOptionsAutoClose.Checked = False
  Else
    ghSWA2VB.AutoClose = True
    main!A2VB2.AutoClose = True
    mnuOptionsAutoClose.Checked = True
  End If

End Sub

Sub SwitchToSess2 ()
  Dim sSess As String
  
  If giSWA2VB = SESS_A2VB1 Then
    sSess = main!A2VB1.Session
    main!A2VB1.Session = gsPrevSess
    Set ghSWA2VB = main!A2VB2
    giSWA2VB = SESS_A2VB2
    ghSWA2VB.Session = sSess
  End If
End Sub

