VERSION 2.00
Begin Form ConnMeth 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Connection Method Configuration (connmeth.frm)"
   ClientHeight    =   4395
   ClientLeft      =   1125
   ClientTop       =   2880
   ClientWidth     =   7365
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   4800
   Left            =   1065
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4395
   ScaleWidth      =   7365
   Top             =   2535
   Width           =   7485
   Begin Frame frmOptions 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Options"
      Height          =   1500
      Left            =   165
      TabIndex        =   11
      Top             =   2670
      Width           =   7050
      Begin CommandButton btnOpt1 
         Caption         =   "A2B Setup Dialog"
         Height          =   465
         Left            =   1775
         TabIndex        =   9
         Top             =   800
         Width           =   2130
      End
      Begin ComboBox cboType 
         Height          =   300
         Left            =   1775
         Style           =   2  'Dropdown List
         TabIndex        =   8
         Top             =   255
         Width           =   2130
      End
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Invoke the A2B Setup Dialog for the specified Connection Type."
         Height          =   675
         Left            =   4140
         TabIndex        =   12
         Top             =   740
         Width           =   2610
      End
      Begin Label lblType 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Connection Type"
         Height          =   270
         Left            =   225
         TabIndex        =   7
         Top             =   315
         Width           =   1635
      End
   End
   Begin OptionButton optOther 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Other (3270 Boards or Adapters)"
      Height          =   300
      Left            =   255
      TabIndex        =   6
      Top             =   2040
      Width           =   3405
   End
   Begin OptionButton optTCPIP 
      BackColor       =   &H00C0C0C0&
      Caption         =   "TCP/IP (Telnet or TN3270)"
      Height          =   285
      Left            =   255
      TabIndex        =   5
      Top             =   1710
      Width           =   3015
   End
   Begin OptionButton optLAN 
      BackColor       =   &H00C0C0C0&
      Caption         =   "LAN Server/Gateway (Eicon, Netware SAA, NACS, Int14)"
      Height          =   315
      Left            =   255
      TabIndex        =   4
      Top             =   1350
      Width           =   5265
   End
   Begin OptionButton optSerial 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Serial Port (Comm 1-15)"
      Height          =   315
      Left            =   255
      TabIndex        =   3
      Top             =   975
      Value           =   -1  'True
      Width           =   2625
   End
   Begin Frame frmMethod 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Connection Method"
      Height          =   1665
      Left            =   165
      TabIndex        =   2
      Top             =   735
      Width           =   5700
   End
   Begin CommandButton btnOK 
      Caption         =   "OK"
      Height          =   495
      Left            =   6015
      TabIndex        =   0
      Top             =   150
      Width           =   1215
   End
   Begin CommandButton btnCancel 
      Caption         =   "Cancel"
      Height          =   495
      Left            =   6015
      TabIndex        =   1
      Top             =   735
      Width           =   1215
   End
   Begin Label lblInstruct 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Select the Connection Method for this session and then configure the Options for the selected method."
      Height          =   495
      Left            =   180
      TabIndex        =   10
      Top             =   210
      Width           =   5145
   End
End
Option Explicit

Sub btnCancel_Click ()
  giSessType = gSESSCANCEL
  Unload Me
End Sub

Sub btnOK_Click ()
  Dim iRc As Integer
  Dim sConn As String

  sConn = cboType.Text
  Select Case giSessType
    Case gSESS3270
      If sConn = NETWARESAA Then
        iRc = A2BSetParm(ghSWA2VB, A2VB_SERVER, sConn)
      Else
        iRc = A2BSetParm(ghSWA2VB, A2VB_SERVER, "None")
        iRc = A2BSetParm(ghSWA2VB, A2VB_CONNECTION, sConn)
      End If
    
    Case Else
      iRc = A2BSetParm(ghSWA2VB, A2VB_CONNECTION, sConn)
  End Select

  Unload Me
End Sub

Sub btnOpt1_Click ()
  Dim iDlgID As Integer

  iDlgID = A2VB_DLG_SESSIONSETUP  'set default to main setup screen

  Select Case cboType.Text
    Case DIALUP
    iDlgID = A2VB_DLG_ASYNCHRONOUSDIALUP

    Case DIALUPX25
    iDlgID = A2VB_DLG_DIALUPX25

    Case DIRECT
    iDlgID = A2VB_DLG_ASYNCHRONOUSDIRECT

    Case DIRECTX25
    iDlgID = A2VB_DLG_DIRECTX25

    Case TELNET
    iDlgID = A2VB_DLG_TELNET

    Case TN3270
    iDlgID = A2VB_DLG_TN3270

    Case EICONX25
    iDlgID = A2VB_DLG_EICONX25GATEWAY

    Case EICONXPAD
    iDlgID = A2VB_DLG_EICON

    Case UNGERMANNBASS
    iDlgID = A2VB_DLG_UNGERMANNBASS

    Case INT14
    iDlgID = A2VB_DLG_GENERICINT14

    Case NACSDIALUP
    iDlgID = A2VB_DLG_NACSDIALUPASYNC

    Case NACSDIALUPX25
    iDlgID = A2VB_DLG_NACSDIALUPX25

    Case NACSDIRECT
    iDlgID = A2VB_DLG_NACSDIRECTASYNC

    Case NACSDIRECTX25
    iDlgID = A2VB_DLG_NACSDIRECTX25

    Case NETWARESAA
    iDlgID = A2VB_DLG_SAASERVER

    Case IBM
    iDlgID = A2VB_DLG_IBM

    Case IRMA
    iDlgID = A2VB_DLG_IRMA

    Case XIRCOM
    iDlgID = A2VB_DLG_XIRCOM

  End Select

  ghSWA2VB.Setup = iDlgID
End Sub

Sub btnOpt2_Click ()
  ghSWA2VB.Setup = A2VB_DLG_MODEM
End Sub

Sub btnOpt3_Click ()
  ghSWA2VB.Setup = A2VB_DLG_DIALUPX25
End Sub

Sub Form_Load ()
  Dim i As Integer
  Dim sConn As String
  Dim sServer As String

  CentreForm Me

  'need to determine the current method
  sServer = A2BGetParm(ghSWA2VB, A2VB_SERVER)
  sConn = A2BGetParm(ghSWA2VB, A2VB_CONNECTION)

  'Do mode specific initializations
  Select Case giSessType
    Case gSESS3270
      If sServer = NETWARESAA Then
        optLAN.Value = True
        SetLAN sConn
        Exit Sub
      End If
    
    Case gSESSTTY
      optOther.Enabled = False
      optTCPIP.Enabled = True
    
    Case gSESSSLIP
      optLAN.Enabled = False
      optTCPIP.Enabled = False
      optOther.Enabled = False

      'RLA must be a Serial Port connection
      optSerial.Value = True
      SetSerial sConn
      Exit Sub
    
    Case gSESSRLA
      optLAN.Enabled = False
      optTCPIP.Enabled = False
      optOther.Enabled = False

      'RLA must be a Serial Port connection
      optSerial.Value = True
      SetSerial sConn
      Exit Sub
  End Select
  
  If Mid$(sConn, 1, 2) = "DI" Then
    optSerial.Value = True
    SetSerial sConn
    Exit Sub
  End If

  If Mid$(sConn, 1, 1) = "T" Then
    optTCPIP.Value = True
    SetTCPIP sConn
    Exit Sub
  End If

  If giSessType = gSESS3270 Then
    i = InStr(sConn, " 3270")
    If i Then
      optOther.Value = True
      SetOther sConn
      Exit Sub
    End If
  End If

  optLAN.Value = True
  SetLAN sConn

End Sub

Sub optLAN_Click ()
  SetLAN ""
End Sub

Sub optOther_Click ()
  SetOther ""
End Sub

Sub optSerial_Click ()
  SetSerial ""
End Sub

Sub optTCPIP_Click ()
  SetTCPIP ""
End Sub

Sub SetLAN (sConn As String)
  Dim i As Integer
  
  cboType.Clear
  cboType.AddItem EICONX25
  cboType.AddItem EICONXPAD
  cboType.AddItem INT14
  cboType.AddItem NACSDIALUP
  cboType.AddItem NACSDIALUPX25
  cboType.AddItem NACSDIRECT
  cboType.AddItem NACSDIRECTX25
  If giSessType = gSESS3270 Then
    cboType.AddItem NETWARESAA
  End If
  cboType.AddItem UNGERMANNBASS
  
  For i = 0 To cboType.ListCount - 1
    If sConn = UCase(cboType.List(i)) Then Exit For
  Next
  If i = cboType.ListCount Then i = 0
  cboType.ListIndex = i
End Sub

Sub SetOther (sConn As String)
  Dim i As Integer

  cboType.Clear
  cboType.AddItem IBM
  cboType.AddItem IRMA
  cboType.AddItem XIRCOM
  
  For i = 0 To cboType.ListCount - 1
    If sConn = UCase(cboType.List(i)) Then Exit For
  Next
  If i = cboType.ListCount Then i = 0
  cboType.ListIndex = i
End Sub

Sub SetSerial (sConn As String)
  Dim i As Integer
  
  cboType.Clear
  cboType.AddItem DIALUP
  cboType.AddItem DIALUPX25
  If giSessType <> gSESSRLA Then
    cboType.AddItem DIRECT
  End If
  cboType.AddItem DIRECTX25
  
  For i = 0 To cboType.ListCount - 1
    If sConn = UCase(cboType.List(i)) Then Exit For
  Next
  If i = cboType.ListCount Then i = 0
  cboType.ListIndex = i
End Sub

Sub SetTCPIP (sConn As String)
  Dim i As Integer
  
  cboType.Clear
  cboType.AddItem TELNET
  If giSessType = gSESS3270 Then
    cboType.AddItem TN3270
  End If

  For i = 0 To cboType.ListCount - 1
    If sConn = UCase(cboType.List(i)) Then Exit For
  Next
  If i = cboType.ListCount Then i = 0
  cboType.ListIndex = i
End Sub

