VERSION 2.00
Begin Form Connect 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Connect or Disconnect an A2B Profile (connect.frm)"
   ClientHeight    =   7035
   ClientLeft      =   1125
   ClientTop       =   1560
   ClientWidth     =   7365
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   7440
   Left            =   1065
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7035
   ScaleWidth      =   7365
   Top             =   1215
   Width           =   7485
   Begin CommandButton btnStop 
      Caption         =   "Stop Connecting/Disconnecting"
      Enabled         =   0   'False
      Height          =   495
      Left            =   2130
      TabIndex        =   12
      Top             =   6345
      Width           =   3075
   End
   Begin ListBox lstSay 
      Height          =   2175
      Left            =   615
      TabIndex        =   11
      Top             =   3945
      Width           =   6120
   End
   Begin Frame frmSync 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Synchronous Mode"
      ClipControls    =   0   'False
      Height          =   1080
      Left            =   615
      TabIndex        =   7
      Top             =   1035
      Width           =   6120
      Begin OptionButton optSync 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Synchronous  - wait for connect/disconnect to complete."
         Height          =   345
         Left            =   150
         TabIndex        =   9
         Top             =   600
         Width           =   5805
      End
      Begin OptionButton optAsync 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Asynchronous - start connect/disconnect and resume VB code."
         Height          =   315
         Left            =   150
         TabIndex        =   8
         Top             =   285
         Value           =   -1  'True
         Width           =   5760
      End
   End
   Begin Frame frmDisconnect 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Disconnect from Host"
      ClipControls    =   0   'False
      Height          =   1560
      Left            =   3825
      TabIndex        =   4
      Top             =   2205
      Width           =   2910
      Begin CommandButton btnA2BDisconnect 
         Caption         =   "Logoff and Disconnect "
         Height          =   495
         Left            =   120
         TabIndex        =   6
         Top             =   345
         Width           =   2500
      End
      Begin CommandButton btnDisconnect 
         Caption         =   "Just Disconnect"
         Height          =   495
         Left            =   120
         TabIndex        =   5
         Top             =   915
         Width           =   2500
      End
   End
   Begin Frame frmConnect 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Connect to Host"
      ClipControls    =   0   'False
      Height          =   1560
      Left            =   615
      TabIndex        =   1
      Top             =   2205
      Width           =   2910
      Begin CommandButton btnConnect 
         Caption         =   "Just Connect"
         Height          =   495
         Left            =   120
         TabIndex        =   3
         Top             =   915
         Width           =   2500
      End
      Begin CommandButton btnA2BConnect 
         Caption         =   "Connect and Logon"
         Height          =   495
         Left            =   120
         TabIndex        =   2
         Top             =   345
         Width           =   2500
      End
   End
   Begin CommandButton btnCancel 
      Cancel          =   -1  'True
      Caption         =   "Done"
      Height          =   495
      Left            =   5970
      TabIndex        =   0
      Top             =   270
      Width           =   1215
   End
   Begin Label lblDesc 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Set Synchronous Mode and then press one of the Connect or Disconnect buttons."
      Height          =   495
      Left            =   705
      TabIndex        =   10
      Top             =   330
      Width           =   4935
   End
End
Option Explicit

Sub btnA2BConnect_Click ()
  Dim iRc As Integer

  lstSay.Clear
  btnA2BConnect.Enabled = False
  btnConnect.Enabled = False
  frmConnect.Enabled = False

  'Allow cancellation if this is an asynchronous connect.
  If optAsync.Value Then
    btnStop.Enabled = True
    ghSWA2VB.Wait = False
  Else
    ghSWA2VB.Wait = True
  End If

  'Connect and run the A2B logon programs
  iRc = ghSWA2VB.A2BConnect

  'Update the button states if this was a synchronous connect
  If optSync.Value Then EnableButtons
End Sub

Sub btnA2BDisconnect_Click ()
  Dim iRc As Integer

  lstSay.Clear
  btnA2BDisconnect.Enabled = False
  btnDisconnect.Enabled = False
  frmDisconnect.Enabled = False

  'Allow cancellation if this is an asynchronous disconnect.
  If optAsync.Value Then
    btnStop.Enabled = True
    ghSWA2VB.Wait = False
  Else
    ghSWA2VB.Wait = True
  End If

  'Run the A2B logoff programs and disconnect.
  iRc = ghSWA2VB.A2BDisconnect

  'Update the button states if this was a synchronous disconnect
  If optSync.Value Then EnableButtons
End Sub

Sub btnCancel_Click ()
  Unload Me
End Sub

Sub btnConnect_Click ()
  Dim iRc As Integer

  lstSay.Clear
  btnA2BConnect.Enabled = False
  btnConnect.Enabled = False
  frmConnect.Enabled = False

  'Allow cancellation if this is an asynchronous connect.
  If optAsync.Value Then
    btnStop.Enabled = True
    ghSWA2VB.Wait = False
  Else
    ghSWA2VB.Wait = True
  End If

  'Just Connect the hardware (don't run the A2B logon programs).
  iRc = ghSWA2VB.Connect

  'Update the button states if this was a synchronous connect
  If optSync.Value Then EnableButtons
End Sub

Sub btnDisconnect_Click ()
  Dim iRc As Integer

  lstSay.Clear
  btnA2BDisconnect.Enabled = False
  btnDisconnect.Enabled = False
  frmDisconnect.Enabled = False

  'Allow cancellation if this is an asynchronous disconnect.
  If optAsync.Value Then
    btnStop.Enabled = True
    ghSWA2VB.Wait = False
  Else
    ghSWA2VB.Wait = True
  End If

  'Just Disconnect the hardware (don't run the A2B logoff programs).
  iRc = ghSWA2VB.Disconnect

  'Update the button states if this was a synchronous disconnect
  If optSync.Value Then EnableButtons
End Sub

Sub btnStop_Click ()
  Dim iRc As Integer

  'Stop the running program that is connecting or disconnecting.
  iRc = ghSWA2VB.ProgramCancel
  EnableButtons
End Sub

Sub Command1_Click ()
  Unload Me
End Sub

Sub EnableButtons ()
  If ghSWA2VB.Connected Then
    frmConnect.Enabled = False
    btnA2BConnect.Enabled = False
    btnConnect.Enabled = False
    frmDisconnect.Enabled = True
    btnA2BDisconnect.Enabled = True
    btnDisconnect.Enabled = True
  Else
    frmConnect.Enabled = True
    btnA2BConnect.Enabled = True
    btnConnect.Enabled = True
    frmDisconnect.Enabled = False
    btnA2BDisconnect.Enabled = False
    btnDisconnect.Enabled = False
  End If
End Sub

Sub Form_Load ()
  CentreForm Me

  'Inform A2VB Say Event that Connect form is in displayed.
  giA2VBDemoState = gCONNECT
  
  'Determine connection state and enable the valid buttons.
  EnableButtons

  lstSay.Clear
End Sub

