VERSION 2.00
Begin Form Cfg3270 
   BackColor       =   &H00C0C0C0&
   Caption         =   "3270 / 3287 Session Configuration (cfg3270.frm)"
   ClientHeight    =   4200
   ClientLeft      =   1245
   ClientTop       =   2400
   ClientWidth     =   7365
   ClipControls    =   0   'False
   Height          =   4605
   Left            =   1185
   LinkTopic       =   "Form1"
   ScaleHeight     =   4200
   ScaleWidth      =   7365
   Top             =   2055
   Width           =   7485
   Begin CommandButton btnCancel 
      Caption         =   "Cancel"
      Height          =   495
      Left            =   6030
      TabIndex        =   5
      Top             =   780
      Width           =   1215
   End
   Begin CommandButton btnOK 
      Caption         =   "OK"
      Height          =   495
      Left            =   6030
      TabIndex        =   4
      Top             =   210
      Width           =   1215
   End
   Begin CommandButton btnAdv3270 
      Caption         =   "Advanced 3270 Settings..."
      Height          =   495
      Left            =   450
      TabIndex        =   3
      Top             =   3435
      Width           =   2520
   End
   Begin CommandButton btnProtocol 
      Caption         =   "Protocol Conversion..."
      Height          =   495
      Left            =   450
      TabIndex        =   2
      Top             =   2865
      Width           =   2520
   End
   Begin CommandButton btnConnection 
      Caption         =   "Connection Method..."
      Height          =   495
      Left            =   450
      TabIndex        =   1
      Top             =   2295
      Width           =   2520
   End
   Begin CommandButton btn3270 
      Caption         =   "3270 Settings && Host Info..."
      Height          =   495
      Left            =   450
      TabIndex        =   0
      Top             =   1725
      Width           =   2520
   End
   Begin Label lblHost 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Host Applid, Userid, File Transfer Type"
      Height          =   240
      Left            =   3135
      TabIndex        =   7
      Top             =   1980
      Width           =   3660
   End
   Begin Label lblDesc2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Protocol Conversion will only be available if the Connection Method indicates it will be necessary. "
      Height          =   480
      Left            =   450
      TabIndex        =   12
      Top             =   945
      Width           =   4770
   End
   Begin Label lblDesc 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Press the button(s) associated with the type of session configuration you want to perform or press OK to save the configuration."
      Height          =   600
      Left            =   450
      TabIndex        =   11
      Top             =   255
      Width           =   4770
   End
   Begin Label lblAdv3270 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Code Page, Character Set, Printer Settings"
      Height          =   240
      Left            =   3135
      TabIndex        =   10
      Top             =   3600
      Width           =   3660
   End
   Begin Label lblProtocol 
      BackColor       =   &H00C0C0C0&
      Caption         =   "A2B Server, Sim3278, Hardware Device"
      Height          =   240
      Left            =   3135
      TabIndex        =   9
      Top             =   3015
      Width           =   3660
   End
   Begin Label lblConnection 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Serial Port, LAN Service, TCP/IP, Board"
      Height          =   240
      Left            =   3135
      TabIndex        =   8
      Top             =   2430
      Width           =   3660
   End
   Begin Label lbl3270 
      BackColor       =   &H00C0C0C0&
      Caption         =   "3270 or 3287, Model 2-5, 3278 or 3279"
      Height          =   240
      Left            =   3135
      TabIndex        =   6
      Top             =   1755
      Width           =   3660
   End
End
Option Explicit

Sub btn3270_Click ()
  sess3270.Show 1
  If giConfigNameSet Then
    btnConnection.Enabled = True
    btnProtocol.Enabled = TestForProtConv()
    btnAdv3270.Enabled = True
  End If
  giSessType = gSESS3270
End Sub

Sub btnAdv3270_Click ()
  Dim sServer As String
  Dim i As Integer

  sServer = A2BGetParm(ghSWA2VB, A2VB_SERVER)
  i = InStr(sServer, "SAA")
  If i Then
    ghSWA2VB.Setup = A2VB_DLG_3270HSAA
  Else
    ghSWA2VB.Setup = A2VB_DLG_3270H
  End If
  giSessType = gSESS3270
End Sub

Sub btnCancel_Click ()
  giSessType = gSESSCANCEL
  Unload Me
End Sub

Sub btnConnection_Click ()
  connmeth.Show 1
  
  'Only enable the protocol conversion button if the connection method
  'says it is needed
  btnProtocol.Enabled = TestForProtConv()
  giSessType = gSESS3270
End Sub

Sub btnOK_Click ()
  Dim iRc As Integer

  'Save the changes to the session document
  iRc = ghSWA2VB.SessionSave

  Unload Me
End Sub

Sub btnProtocol_Click ()
  protconv.Show 1
  giSessType = gSESS3270
End Sub

Sub Form_Load ()
  CentreForm Me

  'set the global var to be the emulation session (not slip/rla session)
  Set ghSWA2VB = main!A2VB1
  giSWA2VB = SESS_A2VB1
  
  'Automatically show each configuration form if giAutoNav is set to true
  If giAutoNav Then
    sess3270.Show 1
    If giSessType <> gSESSCANCEL Then
      connmeth.Show 1
      giAutoNav = False
    End If
    giProtocolConv = TestForProtConv()
    If (giSessType <> gSESSCANCEL) And giProtocolConv Then
      protconv.Show 1
      giAutoNav = False
    End If
  End If
  
  'Ensure global session type is re-set if needed.
  giSessType = gSESS3270

  'Disable buttons if config name hasn't been set yet
  If giConfigNameSet = False Then
    btnConnection.Enabled = False
    btnProtocol.Enabled = False
    btnAdv3270.Enabled = False
  Else
    'Only enable the protocol conversion button if the connection method
    'says it is needed
    btnProtocol.Enabled = TestForProtConv()
  End If
End Sub

