#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <hllapi.h>

#define WINDOW_CLASS_NAME 	"A2B_BUTTONS_CLS"
#define WINDOW_NAME			"Buttons"
#define WINDOW_STYLE		WS_OVERLAPPEDWINDOW
#define NUMBER_OF_PFKEYS 	18
#define NUMBER_OF_BUTTONS 	20                  
#define FIRST_NON_PF_KEY 	18
#define TMR_REFRESH      	1
#define TMR_POLL         	2
#define POLL_INTERVAL    	500		/* milliseconds */
#define REFRESH_INTERVAL 	1000	/* milliseconds */

#define MAX(a, b) 			((a > b) ? a : b)
#define MIN(a, b) 			((a < b) ? a : b)

typedef struct pfkeys
{   
	HWND hWnd;
	char szMnemonic[8];
	char szLabel[133];
	void (*fnFunction)(HWND, struct pfkeys *);
} rPF_KEYS;

typedef rPF_KEYS arPF_KEYS[NUMBER_OF_BUTTONS];	
typedef VOID FAR PASCAL HLLAPI_FUNCTION(WORD FAR *, char FAR *, WORD FAR *, WORD FAR *);
typedef HLLAPI_FUNCTION FAR *HLLAPI_FUNCTION_PTR;

BOOL Initialize(HANDLE);
void FindPfKeys(arPF_KEYS *arPfKeys);
BOOL FindOVPfKeys(arPF_KEYS *arPfKeys);
void DrawButtons(HWND hWnd, arPF_KEYS *arPfKeys);
BOOL PressButton(HWND hWnd, rPF_KEYS *rPfKey);                
BOOL RefreshButtons(HWND hWnd, rPF_KEYS *rPfKey);
BOOL InitializeKeys(arPF_KEYS *arKeys);                

int  InitializeHllapi(void);     	/* Returns 0 or -HLLAPIRC */
int  CleanupHllapi(void);
int  SearchPS(char *sz, int offset);    /* Returns 0 or -HLLAPIRC */
int  CopyPsToString(char *sz, int length, int offset);
int  SendKey(char *sz);
BOOL IsXClock(void);
int  Wait(void);       

                                                              
                                                              
                                                              