ACTIVITY A    -    MORE ADVANCED EDITING

              /    Cursor Movement Commands
              /    Delete Commands
              /    The Restore Command
              /    Inserting New Lines


Cursor Movement Commands   The four arrow keys (|), (|), (->), and (<-)
move the cursor one space in the indicated direction. The following
commands may also be used to move the cursor. 
 
KEYS            EFFECT

End             Moves the cursor to the right end of the line 
Home            Moves the cursor to the beginning of the line 
Ctrl- ->        Moves the cursor one word to the right 
Ctrl- <-        Moves the cursor one word to the left 
Pgup            Moves the cursor up approximately one screen in
                the file
Pgdn            Moves the cursor down approximately one screen in
                the file 
Ctrl-Home       Moves the cursor to the top of the current screen
Ctrl-End        Moves the cursor to the bottom of the current
                screen
Ctrl-Pgup       Moves the cursor to the top of the whole file
Ctrl-Pgdn       Moves the cursor to the bottom of the whole file

 
DELETE COMMANDS:    The following commands may be used to delete single
characters, words or lines.

KEYS           EFFECT

Del            Erases the character at the cursor
Backspace(<-)  Erases the character to the left of the cursor
Ctrl-t         Deletes the word to the right
Ctrl-q y       Deletes all the words from the cursor location to the
               end of the line on which the cursor is  positioned  
Ctrl-y         Deletes the entire line on which the cursor is
               positioned

 
CAUTION    Continuous pressing of any one of the deleting key
combinations will keep deleting characters, words, or lines until
you release the keys. 

REMARK
a)   On some computer keyboards, Page Up is the Pgup key and PageDown
     is the Pgdn key.

b)   On some computer keyboards, <- is the Backspace key.

c)   There is an extra feature of the Backspace key. When there are
     blanks to the left of a line of text, the Backspace key can be
     used to control the left alignment. 
     For example, consider the program segment:

            for i := 1 to 10 do
               begin
                  sum := sum + i;
                  sumSq := sumSq + i*i
                        end;

     Obviously, the end statement is not properly aligned. To move the
     end statement to be aligned with the begin statement, first place
     the cursor at e of the word end. Each time you press the
     Backspace key once, the current line would be aligned with the
     next most previously statement. Therefore, when you press the
     Backspace key once, the end statement would be aligned with the
     statement sumSq := sumSq + i*i. When you press the Backspace key
     a second time, the end statement would be aligned with the begin
     statement.

d)   There are 80 columns in each row as you look at the Turbo edit
     screen. However, you are allowed to type in the text beyond the
     80th column. But as you continue typing in the text, the columns
     on the left side of the screen will be cut off.  If you want to
     view the contents of the whole line, you can use the Home key or
     the End key. One potential danger of this situation is that you
     might miss some part of the statement without realizing that
     there are some more text beyond the 80th column.  Therefore, for
     example, if you have to type in a very long writeln statement, it
     is strongly suggested that you use the comma to break the writeln
     statement into two or more lines. An example will be like

     writeln ('This is a very long writeln statement which ',
              'indicates the use of comma to separate the ',
              'statement into three lines');  

THE RESTORE COMMAND:   If you have accidentally just erased a line or
messed up a line, you can have it restored by using the Restore
command from the Edit menu by pressing Alt-e r 

INSERTING A NEW LINE BETWEEN TWO EXISTING LINES:  Move the cursor to
the first of the two lines, press End and then press ENTER. The cursor
will now be on a blank line between the first and second line.

YOU ARE NOW READY TO DO ADVANCED EDITING ACTIVITY A IN APPENDIX H

=============================================================================
ACTIVITY B    -    SEARCH AND REPLACE OPERATIONS

              /    Search and Replace Choice from the Search Menu


SEARCH    The Search choice from the Search menu allows you to search
for specified text throughout a given file.

REPLACE   The Replace choice from the Search menu allows you to
replace either all or just selected occurrences of one string with
another string throughout an entire file. For example, you could
change a variable name from Total to WageTot throughout a program by
using the Replace choice.
 
a)   press Alt-s r to select the Replace choice from the Search menu
b)   type Total in the Text to find box and then press Tab
c)   type WageTot in the New text box and then press Tab
d)   the cursor will be in the Options box. Since you want to replace
     all the occurrences of tot with WageTot, you must erase the [X]
     next to the choice called Prompt on replace. First position the
     cursor at the X and then press the space bar. The space bar
     toggles between a blank and an X.
e)   press a to choose the Change all choice and all the occurrences
     of tot will be replaced by WageTot simultaneously.
f)   If you want to replace the occurrences of Total with WageTot
     selectively, make sure you mark an X next to Prompt on replace in
     step e). Then press a for Change all. When Turbo prompts you to
     replace an occurrence of Total, press y to initiate the action.
 
 
YOU ARE NOW READY TO DO ADVANCED EDITING ACTIVITY B IN APPENDIX H

=============================================================================
ACTIVITY C    -    BLOCK  OPERATIONS

              /    Marking a Block
              /    Unmarking a Block
              /    Copying, Moving, and Erasing a Block


BLOCK OPERATIONS

You can mark a portion of a program as a block. While a block is
marked, it can be copied, moved, or deleted. 
 
MARKING A BLOCK:   To mark the beginning of a block, move the cursor
to the beginning of the desired block and press Ctrl-k b. To mark the
end, move the cursor just past the last character of the block and
press Ctrl-k k. All the text in the marked block will be highlighted. 
 
UNMARKING A BLOCK:  The computer remembers the current position for
begin and end markers. If the end marker is earlier in the file than
the begin marker, then no block will be highlighted. Thus, to unmark a
block, position the cursor anywhere in the file before the highlight
and press Ctrl-k k. 
 

OPERATIONS WITHIN A SINGLE FILE:  For the following three operations
assume that a block has been marked.

  COPYING A BLOCK - This means making a second copy of the block
  at another location in the file. To do so, position the cursor
  at the desired new location and press Ctrl-k c (the c is for
  copy). 
 
  MOVING A BLOCK -  This means moving the block to another location
  and erasing the original copy. To do so, position the cursor
  at the desired new location and press Ctrl-k v (the v is for
  move). 
 
  ERASING A BLOCK - Nothing needs to be done with the cursor. Just
  press Ctrl-k y.


YOU ARE NOW READY TO DO ADVANCED EDITING ACTIVITY C IN APPENDIX H

=============================================================================
ACTIVITY D    -    THE CLIPBOARD

              /    Copying or Moving a Block to Another File
              /    The Clipboard Commands
 

THE CLIPBOARD    Let us consider the clipboard commands

    KEYS            FUNCTION

    Alt-e c         copies the marked block to the clipboard

    Alt-e t         cuts (i.e. moves) the marked block to the
                    clipboard. (Be aware that for the two commands
                    Alt-e c and Alt-e t, the marked block will be 
                    appended to the bottom of the clipboard as a
                    marked block.) 

    Alt-e p         copies the currently marked block from the
                    clipboard 

    Alt-e s         shows the contents of the clipboard (Be aware
                    that when the clipboard is displayed, it can
                    be edited and marked in the same way you would
                    be in an ordinary file.) 
 
COPYING OR MOVING A BLOCK TO ANOTHER FILE: In Turbo, this can be done
by using a temporary buffer known as the clipboard.

COPYING:  To copy a block from one file to another, for example, from
block1.pas to ex5.pas
a)   open both files and make block1.pas the active window (press F6
     as many times as necessary) 
b)   mark the desired block in ex5.pas 
c)   press Alt-e c to copy this block to the clipboard 
d)   make ex5.pas the active window and move the cursor to where you
     want to insert the block 
e)   press Alt-e p to paste (i.e. copy) the block from the clipboard
     to the cursor position in the active window 
 
MOVING:  Moving a block from one file to another is done the same way
as copying, except that in Step c) you should press Alt-e t to cut
(i.e. move) the block to the clipboard. 


YOU ARE NOW READY TO DO ADVANCED EDITING ACTIVITY D IN APPENDIX H
