program MovingObjects2;
uses crt;
type
  MovingObj = Object
    x: integer;
    y: integer;
    shape: char;
    procedure Init (xx, yy: integer; shp: char);
    procedure MoveHoriz (dist: integer);
  end;

  ColObj = object(MovingObj)
    color: byte;
    procedure Init (xx, yy: integer; shp: char; col: byte);
    procedure MoveHoriz (dist: integer);
  end;

procedure MovingObj.Init (xx, yy: integer; shp: char);
  begin
    x := xx;
    y := yy;
    shape := shp;
    gotoxy (x, y);
    write (shape)
  end;

procedure MovingObj.MoveHoriz (dist: integer);
  var i, increm: integer;
  begin
    if dist > 0
      then increm := 1
      else increm := -1;
    for i := 1 to abs (dist) do
      begin
        gotoXY (x, y);
        write (' ');
        x := x + increm;
        gotoXY (x, y);
        write (shape);
        delay (200)
      end
  end;

procedure ColObj.Init (xx, yy: integer; shp: char; col: byte);
  begin
    color := col;
    textcolor (color);
    MovingObj.Init (xx, yy, shp)
  end;

procedure ColObj.MoveHoriz (dist: integer);
  begin
    textcolor (color);
    MovingObj.MoveHoriz (dist)
  end;

var ColFace, ColHeart: ColObj;
begin
  clrscr;
  ColFace.Init (2, 8, chr(2), red);
  ColHeart.Init (2, 15, chr(3), green);
  ColFace.MoveHoriz (10);
  ColHeart.MoveHoriz (20);
  ColFace.MoveHoriz (-8);
  readln
end.
