program MovingObjects;
uses crt;
type
  MovingObj = Object
    x: integer;
    y: integer;
    shape: char;
    procedure Init (xx, yy: integer; shp: char);
    procedure MoveHoriz (dist: integer);
  end;

procedure MovingObj.Init (xx, yy: integer; shp: char);
  begin
    x := xx;
    y := yy;
    shape := shp;
    gotoxy (x, y);
    write (shape)
  end;

procedure MovingObj.MoveHoriz (dist: integer);
  var i, increm: integer;
  begin
    if dist > 0
      then increm := 1
      else increm := -1;
    for i := 1 to abs (dist) do
      begin
        gotoXY (x, y);
        write (' ');
        x := x + increm;
        gotoXY (x, y);
        write (shape);
        delay (200)
      end
  end;

var face, heart: MovingObj;
begin
  clrscr;
  face.Init (2, 8, chr(2));
  heart.Init (2, 15, chr(3));
  face.MoveHoriz (10);
  heart.MoveHoriz (20);
  face.MoveHoriz (-8);
  readln
end.
