program ch21_p370;
const maxsize = 30;
type
  schoolrec = record
    name: string[20];
    socsec: string[11];
    telephone: string[12]
  end; {schoolrec}
  schooltype = array[1..maxsize] of schoolrec;
  str11 = string[11];
  indexrange = 0..maxsize;
var
  school: schooltype;
  WantedSocSec: str11;
  size, spot: indexrange;

procedure GETDATA (var school: schooltype;
                   var size: indexrange);
  {reads from file into an array of records}
  var SchoolFile: text;
      i: indexrange;
  begin
    assign (SchoolFile, 'school.dat');
    reset (SchoolFile);
    i := 0;
    while not seekeof (SchoolFile) do
      begin
        i := i + 1;
        with school[i] do
          begin
            readln (SchoolFile, name);
            readln (SchoolFile, socsec);
            readln (SchoolFile, telephone)
          end {with}
      end; {while}
    size := i;
    close (SchoolFile)
  end; {GETDATA}

function SEARCH_SOCSEC (school: schooltype;
                        size: indexrange;
                        WantedSocSec: str11): indexrange;
  {returns the subscript of record with WantedSocsec or 0}
  var index: indexrange;
      found: boolean;
  begin
    found := false;
    index := 1;
    repeat
      with school[index] do
        if socsec = WantedSocSec then
          begin
            found := true;
            SEARCH_SOCSEC := index
          end {then}
        else index := index + 1
    until (found) or (index > size);
    if not found then SEARCH_SOCSEC := 0
  end; {SEARCH_SOCSEC}

begin {main}
  GETDATA (school, size);
  write ('enter social security number ');
  readln (WantedSocSec);
  spot := SEARCH_SOCSEC (school, size, WantedSocSec);
  if spot > 0
    then writeln (school[spot].name, ' ', school[spot].telephone)
    else writeln (WantedSocSec, ' not on list')
end.
