{$R+}
program lettergrade;
{drops lowest grade in computing students' marks}
uses printer;
const maxsize = 30;
type
  namestype = array[1..maxsize] of string[15];
  scorestype = array[1..maxsize, 1..4] of integer;
  lowstype = array[1..maxsize] of integer;
  avgtype = array[1..maxsize] of real;
var
  names: namestype;
  scores: scorestype;
  lows: lowstype;
  best3avgs: avgtype;
  size: integer;

procedure GETDATA (var names: namestype;
                   var scores: scorestype;
                   var size: integer);
  {will read data from file and echo it on paper}
  var StudFile: text;
      stud: 1..maxsize;
      exam: 1..4;
  begin
    assign (StudFile, 'scores.dat');
    reset (StudFile);
    readln (StudFile, size);
    writeln (lst, size, ' students');
    for stud := 1 to size do
      begin
        read (StudFile, names[stud]);
        write (lst, names[stud], ' ');
        for exam := 1 to 4 do
          begin
            read (StudFile, scores[stud, exam]);
            write (lst, scores[stud, exam], ' ')
          end; {for exam}
        writeln (lst);
        readln (StudFile)
      end; {for stud}
    close (StudFile);
    writeln (lst)
  end; {GETDATA}

procedure FINDLOWS (scores: scorestype;
                    size: integer;
                    var lows: lowstype);
  {finds each low grade and stores it in an array}
  var stud: 1..maxsize;
      exam: 1..4;
      studmin: integer;
  begin
    for stud := 1 to size do
      begin
        studmin := scores[stud, 1];
        for exam := 2 to 4 do
          if scores[stud, exam] < studmin
            then studmin := scores[stud, exam];
        lows[stud] := studmin
      end {for stud}
  end; {FINDLOWS}

procedure FINDBEST3AVGS (scores: scorestype;
                         size: integer;
                         lows: lowstype;
                         var best3avgs: avgtype);
  {finds average of each student's 3 highest scores}
  var stud: 1..maxsize;
      exam: 1..4;
      sum: integer;
  begin
    for stud := 1 to size do
      begin
        sum := 0;
        for exam := 1 to 4 do
          sum := sum + scores[stud, exam];
        best3avgs[stud] := (sum - lows[stud])/3
      end {for stud}
  end; {FINDBEST3AVGS}

procedure PRINTMARKS (names: namestype;
                      size: integer;
                      best3avgs: avgtype);
  {assigns a letter grade to each student and prints it}
  var stud: 1..maxsize;
      intscore: integer;
      mark: char;
  begin
    writeln (lst, 'Grades');
    for stud := 1 to size do
      begin
        intscore := trunc (best3avgs[stud]);
        case intscore of
          90..100 : mark := 'A';
          80..89  : mark := 'B';
          70..79  : mark := 'C';
          60..69  : mark := 'D';
          else      mark := 'F'
        end; {case}
        writeln (lst, names[stud], ' ', mark)
      end {for stud}
  end; {PRINTMARKS}

begin {main}
  GETDATA (names, scores, size);
  FINDLOWS (scores, size, lows);
  FINDBEST3AVGS (scores, size, lows, best3avgs);
  PRINTMARKS (names, size, best3avgs)
end.


