{$R+}
program HighScorers;
{prints names of students with highest score}
const maxsize = 30;
type str_array = array [1..maxsize] of string;
     scorerange = 0..100;
     num_array = array [1..maxsize] of scorerange;
var scores: num_array;
    names: str_array;
    size: integer;
    maxscore: scorerange;

procedure GETDATA (var scores: num_array;
                   var names: str_array;
                   var size: integer);
  {reads all the data into parallel arrays}
  var GradeFile: text;
  begin
    assign (GradeFile, 'scores.dat');
    reset (GradeFile);
    size := 0;
    while not seekeof (GradeFile) do
      begin
        size := size + 1;
        readln (GradeFile, names[size]);
        readln (GradeFile, scores[size])
      end;
    close (GradeFile)
  end; {GETDATA}

function FINDMAX (scores: num_array;
                  size: integer): scorerange;
  {finds the highest score}
  var i: integer;
      maxsofar: scorerange;
  begin
    maxsofar := scores[1];
    for i := 2 to size do
      if scores[i] > maxsofar then
        maxsofar := scores[i];
    FINDMAX := maxsofar
  end; {FINDMAX}

procedure PRINTACHIEVERS (maxscore: scorerange;
                          scores: num_array;
                          names: str_array;
                          size: integer);
  {prints names of those achieving the highest score}
  var i: integer;
  begin
    for i := 1 to size do
      if scores[i] = maxscore then
        writeln (names[i])
  end; {PRINTACHIEVERS}

begin  {main}
  GETDATA (scores, names, size);
  maxscore := FINDMAX (scores, size);
  writeln ('Highest grade ', maxscore);
  writeln ('Achieved by: ');
  PRINTACHIEVERS (maxscore, scores, names, size)
end.



